/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.SourceCallback;
import com.stripe.android.TokenCallback;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import com.stripe.android.net.PollingResponse;
import com.stripe.android.net.PollingResponseHandler;
import com.stripe.android.net.RequestOptions;
import com.stripe.android.net.StripeApiHandler;
import com.stripe.android.util.StripeNetworkUtils;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stripe {
    SourceCreator mSourceCreator = new SourceCreator(){

        @Override
        public void create(final @NonNull SourceParams sourceParams, final @NonNull String publishableKey, @Nullable Executor executor, final @NonNull SourceCallback sourceCallback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        Source source = StripeApiHandler.createSourceOnServer(Stripe.this.mContext, sourceParams, publishableKey);
                        return new ResponseWrapper(source);
                    }
                    catch (StripeException stripeException) {
                        return new ResponseWrapper(stripeException);
                    }
                }

                protected void onPostExecute(ResponseWrapper responseWrapper) {
                    if (responseWrapper.source != null) {
                        sourceCallback.onSuccess(responseWrapper.source);
                    } else if (responseWrapper.error != null) {
                        sourceCallback.onError(responseWrapper.error);
                    }
                }
            };
            Stripe.this.executeTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)((AsyncTask)task));
        }
    };
    @VisibleForTesting
    TokenCreator mTokenCreator = new TokenCreator(){

        @Override
        public void create(final Map<String, Object> tokenParams, final String publishableKey, final @NonNull String tokenType, Executor executor, final TokenCallback callback) {
            AsyncTask<Void, Void, ResponseWrapper> task = new AsyncTask<Void, Void, ResponseWrapper>(){

                protected ResponseWrapper doInBackground(Void ... params) {
                    try {
                        RequestOptions requestOptions = RequestOptions.builder(publishableKey).build();
                        Token token = StripeApiHandler.createTokenOnServer(Stripe.this.mContext, tokenParams, requestOptions, tokenType, Stripe.this.mLoggingResponseListener);
                        return new ResponseWrapper(token);
                    }
                    catch (StripeException e) {
                        return new ResponseWrapper(e);
                    }
                }

                protected void onPostExecute(ResponseWrapper result) {
                    Stripe.this.tokenTaskPostExecution(result, callback);
                }
            };
            Stripe.this.executeTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)((AsyncTask)task));
        }
    };
    private Context mContext;
    private StripeApiHandler.LoggingResponseListener mLoggingResponseListener;
    private String mDefaultPublishableKey;

    public Stripe(@NonNull Context context) {
        this.mContext = context;
    }

    public Stripe(@NonNull Context context, String publishableKey) {
        this.mContext = context;
        this.setDefaultPublishableKey(publishableKey);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull TokenCallback callback) {
        this.createBankAccountToken(bankAccount, this.mDefaultPublishableKey, null, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (bankAccount == null) {
            throw new RuntimeException("Required parameter: 'bankAccount' is requred to create a token");
        }
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromBankAccount(this.mContext, bankAccount), publishableKey, "bank_account", executor, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull TokenCallback callback) {
        this.createPiiToken(personalId, this.mDefaultPublishableKey, null, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromPersonalId(this.mContext, personalId), publishableKey, "pii", executor, callback);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccountTokenSynchronous(bankAccount, this.mDefaultPublishableKey);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey).build();
        return StripeApiHandler.createTokenOnServer(this.mContext, StripeNetworkUtils.hashMapFromBankAccount(this.mContext, bankAccount), requestOptions, "bank_account", this.mLoggingResponseListener);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback) {
        this.createSource(sourceParams, callback, null, null);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback, @Nullable String publishableKey, @Nullable Executor executor) {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return;
        }
        this.mSourceCreator.create(sourceParams, apiKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (card == null) {
            throw new RuntimeException("Required Parameter: 'card' is required to create a token");
        }
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromCard(this.mContext, card), publishableKey, "card", executor, callback);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createSourceSynchronous(params, null);
    }

    public Source createSourceSynchronous(@NonNull SourceParams params, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return StripeApiHandler.createSourceOnServer(null, this.mContext, params, apiKey, this.mLoggingResponseListener);
    }

    public Token createTokenSynchronous(Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.mDefaultPublishableKey);
    }

    public Token createTokenSynchronous(Card card, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey).build();
        return StripeApiHandler.createTokenOnServer(this.mContext, StripeNetworkUtils.hashMapFromCard(this.mContext, card), requestOptions, "card", this.mLoggingResponseListener);
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createPiiTokenSynchronous(personalId, this.mDefaultPublishableKey);
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey).build();
        return StripeApiHandler.createTokenOnServer(this.mContext, StripeNetworkUtils.hashMapFromPersonalId(this.mContext, personalId), requestOptions, "pii", this.mLoggingResponseListener);
    }

    @Deprecated
    public void pollSource(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @Nullable String publishableKey, @NonNull PollingResponseHandler callback, @Nullable Integer timeoutMs) {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return;
        }
        StripeApiHandler.pollSource(sourceId, clientSecret, apiKey, callback, timeoutMs);
    }

    @Deprecated
    public PollingResponse pollSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @Nullable String publishableKey, @Nullable Integer timeoutMs) {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return StripeApiHandler.pollSourceSynchronous(sourceId, clientSecret, apiKey, timeoutMs);
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retrieveSourceSynchronous(sourceId, clientSecret, null);
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String apiKey;
        String string = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return StripeApiHandler.retrieveSource(sourceId, clientSecret, apiKey);
    }

    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) {
        this.validateKey(publishableKey);
        this.mDefaultPublishableKey = publishableKey;
    }

    @VisibleForTesting
    void setLoggingResponseListener(StripeApiHandler.LoggingResponseListener listener) {
        this.mLoggingResponseListener = listener;
    }

    private void createTokenFromParams(@NonNull Map<String, Object> tokenParams, @NonNull @Size(min=1L) String publishableKey, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (callback == null) {
            throw new RuntimeException("Required Parameter: 'callback' is required to use the created token and handle errors");
        }
        this.validateKey(publishableKey);
        this.mTokenCreator.create(tokenParams, publishableKey, tokenType, executor, callback);
    }

    private void validateKey(@NonNull @Size(min=1L) String publishableKey) {
        if (publishableKey == null || publishableKey.length() == 0) {
            throw new IllegalArgumentException("Invalid Publishable Key: You must use a valid publishable key to create a token.  For more info, see https://stripe.com/docs/stripe.js.");
        }
        if (publishableKey.startsWith("sk_")) {
            throw new IllegalArgumentException("Invalid Publishable Key: You are using a secret key to create a token, instead of the publishable one. For more info, see https://stripe.com/docs/stripe.js");
        }
    }

    private void tokenTaskPostExecution(ResponseWrapper result, TokenCallback callback) {
        if (result.token != null) {
            callback.onSuccess(result.token);
        } else if (result.error != null) {
            callback.onError(result.error);
        } else {
            callback.onError(new RuntimeException("Somehow got neither a token response or an error response"));
        }
    }

    private void executeTask(Executor executor, AsyncTask<Void, Void, ResponseWrapper> task) {
        if (executor != null && Build.VERSION.SDK_INT > 11) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(Map<String, Object> var1, String var2, @NonNull String var3, Executor var4, TokenCallback var5);
    }

    static interface SourceCreator {
        public void create(@NonNull SourceParams var1, @NonNull String var2, @Nullable Executor var3, @NonNull SourceCallback var4);
    }

    private class ResponseWrapper {
        final Source source;
        final Token token;
        final Exception error;

        private ResponseWrapper(Token token) {
            this.token = token;
            this.source = null;
            this.error = null;
        }

        private ResponseWrapper(Source source) {
            this.source = source;
            this.error = null;
            this.token = null;
        }

        private ResponseWrapper(Exception error) {
            this.error = error;
            this.source = null;
            this.token = null;
        }
    }
}

