/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Size;
import com.stripe.android.CardUtils;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.R;
import com.stripe.android.model.Card;
import com.stripe.android.model.ModelUtils;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004`abcB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010E\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010F\u001a\u0004\u0018\u00010\b2\b\u0010A\u001a\u0004\u0018\u00010\b2\b\u00105\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010H0<H\u0002J\u0013\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010HH\u0096\u0002J\n\u0010L\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010M\u001a\u00020(H\u0016J\u0014\u0010N\u001a\u0004\u0018\u00010\b2\b\u0010A\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010O\u001a\u00020\u0005J\u0014\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020H0<H\u0016J\u0006\u0010Q\u001a\u00020RJ\u0010\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020\u0000H\u0002J\u0006\u0010U\u001a\u00020JJ\u0006\u0010V\u001a\u00020JJ\u0015\u0010V\u001a\u00020J2\u0006\u0010W\u001a\u00020XH\u0000\u00a2\u0006\u0002\bYJ\u0006\u0010Z\u001a\u00020JJ\u0015\u0010[\u001a\u00020J2\u0006\u0010W\u001a\u00020XH\u0000\u00a2\u0006\u0002\b\\J\u0006\u0010]\u001a\u00020JJ\u0015\u0010]\u001a\u00020J2\u0006\u0010W\u001a\u00020XH\u0000\u00a2\u0006\u0002\b^J\u0006\u0010_\u001a\u00020JR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u001b\u0010\u0019\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\nR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\nR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\nR\u0013\u0010!\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u0013\u0010#\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\nR\u0013\u0010%\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\nR\u0017\u0010'\u001a\u0004\u0018\u00010(8G\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0015\u0010,\u001a\u0004\u0018\u00010(\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b-\u0010*R\u0013\u0010.\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\nR\u001b\u00100\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u000e\n\u0000\u0012\u0004\b1\u0010\u001b\u001a\u0004\b2\u0010\nR\u0016\u00103\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\nR\u0018\u00105\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\nR\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\b08X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001f\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0013\u0010?\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\nR\u0013\u0010A\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\nR\u0016\u0010C\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\n\u00a8\u0006d"}, d2={"Lcom/stripe/android/model/Card;", "Lcom/stripe/android/model/StripeModel;", "Lcom/stripe/android/model/StripePaymentSource;", "Lcom/stripe/android/model/StripeParamsModel;", "builder", "Lcom/stripe/android/model/Card$Builder;", "(Lcom/stripe/android/model/Card$Builder;)V", "addressCity", "", "getAddressCity", "()Ljava/lang/String;", "addressCountry", "getAddressCountry", "addressLine1", "getAddressLine1", "addressLine1Check", "getAddressLine1Check", "addressLine2", "getAddressLine2", "addressState", "getAddressState", "addressZip", "getAddressZip", "addressZipCheck", "getAddressZipCheck", "brand", "brand$annotations", "()V", "getBrand", "country", "getCountry", "currency", "getCurrency", "customerId", "getCustomerId", "cvc", "getCvc", "cvcCheck", "getCvcCheck", "expMonth", "", "getExpMonth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "expYear", "getExpYear", "fingerprint", "getFingerprint", "funding", "funding$annotations", "getFunding", "id", "getId", "last4", "getLast4", "loggingTokens", "", "getLoggingTokens$stripe_release", "()Ljava/util/List;", "metadata", "", "getMetadata", "()Ljava/util/Map;", "name", "getName", "number", "getNumber", "tokenizationMethod", "getTokenizationMethod$stripe_release", "calculateBrand", "calculateLast4", "createCardParams", "", "equals", "", "other", "getCVC", "hashCode", "normalizeCardNumber", "toBuilder", "toParamMap", "toPaymentMethodParamsCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "typedEquals", "card", "validateCVC", "validateCard", "now", "Ljava/util/Calendar;", "validateCard$stripe_release", "validateExpMonth", "validateExpYear", "validateExpYear$stripe_release", "validateExpiryDate", "validateExpiryDate$stripe_release", "validateNumber", "Builder", "CardBrand", "Companion", "FundingType", "stripe_release"})
public final class Card
extends StripeModel
implements StripePaymentSource,
StripeParamsModel {
    @Nullable
    private final String number;
    @Nullable
    private final String cvc;
    @Nullable
    private final Integer expMonth;
    @Nullable
    private final Integer expYear;
    @Nullable
    private final String name;
    @Nullable
    private final String addressLine1;
    @Nullable
    private final String addressLine1Check;
    @Nullable
    private final String addressLine2;
    @Nullable
    private final String addressCity;
    @Nullable
    private final String addressState;
    @Nullable
    private final String addressZip;
    @Nullable
    private final String addressZipCheck;
    @Nullable
    private final String addressCountry;
    @Size(value=4L)
    @Nullable
    private final String last4;
    @Nullable
    private final String brand;
    @Nullable
    private final String funding;
    @Nullable
    private final String fingerprint;
    @Nullable
    private final String country;
    @Nullable
    private final String currency;
    @Nullable
    private final String customerId;
    @Nullable
    private final String cvcCheck;
    @Nullable
    private final String id;
    @NotNull
    private final List<String> loggingTokens;
    @Nullable
    private final String tokenizationMethod;
    @Nullable
    private final Map<String, String> metadata;
    public static final int CVC_LENGTH_AMERICAN_EXPRESS = 4;
    public static final int CVC_LENGTH_COMMON = 3;
    @NotNull
    private static final String[] PREFIXES_AMERICAN_EXPRESS;
    @NotNull
    private static final String[] PREFIXES_DISCOVER;
    @NotNull
    private static final String[] PREFIXES_JCB;
    @NotNull
    private static final String[] PREFIXES_DINERS_CLUB;
    @NotNull
    private static final String[] PREFIXES_VISA;
    @NotNull
    private static final String[] PREFIXES_MASTERCARD;
    @NotNull
    private static final String[] PREFIXES_UNIONPAY;
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    @NotNull
    public static final String VALUE_CARD = "card";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ADDRESS_CITY = "address_city";
    private static final String FIELD_ADDRESS_COUNTRY = "address_country";
    private static final String FIELD_ADDRESS_LINE1 = "address_line1";
    private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    private static final String FIELD_ADDRESS_LINE2 = "address_line2";
    private static final String FIELD_ADDRESS_STATE = "address_state";
    private static final String FIELD_ADDRESS_ZIP = "address_zip";
    private static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    private static final String FIELD_BRAND = "brand";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_CVC_CHECK = "cvc_check";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_FUNDING = "funding";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TOKENIZATION_METHOD = "tokenization_method";
    private static final Companion.BRAND_RESOURCE_MAP.1 BRAND_RESOURCE_MAP;
    public static final Companion Companion;

    @Nullable
    public final String getNumber() {
        return this.number;
    }

    @Nullable
    public final String getCvc() {
        return this.cvc;
    }

    @IntRange(from=1L, to=12L)
    @Nullable
    public final Integer getExpMonth() {
        return this.expMonth;
    }

    @Nullable
    public final Integer getExpYear() {
        return this.expYear;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getAddressLine1() {
        return this.addressLine1;
    }

    @Nullable
    public final String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Nullable
    public final String getAddressLine2() {
        return this.addressLine2;
    }

    @Nullable
    public final String getAddressCity() {
        return this.addressCity;
    }

    @Nullable
    public final String getAddressState() {
        return this.addressState;
    }

    @Nullable
    public final String getAddressZip() {
        return this.addressZip;
    }

    @Nullable
    public final String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Nullable
    public final String getAddressCountry() {
        return this.addressCountry;
    }

    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    public static /* synthetic */ void brand$annotations() {
    }

    @Nullable
    public final String getBrand() {
        return this.brand;
    }

    public static /* synthetic */ void funding$annotations() {
    }

    @Nullable
    public final String getFunding() {
        return this.funding;
    }

    @Nullable
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public final String getCountry() {
        return this.country;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Nullable
    public final String getCustomerId() {
        return this.customerId;
    }

    @Nullable
    public final String getCvcCheck() {
        return this.cvcCheck;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @NotNull
    public final List<String> getLoggingTokens$stripe_release() {
        return this.loggingTokens;
    }

    @Nullable
    public final String getTokenizationMethod$stripe_release() {
        return this.tokenizationMethod;
    }

    @Nullable
    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Deprecated(message="getCVC() is deprecated", replaceWith=@ReplaceWith(imports={}, expression="Use getCvc()"))
    @Nullable
    public final String getCVC() {
        return this.cvc;
    }

    @NotNull
    public final PaymentMethodCreateParams.Card toPaymentMethodParamsCard() {
        return new PaymentMethodCreateParams.Card.Builder().setNumber(this.number).setCvc(this.cvc).setExpiryMonth(this.expMonth).setExpiryYear(this.expYear).build();
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this.number, this.expMonth, this.expYear, this.cvc).name(this.name).addressLine1(this.addressLine1).addressLine1Check(this.addressLine1Check).addressLine2(this.addressLine2).addressCity(this.addressCity).addressState(this.addressState).addressZip(this.addressZip).addressZipCheck(this.addressZipCheck).addressCountry(this.addressCountry).brand(this.brand).fingerprint(this.fingerprint).funding(this.funding).country(this.country).currency(this.currency).customer(this.customerId).cvcCheck(this.cvcCheck).last4(this.last4).id(this.getId()).tokenizationMethod(this.tokenizationMethod).metadata(this.metadata).loggingTokens(this.loggingTokens);
    }

    public final boolean validateCard() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateCard$stripe_release(calendar);
    }

    public final boolean validateNumber() {
        return CardUtils.isValidCardNumber(this.number);
    }

    public final boolean validateExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateExpiryDate$stripe_release(calendar);
    }

    public final boolean validateCVC() {
        CharSequence charSequence = this.cvc;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string2 = this.cvc;
        bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cvcValue = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String updatedType = this.brand;
        boolean validLength = updatedType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || Intrinsics.areEqual((Object)"American Express", (Object)updatedType) && cvcValue.length() == 4 || cvcValue.length() == 3;
        return ModelUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpMonth() {
        Integer n = this.expMonth;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int expMonth = ((Number)n2).intValue();
        boolean bl3 = false;
        int n3 = expMonth;
        if (1 > n3) return false;
        if (12 < n3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpYear$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer n = this.expYear;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        if (ModelUtils.hasYearPassed(it, now)) return false;
        return true;
    }

    private final String calculateLast4(String number, String last4) {
        String string2;
        CharSequence charSequence = last4;
        int n = 0;
        boolean bl = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            string2 = last4;
        } else if (number != null && number.length() > 4) {
            charSequence = number;
            n = number.length() - 4;
            bl = false;
            String string3 = ((String)charSequence).substring(n);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String calculateBrand(String brand) {
        String string2;
        CharSequence charSequence = brand;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = this.number;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                string2 = CardUtils.getPossibleCardType(this.number);
                return string2;
            }
        }
        string2 = brand;
        return string2;
    }

    public final boolean validateCard$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        return this.cvc == null ? this.validateNumber() && this.validateExpiryDate$stripe_release(now) : this.validateNumber() && this.validateExpiryDate$stripe_release(now) && this.validateCVC();
    }

    public final boolean validateExpiryDate$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer expMonth = this.expMonth;
        if (expMonth == null || !this.validateExpMonth()) {
            return false;
        }
        return this.expYear == null || !this.validateExpYear$stripe_release(now) ? false : !ModelUtils.hasMonthPassed(this.expYear, expMonth, now);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String normalizeCardNumber(String number) {
        String string2 = number;
        String string3 = string2;
        if (string2 == null) return null;
        String string4 = string3;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        string3 = string6;
        if (string6 == null) return null;
        CharSequence charSequence = string3;
        String string7 = "\\s+|-";
        boolean bl2 = false;
        string7 = new Regex(string7);
        String string8 = "";
        boolean bl3 = false;
        String string9 = string7.replace(charSequence, string8);
        return string9;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof Card ? this.typedEquals((Card)other) : false);
    }

    private final boolean typedEquals(Card card) {
        return Intrinsics.areEqual((Object)this.number, (Object)card.number) && Intrinsics.areEqual((Object)this.cvc, (Object)card.cvc) && Intrinsics.areEqual((Object)this.expMonth, (Object)card.expMonth) && Intrinsics.areEqual((Object)this.expYear, (Object)card.expYear) && Intrinsics.areEqual((Object)this.name, (Object)card.name) && Intrinsics.areEqual((Object)this.addressLine1, (Object)card.addressLine1) && Intrinsics.areEqual((Object)this.addressLine1Check, (Object)card.addressLine1Check) && Intrinsics.areEqual((Object)this.addressLine2, (Object)card.addressLine2) && Intrinsics.areEqual((Object)this.addressCity, (Object)card.addressCity) && Intrinsics.areEqual((Object)this.addressState, (Object)card.addressState) && Intrinsics.areEqual((Object)this.addressZip, (Object)card.addressZip) && Intrinsics.areEqual((Object)this.addressZipCheck, (Object)card.addressZipCheck) && Intrinsics.areEqual((Object)this.addressCountry, (Object)card.addressCountry) && Intrinsics.areEqual((Object)this.last4, (Object)card.last4) && Intrinsics.areEqual((Object)this.brand, (Object)card.brand) && Intrinsics.areEqual((Object)this.funding, (Object)card.funding) && Intrinsics.areEqual((Object)this.fingerprint, (Object)card.fingerprint) && Intrinsics.areEqual((Object)this.country, (Object)card.country) && Intrinsics.areEqual((Object)this.currency, (Object)card.currency) && Intrinsics.areEqual((Object)this.customerId, (Object)card.customerId) && Intrinsics.areEqual((Object)this.cvcCheck, (Object)card.cvcCheck) && Intrinsics.areEqual((Object)this.getId(), (Object)card.getId()) && Intrinsics.areEqual(this.loggingTokens, card.loggingTokens) && Intrinsics.areEqual((Object)this.tokenizationMethod, (Object)card.tokenizationMethod) && Intrinsics.areEqual(this.metadata, card.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.number, this.cvc, this.expMonth, this.expYear, this.name, this.addressLine1, this.addressLine1Check, this.addressLine2, this.addressCity, this.addressState, this.addressZip, this.addressZipCheck, this.addressCountry, this.last4, this.brand, this.funding, this.fingerprint, this.country, this.currency, this.customerId, this.cvcCheck, this.getId(), this.loggingTokens, this.tokenizationMethod, this.metadata);
    }

    @Override
    @NotNull
    public Map<String, Object> toParamMap() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)VALUE_CARD, this.createCardParams()));
    }

    private final Map<String, Object> createCardParams() {
        Pair[] pairArray;
        String string2 = this.number;
        String string3 = "number";
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[12];
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.cvc;
        string3 = "cvc";
        n = 1;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl6 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        Pair[] pairArray3 = pairArray2;
        pairArray2[2] = TuplesKt.to((Object)FIELD_EXP_MONTH, (Object)this.expMonth);
        pairArray3[3] = TuplesKt.to((Object)FIELD_EXP_YEAR, (Object)this.expYear);
        string2 = this.name;
        string3 = FIELD_NAME;
        n = 4;
        pairArray = pairArray3;
        pairArray2 = pairArray3;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl7 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.currency;
        string3 = FIELD_CURRENCY;
        n = 5;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl8 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressLine1;
        string3 = FIELD_ADDRESS_LINE1;
        n = 6;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl9 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressLine2;
        string3 = FIELD_ADDRESS_LINE2;
        n = 7;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl10 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressCity;
        string3 = FIELD_ADDRESS_CITY;
        n = 8;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl11 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressZip;
        string3 = FIELD_ADDRESS_ZIP;
        n = 9;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl12 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressState;
        string3 = FIELD_ADDRESS_STATE;
        n = 10;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl13 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        string2 = this.addressCountry;
        string3 = FIELD_ADDRESS_COUNTRY;
        n = 11;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl14 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string4 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        pairArray[n] = TuplesKt.to((Object)string3, (Object)string4);
        return MapsKt.mapOf((Pair[])pairArray2);
    }

    private Card(Builder builder) {
        block0: {
            CharSequence charSequence;
            Card card = this;
            boolean bl = false;
            Object object = new ArrayList();
            card.loggingTokens = object;
            Object object2 = this.normalizeCardNumber(builder.getNumber$stripe_release());
            card = this;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = object2;
            boolean bl4 = false;
            CharSequence charSequence2 = it;
            boolean bl5 = false;
            boolean bl6 = false;
            card.number = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            this.expMonth = builder.getExpMonth$stripe_release();
            this.expYear = builder.getExpYear$stripe_release();
            object2 = builder.getCvc$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl7 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.cvc = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getName$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl8 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.name = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressLine1$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl9 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressLine1 = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressLine1Check$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl10 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressLine1Check = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressLine2$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl11 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressLine2 = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressCity$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl12 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressCity = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressState$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl13 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressState = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressZip$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl14 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressZip = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressZipCheck$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl15 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressZipCheck = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getAddressCountry$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl16 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.addressCountry = object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getLast4$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            boolean bl17 = object2 == null || StringsKt.isBlank((CharSequence)object2);
            card.last4 = bl17 ? this.calculateLast4(this.number, builder.getLast4$stripe_release()) : builder.getLast4$stripe_release();
            this.brand = Companion.asCardBrand(builder.getBrand$stripe_release()) == null ? this.calculateBrand(builder.getBrand$stripe_release()) : builder.getBrand$stripe_release();
            object2 = builder.getFingerprint$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl18 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.fingerprint = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = Companion.asFundingType(builder.getFunding$stripe_release());
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl19 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.funding = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getCountry$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl20 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.country = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getCurrency$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl21 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.currency = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getCustomerId$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl22 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.customerId = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getCvcCheck$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl23 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.cvcCheck = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getId$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl24 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.id = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = builder.getTokenizationMethod$stripe_release();
            card = this;
            bl2 = false;
            bl3 = false;
            it = object2;
            boolean bl25 = false;
            charSequence2 = it;
            bl5 = false;
            bl6 = false;
            card.tokenizationMethod = charSequence = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            this.metadata = builder.getMetadata$stripe_release();
            List<String> list = builder.getLoggingTokens$stripe_release();
            if (list == null) break block0;
            object2 = list;
            bl2 = false;
            bl3 = false;
            Object loggingTokens = object2;
            boolean bl26 = false;
            this.loggingTokens.addAll((Collection)loggingTokens);
        }
    }

    static {
        Companion = new Companion(null);
        PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
        PREFIXES_DISCOVER = new String[]{"60", "64", "65"};
        PREFIXES_JCB = new String[]{"35"};
        PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
        PREFIXES_VISA = new String[]{"4"};
        PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55", "67"};
        PREFIXES_UNIONPAY = new String[]{"62"};
        BRAND_RESOURCE_MAP = new HashMap<String, Integer>(){
            {
                this.put("American Express", R.drawable.ic_amex);
                this.put("Diners Club", R.drawable.ic_diners);
                this.put("Discover", R.drawable.ic_discover);
                this.put("JCB", R.drawable.ic_jcb);
                this.put("MasterCard", R.drawable.ic_mastercard);
                this.put("Visa", R.drawable.ic_visa);
                this.put("UnionPay", R.drawable.ic_unionpay);
                this.put("Unknown", R.drawable.ic_unknown);
            }
        };
    }

    public /* synthetic */ Card(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @JvmStatic
    @Nullable
    public static final String asCardBrand(@Nullable String possibleCardType) {
        return Companion.asCardBrand(possibleCardType);
    }

    @JvmStatic
    @Nullable
    public static final String asFundingType(@Nullable String possibleFundingType) {
        return Companion.asFundingType(possibleFundingType);
    }

    @JvmStatic
    @DrawableRes
    public static final int getBrandIcon(@Nullable String brand) {
        return Companion.getBrandIcon(brand);
    }

    @JvmStatic
    @Nullable
    public static final Card fromString(@NotNull String jsonString) {
        return Companion.fromString(jsonString);
    }

    @JvmStatic
    @Nullable
    public static final Card fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    @JvmStatic
    @NotNull
    public static final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
        return Companion.create(number, expMonth, expYear, cvc);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Card$CardBrand;", "", "Companion", "stripe_release"})
    public static @interface CardBrand {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String AMERICAN_EXPRESS = "American Express";
        @NotNull
        public static final String DISCOVER = "Discover";
        @NotNull
        public static final String JCB = "JCB";
        @NotNull
        public static final String DINERS_CLUB = "Diners Club";
        @NotNull
        public static final String VISA = "Visa";
        @NotNull
        public static final String MASTERCARD = "MasterCard";
        @NotNull
        public static final String UNIONPAY = "UnionPay";
        @NotNull
        public static final String UNKNOWN = "Unknown";

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/Card$CardBrand$Companion;", "", "()V", "AMERICAN_EXPRESS", "", "DINERS_CLUB", "DISCOVER", "JCB", "MASTERCARD", "UNIONPAY", "UNKNOWN", "VISA", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String AMERICAN_EXPRESS = "American Express";
            @NotNull
            public static final String DISCOVER = "Discover";
            @NotNull
            public static final String JCB = "JCB";
            @NotNull
            public static final String DINERS_CLUB = "Diners Club";
            @NotNull
            public static final String VISA = "Visa";
            @NotNull
            public static final String MASTERCARD = "MasterCard";
            @NotNull
            public static final String UNIONPAY = "UnionPay";
            @NotNull
            public static final String UNKNOWN = "Unknown";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Card$FundingType;", "", "Companion", "stripe_release"})
    public static @interface FundingType {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String CREDIT = "credit";
        @NotNull
        public static final String DEBIT = "debit";
        @NotNull
        public static final String PREPAID = "prepaid";
        @NotNull
        public static final String UNKNOWN = "unknown";

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/Card$FundingType$Companion;", "", "()V", "CREDIT", "", "DEBIT", "PREPAID", "UNKNOWN", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String CREDIT = "credit";
            @NotNull
            public static final String DEBIT = "debit";
            @NotNull
            public static final String PREPAID = "prepaid";
            @NotNull
            public static final String UNKNOWN = "unknown";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\bA\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0013\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010Z\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010[\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010[\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\\\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010]\u001a\u0004\u0018\u00010\u0004J\u0010\u0010!\u001a\u00020\u00002\b\u0010^\u001a\u0004\u0018\u00010\u0004J\u0010\u0010$\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0004J\b\u0010_\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0010\u0010,\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0010\u0010`\u001a\u00020\u00002\b\u0010/\u001a\u0004\u0018\u00010\u0004J\u0010\u00103\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u00010\u0004J\u0010\u0010:\u001a\u00020\u00002\b\u0010:\u001a\u0004\u0018\u00010\u0004J\u0010\u0010=\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u00010\u0004J\u0010\u0010A\u001a\u00020\u00002\b\u0010A\u001a\u0004\u0018\u00010\u0004J\u0010\u0010D\u001a\u00020\u00002\b\u0010D\u001a\u0004\u0018\u00010\u0004J\u0014\u0010G\u001a\u00020\u00002\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00040HJ\u001c\u0010M\u001a\u00020\u00002\u0014\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010NJ\u0010\u0010S\u001a\u00020\u00002\b\u0010S\u001a\u0004\u0018\u00010\u0004J\u0010\u0010W\u001a\u00020\u00002\b\u0010W\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010\u000eR\u001c\u0010!\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000eR\"\u0010$\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010\u000eR\u001c\u0010)\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\f\"\u0004\b+\u0010\u000eR\u001c\u0010,\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\f\"\u0004\b.\u0010\u000eR\u001c\u0010/\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\f\"\u0004\b1\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\fR\u001c\u00103\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\f\"\u0004\b5\u0010\u000eR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u00108\u001a\u0004\b6\u00107R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u00108\u001a\u0004\b9\u00107R\u001c\u0010:\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\f\"\u0004\b<\u0010\u000eR\"\u0010=\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b>\u0010&\u001a\u0004\b?\u0010\f\"\u0004\b@\u0010\u000eR\u001c\u0010A\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\f\"\u0004\bC\u0010\u000eR \u0010D\u001a\u0004\u0018\u00010\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\f\"\u0004\bF\u0010\u000eR\"\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010HX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR(\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010NX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001c\u0010S\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\f\"\u0004\bU\u0010\u000eR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\fR\u001c\u0010W\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\f\"\u0004\bY\u0010\u000e\u00a8\u0006a"}, d2={"Lcom/stripe/android/model/Card$Builder;", "Lcom/stripe/android/ObjectBuilder;", "Lcom/stripe/android/model/Card;", "number", "", "expMonth", "", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "addressCity", "getAddressCity$stripe_release", "()Ljava/lang/String;", "setAddressCity$stripe_release", "(Ljava/lang/String;)V", "addressCountry", "getAddressCountry$stripe_release", "setAddressCountry$stripe_release", "addressLine1", "getAddressLine1$stripe_release", "setAddressLine1$stripe_release", "addressLine1Check", "getAddressLine1Check$stripe_release", "setAddressLine1Check$stripe_release", "addressLine2", "getAddressLine2$stripe_release", "setAddressLine2$stripe_release", "addressState", "getAddressState$stripe_release", "setAddressState$stripe_release", "addressZip", "getAddressZip$stripe_release", "setAddressZip$stripe_release", "addressZipCheck", "getAddressZipCheck$stripe_release", "setAddressZipCheck$stripe_release", "brand", "brand$annotations", "()V", "getBrand$stripe_release", "setBrand$stripe_release", "country", "getCountry$stripe_release", "setCountry$stripe_release", "currency", "getCurrency$stripe_release", "setCurrency$stripe_release", "customerId", "getCustomerId$stripe_release", "setCustomerId$stripe_release", "getCvc$stripe_release", "cvcCheck", "getCvcCheck$stripe_release", "setCvcCheck$stripe_release", "getExpMonth$stripe_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear$stripe_release", "fingerprint", "getFingerprint$stripe_release", "setFingerprint$stripe_release", "funding", "funding$annotations", "getFunding$stripe_release", "setFunding$stripe_release", "id", "getId$stripe_release", "setId$stripe_release", "last4", "getLast4$stripe_release", "setLast4$stripe_release", "loggingTokens", "", "getLoggingTokens$stripe_release", "()Ljava/util/List;", "setLoggingTokens$stripe_release", "(Ljava/util/List;)V", "metadata", "", "getMetadata$stripe_release", "()Ljava/util/Map;", "setMetadata$stripe_release", "(Ljava/util/Map;)V", "name", "getName$stripe_release", "setName$stripe_release", "getNumber$stripe_release", "tokenizationMethod", "getTokenizationMethod$stripe_release", "setTokenizationMethod$stripe_release", "city", "address", "state", "zip", "zipCheck", "build", "customer", "stripe_release"})
    public static final class Builder
    implements ObjectBuilder<Card> {
        @Nullable
        private String name;
        @Nullable
        private String addressLine1;
        @Nullable
        private String addressLine1Check;
        @Nullable
        private String addressLine2;
        @Nullable
        private String addressCity;
        @Nullable
        private String addressState;
        @Nullable
        private String addressZip;
        @Nullable
        private String addressZipCheck;
        @Nullable
        private String addressCountry;
        @Nullable
        private String brand;
        @Nullable
        private String funding;
        @Size(value=4L)
        @Nullable
        private String last4;
        @Nullable
        private String fingerprint;
        @Nullable
        private String country;
        @Nullable
        private String currency;
        @Nullable
        private String customerId;
        @Nullable
        private String cvcCheck;
        @Nullable
        private String id;
        @Nullable
        private String tokenizationMethod;
        @Nullable
        private Map<String, String> metadata;
        @Nullable
        private List<String> loggingTokens;
        @Nullable
        private final String number;
        @Nullable
        private final Integer expMonth;
        @Nullable
        private final Integer expYear;
        @Nullable
        private final String cvc;

        @Nullable
        public final String getName$stripe_release() {
            return this.name;
        }

        public final void setName$stripe_release(@Nullable String string2) {
            this.name = string2;
        }

        @Nullable
        public final String getAddressLine1$stripe_release() {
            return this.addressLine1;
        }

        public final void setAddressLine1$stripe_release(@Nullable String string2) {
            this.addressLine1 = string2;
        }

        @Nullable
        public final String getAddressLine1Check$stripe_release() {
            return this.addressLine1Check;
        }

        public final void setAddressLine1Check$stripe_release(@Nullable String string2) {
            this.addressLine1Check = string2;
        }

        @Nullable
        public final String getAddressLine2$stripe_release() {
            return this.addressLine2;
        }

        public final void setAddressLine2$stripe_release(@Nullable String string2) {
            this.addressLine2 = string2;
        }

        @Nullable
        public final String getAddressCity$stripe_release() {
            return this.addressCity;
        }

        public final void setAddressCity$stripe_release(@Nullable String string2) {
            this.addressCity = string2;
        }

        @Nullable
        public final String getAddressState$stripe_release() {
            return this.addressState;
        }

        public final void setAddressState$stripe_release(@Nullable String string2) {
            this.addressState = string2;
        }

        @Nullable
        public final String getAddressZip$stripe_release() {
            return this.addressZip;
        }

        public final void setAddressZip$stripe_release(@Nullable String string2) {
            this.addressZip = string2;
        }

        @Nullable
        public final String getAddressZipCheck$stripe_release() {
            return this.addressZipCheck;
        }

        public final void setAddressZipCheck$stripe_release(@Nullable String string2) {
            this.addressZipCheck = string2;
        }

        @Nullable
        public final String getAddressCountry$stripe_release() {
            return this.addressCountry;
        }

        public final void setAddressCountry$stripe_release(@Nullable String string2) {
            this.addressCountry = string2;
        }

        public static /* synthetic */ void brand$annotations() {
        }

        @Nullable
        public final String getBrand$stripe_release() {
            return this.brand;
        }

        public final void setBrand$stripe_release(@Nullable String string2) {
            this.brand = string2;
        }

        public static /* synthetic */ void funding$annotations() {
        }

        @Nullable
        public final String getFunding$stripe_release() {
            return this.funding;
        }

        public final void setFunding$stripe_release(@Nullable String string2) {
            this.funding = string2;
        }

        @Nullable
        public final String getLast4$stripe_release() {
            return this.last4;
        }

        public final void setLast4$stripe_release(@Nullable String string2) {
            this.last4 = string2;
        }

        @Nullable
        public final String getFingerprint$stripe_release() {
            return this.fingerprint;
        }

        public final void setFingerprint$stripe_release(@Nullable String string2) {
            this.fingerprint = string2;
        }

        @Nullable
        public final String getCountry$stripe_release() {
            return this.country;
        }

        public final void setCountry$stripe_release(@Nullable String string2) {
            this.country = string2;
        }

        @Nullable
        public final String getCurrency$stripe_release() {
            return this.currency;
        }

        public final void setCurrency$stripe_release(@Nullable String string2) {
            this.currency = string2;
        }

        @Nullable
        public final String getCustomerId$stripe_release() {
            return this.customerId;
        }

        public final void setCustomerId$stripe_release(@Nullable String string2) {
            this.customerId = string2;
        }

        @Nullable
        public final String getCvcCheck$stripe_release() {
            return this.cvcCheck;
        }

        public final void setCvcCheck$stripe_release(@Nullable String string2) {
            this.cvcCheck = string2;
        }

        @Nullable
        public final String getId$stripe_release() {
            return this.id;
        }

        public final void setId$stripe_release(@Nullable String string2) {
            this.id = string2;
        }

        @Nullable
        public final String getTokenizationMethod$stripe_release() {
            return this.tokenizationMethod;
        }

        public final void setTokenizationMethod$stripe_release(@Nullable String string2) {
            this.tokenizationMethod = string2;
        }

        @Nullable
        public final Map<String, String> getMetadata$stripe_release() {
            return this.metadata;
        }

        public final void setMetadata$stripe_release(@Nullable Map<String, String> map) {
            this.metadata = map;
        }

        @Nullable
        public final List<String> getLoggingTokens$stripe_release() {
            return this.loggingTokens;
        }

        public final void setLoggingTokens$stripe_release(@Nullable List<String> list) {
            this.loggingTokens = list;
        }

        @NotNull
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public final Builder addressLine1(@Nullable String address) {
            this.addressLine1 = address;
            return this;
        }

        @NotNull
        public final Builder addressLine1Check(@Nullable String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
            return this;
        }

        @NotNull
        public final Builder addressLine2(@Nullable String address) {
            this.addressLine2 = address;
            return this;
        }

        @NotNull
        public final Builder addressCity(@Nullable String city) {
            this.addressCity = city;
            return this;
        }

        @NotNull
        public final Builder addressState(@Nullable String state) {
            this.addressState = state;
            return this;
        }

        @NotNull
        public final Builder addressZip(@Nullable String zip) {
            this.addressZip = zip;
            return this;
        }

        @NotNull
        public final Builder addressZipCheck(@Nullable String zipCheck) {
            this.addressZipCheck = zipCheck;
            return this;
        }

        @NotNull
        public final Builder addressCountry(@Nullable String country) {
            this.addressCountry = country;
            return this;
        }

        @NotNull
        public final Builder brand(@Nullable String brand) {
            this.brand = brand;
            return this;
        }

        @NotNull
        public final Builder fingerprint(@Nullable String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @NotNull
        public final Builder funding(@Nullable String funding) {
            this.funding = funding;
            return this;
        }

        @NotNull
        public final Builder country(@Nullable String country) {
            this.country = country;
            return this;
        }

        @NotNull
        public final Builder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        @NotNull
        public final Builder customer(@Nullable String customerId) {
            this.customerId = customerId;
            return this;
        }

        @NotNull
        public final Builder cvcCheck(@Nullable String cvcCheck) {
            this.cvcCheck = cvcCheck;
            return this;
        }

        @NotNull
        public final Builder last4(@Nullable String last4) {
            this.last4 = last4;
            return this;
        }

        @NotNull
        public final Builder id(@Nullable String id2) {
            this.id = id2;
            return this;
        }

        @NotNull
        public final Builder tokenizationMethod(@Nullable String tokenizationMethod) {
            this.tokenizationMethod = tokenizationMethod;
            return this;
        }

        @NotNull
        public final Builder metadata(@Nullable Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @NotNull
        public final Builder loggingTokens(@NotNull List<String> loggingTokens) {
            Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
            this.loggingTokens = loggingTokens;
            return this;
        }

        @Override
        @NotNull
        public Card build() {
            return new Card(this, null);
        }

        @Nullable
        public final String getNumber$stripe_release() {
            return this.number;
        }

        @Nullable
        public final Integer getExpMonth$stripe_release() {
            return this.expMonth;
        }

        @Nullable
        public final Integer getExpYear$stripe_release() {
            return this.expYear;
        }

        @Nullable
        public final String getCvc$stripe_release() {
            return this.cvc;
        }

        public Builder(@Nullable String number, @IntRange(from=1L, to=12L) @Nullable Integer expMonth, @IntRange(from=0L) @Nullable Integer expYear, @Nullable String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u0011\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u00106\u001a\u0004\u0018\u00010\n2\b\u00107\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u00108\u001a\u0004\u0018\u00010\n2\b\u00109\u001a\u0004\u0018\u00010\nH\u0007J5\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\n2\b\u0010=\u001a\u0004\u0018\u00010\u00072\b\u0010>\u001a\u0004\u0018\u00010\u00072\b\u0010?\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010@J\u0014\u0010A\u001a\u0004\u0018\u00010;2\b\u0010B\u001a\u0004\u0018\u00010CH\u0007J\u0012\u0010D\u001a\u0004\u0018\u00010;2\u0006\u0010E\u001a\u00020\nH\u0007J\u0012\u0010F\u001a\u00020\u00072\b\u0010G\u001a\u0004\u0018\u00010\nH\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u0019\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b*\u0010'R\u0019\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b,\u0010'R\u0019\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b.\u0010'R\u0019\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b0\u0010'R\u0019\u00101\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b2\u0010'R\u0019\u00103\u001a\b\u0012\u0004\u0012\u00020\n0%\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b4\u0010'R\u000e\u00105\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/stripe/android/model/Card$Companion;", "", "()V", "BRAND_RESOURCE_MAP", "com/stripe/android/model/Card$Companion$BRAND_RESOURCE_MAP$1", "Lcom/stripe/android/model/Card$Companion$BRAND_RESOURCE_MAP$1;", "CVC_LENGTH_AMERICAN_EXPRESS", "", "CVC_LENGTH_COMMON", "FIELD_ADDRESS_CITY", "", "FIELD_ADDRESS_COUNTRY", "FIELD_ADDRESS_LINE1", "FIELD_ADDRESS_LINE1_CHECK", "FIELD_ADDRESS_LINE2", "FIELD_ADDRESS_STATE", "FIELD_ADDRESS_ZIP", "FIELD_ADDRESS_ZIP_CHECK", "FIELD_BRAND", "FIELD_COUNTRY", "FIELD_CURRENCY", "FIELD_CUSTOMER", "FIELD_CVC_CHECK", "FIELD_EXP_MONTH", "FIELD_EXP_YEAR", "FIELD_FINGERPRINT", "FIELD_FUNDING", "FIELD_ID", "FIELD_LAST4", "FIELD_METADATA", "FIELD_NAME", "FIELD_OBJECT", "FIELD_TOKENIZATION_METHOD", "MAX_LENGTH_AMERICAN_EXPRESS", "MAX_LENGTH_DINERS_CLUB", "MAX_LENGTH_STANDARD", "PREFIXES_AMERICAN_EXPRESS", "", "getPREFIXES_AMERICAN_EXPRESS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "PREFIXES_DINERS_CLUB", "getPREFIXES_DINERS_CLUB", "PREFIXES_DISCOVER", "getPREFIXES_DISCOVER", "PREFIXES_JCB", "getPREFIXES_JCB", "PREFIXES_MASTERCARD", "getPREFIXES_MASTERCARD", "PREFIXES_UNIONPAY", "getPREFIXES_UNIONPAY", "PREFIXES_VISA", "getPREFIXES_VISA", "VALUE_CARD", "asCardBrand", "possibleCardType", "asFundingType", "possibleFundingType", "create", "Lcom/stripe/android/model/Card;", "number", "expMonth", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/model/Card;", "fromJson", "jsonObject", "Lorg/json/JSONObject;", "fromString", "jsonString", "getBrandIcon", "brand", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final String[] getPREFIXES_AMERICAN_EXPRESS() {
            return PREFIXES_AMERICAN_EXPRESS;
        }

        @NotNull
        public final String[] getPREFIXES_DISCOVER() {
            return PREFIXES_DISCOVER;
        }

        @NotNull
        public final String[] getPREFIXES_JCB() {
            return PREFIXES_JCB;
        }

        @NotNull
        public final String[] getPREFIXES_DINERS_CLUB() {
            return PREFIXES_DINERS_CLUB;
        }

        @NotNull
        public final String[] getPREFIXES_VISA() {
            return PREFIXES_VISA;
        }

        @NotNull
        public final String[] getPREFIXES_MASTERCARD() {
            return PREFIXES_MASTERCARD;
        }

        @NotNull
        public final String[] getPREFIXES_UNIONPAY() {
            return PREFIXES_UNIONPAY;
        }

        @JvmStatic
        @Nullable
        public final String asCardBrand(@Nullable String possibleCardType) {
            CharSequence charSequence = possibleCardType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return StringsKt.equals((String)"American Express", (String)possibleCardType, (boolean)true) ? "American Express" : (StringsKt.equals((String)"MasterCard", (String)possibleCardType, (boolean)true) ? "MasterCard" : (StringsKt.equals((String)"Diners Club", (String)possibleCardType, (boolean)true) ? "Diners Club" : (StringsKt.equals((String)"Discover", (String)possibleCardType, (boolean)true) ? "Discover" : (StringsKt.equals((String)"JCB", (String)possibleCardType, (boolean)true) ? "JCB" : (StringsKt.equals((String)"Visa", (String)possibleCardType, (boolean)true) ? "Visa" : (StringsKt.equals((String)"UnionPay", (String)possibleCardType, (boolean)true) ? "UnionPay" : "Unknown"))))));
        }

        @JvmStatic
        @Nullable
        public final String asFundingType(@Nullable String possibleFundingType) {
            CharSequence charSequence = possibleFundingType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return StringsKt.equals((String)"credit", (String)possibleFundingType, (boolean)true) ? "credit" : (StringsKt.equals((String)"debit", (String)possibleFundingType, (boolean)true) ? "debit" : (StringsKt.equals((String)"prepaid", (String)possibleFundingType, (boolean)true) ? "prepaid" : "unknown"));
        }

        @JvmStatic
        @DrawableRes
        public final int getBrandIcon(@Nullable String brand) {
            Integer brandIcon;
            Map map = BRAND_RESOURCE_MAP;
            boolean bl = false;
            Integer n = brandIcon = (Integer)map.get(brand);
            return n != null ? n : R.drawable.ic_unknown;
        }

        @JvmStatic
        @Nullable
        public final Card fromString(@NotNull String jsonString) {
            Card card;
            Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                card = this.fromJson(jsonObject);
            }
            catch (JSONException ignored) {
                card = null;
            }
            return card;
        }

        @JvmStatic
        @Nullable
        public final Card fromJson(@Nullable JSONObject jsonObject) {
            if (jsonObject == null || Intrinsics.areEqual((Object)Card.VALUE_CARD, (Object)jsonObject.optString(Card.FIELD_OBJECT)) ^ true) {
                return null;
            }
            Integer n = StripeJsonUtils.optInteger(jsonObject, Card.FIELD_EXP_MONTH);
            Integer n2 = n != null ? n : -1;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            Integer expMonth = !(it < 1 || it > 12) ? n2 : null;
            Integer n3 = StripeJsonUtils.optInteger(jsonObject, Card.FIELD_EXP_YEAR);
            Integer n4 = n3 != null ? n3 : -1;
            bl2 = false;
            boolean bl4 = false;
            int it2 = ((Number)n4).intValue();
            boolean bl5 = false;
            Integer expYear = !(it2 < 0) ? n4 : null;
            return new Builder(null, expMonth, expYear, null).addressCity(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_CITY)).addressLine1(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE1)).addressLine1Check(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE1_CHECK)).addressLine2(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_LINE2)).addressCountry(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_COUNTRY)).addressState(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_STATE)).addressZip(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_ZIP)).addressZipCheck(StripeJsonUtils.optString(jsonObject, Card.FIELD_ADDRESS_ZIP_CHECK)).brand(this.asCardBrand(StripeJsonUtils.optString(jsonObject, Card.FIELD_BRAND))).country(StripeJsonUtils.optCountryCode(jsonObject, Card.FIELD_COUNTRY)).customer(StripeJsonUtils.optString(jsonObject, Card.FIELD_CUSTOMER)).currency(StripeJsonUtils.optCurrency(jsonObject, Card.FIELD_CURRENCY)).cvcCheck(StripeJsonUtils.optString(jsonObject, Card.FIELD_CVC_CHECK)).funding(this.asFundingType(StripeJsonUtils.optString(jsonObject, Card.FIELD_FUNDING))).fingerprint(StripeJsonUtils.optString(jsonObject, Card.FIELD_FINGERPRINT)).id(StripeJsonUtils.optString(jsonObject, Card.FIELD_ID)).last4(StripeJsonUtils.optString(jsonObject, Card.FIELD_LAST4)).name(StripeJsonUtils.optString(jsonObject, Card.FIELD_NAME)).tokenizationMethod(StripeJsonUtils.optString(jsonObject, Card.FIELD_TOKENIZATION_METHOD)).metadata(StripeJsonUtils.optHash(jsonObject, Card.FIELD_METADATA)).build();
        }

        @JvmStatic
        @NotNull
        public final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
            return new Builder(number, expMonth, expYear, cvc).build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

