/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.Source;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSessionHandler;", "Landroid/os/Handler;", "listener", "Lcom/stripe/android/CustomerSessionHandler$Listener;", "(Lcom/stripe/android/CustomerSessionHandler$Listener;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "Listener", "stripe_release"})
public final class CustomerSessionHandler
extends Handler {
    private final Listener listener;

    public void handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        super.handleMessage(msg);
        Object object = msg.obj;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.util.Pair<kotlin.String, kotlin.Any>");
        }
        Pair messageData = (Pair)object;
        String operationId = (String)messageData.first;
        Object obj = messageData.second;
        switch (msg.what) {
            case 2: {
                Object object2 = obj;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.model.Customer");
                }
                Customer customer = (Customer)object2;
                String string2 = operationId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"operationId");
                this.listener.onCustomerRetrieved(customer, string2);
                break;
            }
            case 3: {
                Object object3 = obj;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.model.Source");
                }
                Source source = (Source)object3;
                String string3 = operationId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"operationId");
                this.listener.onSourceRetrieved(source, string3);
                break;
            }
            case 4: {
                Object object4 = obj;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.model.PaymentMethod");
                }
                PaymentMethod paymentMethod = (PaymentMethod)object4;
                String string4 = operationId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"operationId");
                this.listener.onPaymentMethodRetrieved(paymentMethod, string4);
                break;
            }
            case 5: {
                Object object5 = obj;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.model.Customer");
                }
                this.listener.onCustomerShippingInfoSaved((Customer)object5);
                break;
            }
            case 6: {
                Object object6 = obj;
                if (object6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.stripe.android.model.PaymentMethod>");
                }
                List list = (List)object6;
                String string5 = operationId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"operationId");
                this.listener.onPaymentMethodsRetrieved(list, string5);
                break;
            }
            case 1: {
                if (!(obj instanceof StripeException)) break;
                StripeException stripeException = (StripeException)obj;
                String string6 = operationId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"operationId");
                this.listener.onError(stripeException, string6);
            }
        }
    }

    public CustomerSessionHandler(@NotNull Listener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        super(Looper.getMainLooper());
        this.listener = listener;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001e\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/CustomerSessionHandler$Listener;", "", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "operationId", "", "onCustomerShippingInfoSaved", "onError", "exception", "Lcom/stripe/android/exception/StripeException;", "onPaymentMethodRetrieved", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "onPaymentMethodsRetrieved", "paymentMethods", "", "onSourceRetrieved", "source", "Lcom/stripe/android/model/Source;", "stripe_release"})
    public static interface Listener {
        public void onCustomerRetrieved(@Nullable Customer var1, @NotNull String var2);

        public void onSourceRetrieved(@Nullable Source var1, @NotNull String var2);

        public void onPaymentMethodRetrieved(@Nullable PaymentMethod var1, @NotNull String var2);

        public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> var1, @NotNull String var2);

        public void onCustomerShippingInfoSaved(@Nullable Customer var1);

        public void onError(@NotNull StripeException var1, @NotNull String var2);
    }
}

