/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;

public class StormpathConfiguration {
    public static final String VERSION = "1.0.5";
    private final String apiUrl;

    StormpathConfiguration(Builder builder) {
        this.apiUrl = StormpathConfiguration.normalizeUrl(builder.apiUrl);
    }

    String getBaseUrl() {
        return this.apiUrl;
    }

    String getUrlScheme() {
        List<String> urlSchemeComponents = Arrays.asList(HttpUrl.parse((String)this.apiUrl).host().split("\\."));
        Collections.reverse(urlSchemeComponents);
        String result = "";
        result = urlSchemeComponents.get(0);
        for (int i = 1; i < urlSchemeComponents.size(); ++i) {
            result = result + "." + urlSchemeComponents.get(i);
        }
        return result;
    }

    private static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String normalizeUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static class Builder {
        String apiUrl;

        public Builder baseUrl(String baseUrl) {
            this.apiUrl = baseUrl;
            return this;
        }

        public StormpathConfiguration build() {
            if (this.apiUrl == null) {
                throw new IllegalStateException("baseUrl == null");
            }
            return new StormpathConfiguration(this);
        }
    }
}

