/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import android.os.Build;
import android.support.annotation.NonNull;
import com.squareup.moshi.Json;
import com.squareup.moshi.Moshi;
import com.stormpath.sdk.Platform;
import com.stormpath.sdk.PreferenceStore;
import com.stormpath.sdk.Stormpath;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.StormpathConfiguration;
import com.stormpath.sdk.models.Account;
import com.stormpath.sdk.models.LoginModel;
import com.stormpath.sdk.models.RegistrationForm;
import com.stormpath.sdk.models.SessionTokens;
import com.stormpath.sdk.models.StormpathError;
import com.stormpath.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

class ApiManager {
    private final Platform platform;
    private final OkHttpClient okHttpClient;
    private final Executor callbackExecutor;
    private final StormpathConfiguration config;
    private final PreferenceStore preferenceStore;
    private final Moshi moshi = new Moshi.Builder().build();
    private static String version;

    ApiManager(StormpathConfiguration config, Platform platform) {
        this.config = config;
        this.preferenceStore = platform.preferenceStore();
        this.callbackExecutor = platform.callbackExecutor();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                Stormpath.logger().d(message, new Object[0]);
            }
        });
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.okHttpClient = new OkHttpClient.Builder().dispatcher(new Dispatcher(platform.httpExecutorService())).addNetworkInterceptor((Interceptor)httpLoggingInterceptor).build();
        this.platform = platform;
    }

    void login(String username, String password, StormpathCallback<Void> callback) {
        FormBody formBody = new FormBody.Builder().add("username", username).add("password", password).add("grant_type", "password").build();
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/oauth/token").headers(this.buildStandardHeaders()).post((RequestBody)formBody).build();
        this.okHttpClient.newCall(request).enqueue(new StormpathOAuthTokenCallback<Void>(callback));
    }

    void register(RegistrationForm registrationForm, StormpathCallback<Void> callback) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.moshi.adapter(RegistrationForm.class).toJson((Object)registrationForm));
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/register").headers(this.buildStandardHeaders()).post(body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    void refreshAccessToken(final StormpathCallback<Void> callback) {
        String refreshToken = this.preferenceStore.getRefreshToken();
        if (StringUtils.isBlank(refreshToken)) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), new IllegalStateException("refresh_token was not found, did you forget to login? See debug logs for details.")));
                }
            });
            return;
        }
        Request request = this.buildRefreshTokenRequest(refreshToken);
        this.okHttpClient.newCall(request).enqueue(new StormpathOAuthTokenCallback<Void>(callback));
    }

    void refreshAccessToken() throws IOException {
        String refreshToken = this.preferenceStore.getRefreshToken();
        if (StringUtils.isBlank(refreshToken)) {
            throw new IllegalStateException("refresh_token was not found, did you forget to login? See debug logs for details.");
        }
        Request request = this.buildRefreshTokenRequest(refreshToken);
        Response response = this.okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("refresh token call failed: " + response.code());
        }
        SessionTokens sessionTokens = (SessionTokens)this.moshi.adapter(SessionTokens.class).fromJson(response.body().source());
        if (StringUtils.isBlank(sessionTokens.getAccessToken())) {
            throw new IOException("access_token was not found in response. See debug logs for details.");
        }
        if (StringUtils.isBlank(sessionTokens.getRefreshToken())) {
            Stormpath.logger().e("There was no refresh_token in the login response!", new Object[0]);
        }
        this.preferenceStore.setAccessToken(sessionTokens.getAccessToken());
        this.preferenceStore.setRefreshToken(sessionTokens.getRefreshToken());
    }

    private Request buildRefreshTokenRequest(String refreshToken) {
        FormBody formBody = new FormBody.Builder().add("refresh_token", refreshToken).add("grant_type", "refresh_token").build();
        return new Request.Builder().url(this.config.getBaseUrl() + "/oauth/token").headers(this.buildStandardHeaders()).post((RequestBody)formBody).build();
    }

    void getUserProfile(final StormpathCallback<Account> callback) {
        String accessToken = this.preferenceStore.getAccessToken();
        if (StringUtils.isBlank(accessToken)) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), new IllegalStateException("access_token was not found, did you forget to login? See debug logs for details.")));
                }
            });
            return;
        }
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/me").headers(this.buildStandardHeaders(accessToken)).get().build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Account>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Account> callback) {
                try {
                    UserProfileResponse userProfileResponse = (UserProfileResponse)ApiManager.this.moshi.adapter(UserProfileResponse.class).fromJson(response.body().source());
                    this.successCallback(userProfileResponse.account);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    void getLoginModel(StormpathCallback<LoginModel> callback) {
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/login").headers(this.buildStandardHeaders()).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<LoginModel>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<LoginModel> callback) {
                try {
                    LoginModel loginModel = (LoginModel)ApiManager.this.moshi.adapter(LoginModel.class).fromJson(response.body().source());
                    this.successCallback(loginModel);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        });
    }

    void resetPassword(String email, StormpathCallback<Void> callback) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"email\":\"" + email + "\"}"));
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/forgot").headers(this.buildStandardHeaders()).post(body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    void logout() {
        String refreshToken = this.preferenceStore.getRefreshToken();
        if (StringUtils.isBlank(refreshToken)) {
            return;
        }
        FormBody body = new FormBody.Builder().add("token", refreshToken).build();
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/oauth/revoke").headers(this.buildStandardHeaders()).post((RequestBody)body).build();
        this.preferenceStore.clearAccessToken();
        this.preferenceStore.clearRefreshToken();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
            }

            public void onFailure(Call call, IOException e) {
            }
        });
    }

    void verifyEmail(String sptoken, StormpathCallback<Void> callback) {
        HttpUrl url = HttpUrl.parse((String)(this.config.getBaseUrl() + "/verify")).newBuilder().addQueryParameter("sptoken", sptoken).build();
        Request request = new Request.Builder().url(url).headers(this.buildStandardHeaders()).get().build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    void resendVerificationEmail(String email, StormpathCallback<Void> callback) {
        FormBody body = new FormBody.Builder().add("login", email).build();
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/verify").headers(this.buildStandardHeaders()).post((RequestBody)body).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new OkHttpCallback<Void>(callback){

            @Override
            protected void onSuccess(Response response, StormpathCallback<Void> callback) {
                this.successCallback(null);
            }
        });
    }

    void loginWithProvider(@NonNull String providerId, String accessToken, StormpathCallback<Void> callback) {
        FormBody body = new FormBody.Builder().add("grant_type", "stormpath_social").add("providerId", providerId).add("accessToken", accessToken).build();
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/oauth/token").headers(this.buildStandardHeaders()).post((RequestBody)body).build();
        this.okHttpClient.newCall(request).enqueue(new StormpathOAuthTokenCallback<Void>(callback));
    }

    void loginWithStormpathToken(@NonNull String stormpathToken, StormpathCallback<Void> callback) {
        FormBody body = new FormBody.Builder().add("grant_type", "stormpath_token").add("token", stormpathToken).build();
        Request request = new Request.Builder().url(this.config.getBaseUrl() + "/oauth/token").headers(this.buildStandardHeaders()).post((RequestBody)body).build();
        this.okHttpClient.newCall(request).enqueue(new StormpathOAuthTokenCallback<Void>(callback));
    }

    private Headers buildStandardHeaders() {
        return this.buildStandardHeaders(null);
    }

    private Headers buildStandardHeaders(String accessToken) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "application/json");
        builder.add("X-Stormpath-Agent", "stormpath-sdk-android/" + "1.0.5" + " Android/" + Build.VERSION.SDK_INT);
        if (StringUtils.isNotBlank(accessToken)) {
            builder.add("Authorization", "Bearer " + accessToken);
        }
        return builder.build();
    }

    private static class UserProfileResponse
    implements Serializable {
        @Json(name="account")
        private Account account;

        private UserProfileResponse() {
        }
    }

    private abstract class OkHttpCallback<T>
    implements Callback {
        private StormpathCallback<T> stormpathCallback;

        public OkHttpCallback(StormpathCallback<T> stormpathCallback) {
            this.stormpathCallback = stormpathCallback;
        }

        public void onFailure(Call call, IOException e) {
            if (e instanceof UnknownHostException || e instanceof SocketTimeoutException || e instanceof SocketException) {
                this.failureCallback(new StormpathError(ApiManager.this.platform.networkErrorMessage(), e));
            } else {
                this.failureCallback(e);
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (response.isSuccessful()) {
                this.onSuccess(response, this.stormpathCallback);
            } else {
                try {
                    StormpathError error = (StormpathError)ApiManager.this.moshi.adapter(StormpathError.class).fromJson(response.body().source());
                    this.failureCallback(error);
                }
                catch (Throwable t) {
                    this.failureCallback(t);
                }
            }
        }

        protected abstract void onSuccess(Response var1, StormpathCallback<T> var2);

        void successCallback(final T t) {
            ApiManager.this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpCallback.this.stormpathCallback.onSuccess(t);
                }
            });
        }

        void failureCallback(Throwable t) {
            this.failureCallback(new StormpathError(ApiManager.this.platform.unknownErrorMessage(), t));
        }

        void failureCallback(final StormpathError error) {
            ApiManager.this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    OkHttpCallback.this.stormpathCallback.onFailure(error);
                }
            });
        }
    }

    private class StormpathOAuthTokenCallback<T>
    extends OkHttpCallback {
        public StormpathOAuthTokenCallback(StormpathCallback<T> stormpathCallback) {
            super(stormpathCallback);
        }

        protected void onSuccess(Response response, StormpathCallback callback) {
            try {
                SessionTokens sessionTokens = (SessionTokens)ApiManager.this.moshi.adapter(SessionTokens.class).fromJson(response.body().source());
                if (StringUtils.isBlank(sessionTokens.getAccessToken())) {
                    this.failureCallback(new RuntimeException("access_token was not found in response. See debug logs for details."));
                    return;
                }
                if (StringUtils.isBlank(sessionTokens.getRefreshToken())) {
                    Stormpath.logger().e("There was no refresh_token in the login response!", new Object[0]);
                }
                ApiManager.this.preferenceStore.setAccessToken(sessionTokens.getAccessToken());
                ApiManager.this.preferenceStore.setRefreshToken(sessionTokens.getRefreshToken());
                this.successCallback(null);
            }
            catch (Throwable t) {
                this.failureCallback(t);
            }
        }
    }
}

