/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stormpath.sdk.ApiManager;
import com.stormpath.sdk.Platform;
import com.stormpath.sdk.Provider;
import com.stormpath.sdk.SocialLoginManager;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.StormpathConfiguration;
import com.stormpath.sdk.StormpathLogger;
import com.stormpath.sdk.android.AndroidPlatform;
import com.stormpath.sdk.models.Account;
import com.stormpath.sdk.models.RegistrationForm;

public class Stormpath {
    static StormpathConfiguration config;
    static Platform platform;
    static ApiManager apiManager;
    static SocialLoginManager socialLoginManager;
    static int logLevel;

    private Stormpath() {
    }

    public static void init(@NonNull Context context, @NonNull StormpathConfiguration config) {
        Stormpath.init(new AndroidPlatform(context), config);
    }

    public static boolean isInitialized() {
        return config != null && platform != null && apiManager != null;
    }

    static void init(@NonNull Platform platform, @NonNull StormpathConfiguration configuration) {
        if (Stormpath.isInitialized()) {
            throw new IllegalStateException("You may only initialize Stormpath once!");
        }
        Stormpath.platform = platform;
        Stormpath.platform.logger().setLogLevel(logLevel);
        config = configuration;
        apiManager = new ApiManager(config, platform);
        Stormpath.logger().v("Initialized Stormpath SDK with baseUrl: " + config.getBaseUrl(), new Object[0]);
    }

    public static void reset() {
        platform = null;
        config = null;
        apiManager = null;
        logLevel = 100;
    }

    public static void login(String username, String password, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.login(username, password, callback);
    }

    public static void register(RegistrationForm registrationForm, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.register(registrationForm, callback);
    }

    public static void loginWithProvider(Provider provider, String accessToken, StormpathCallback<Void> callback) {
        Stormpath.loginWithProvider(provider.name(), accessToken, callback);
    }

    public static void loginWithProvider(String providerId, String accessToken, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.loginWithProvider(providerId, accessToken, callback);
    }

    public static void loginWithProvider(Provider provider, Activity activity, StormpathCallback<Void> callback) {
        Stormpath.loginWithProvider(provider.name(), activity, callback);
    }

    public static void loginWithProvider(String providerId, Activity activity, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        socialLoginManager.loginWithProvider(providerId, activity, callback);
    }

    public static void loginWithAccountStore(String href, Activity activity, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        socialLoginManager.loginWithAccountStore(href, activity, callback);
    }

    public static void refreshAccessToken(StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.refreshAccessToken(callback);
    }

    public static void getAccount(StormpathCallback<Account> callback) {
        Stormpath.ensureConfigured();
        apiManager.getUserProfile(callback);
    }

    public static void resetPassword(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resetPassword(email, callback);
    }

    public static void verifyEmail(String sptoken, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.verifyEmail(sptoken, callback);
    }

    public static void resendVerificationEmail(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resendVerificationEmail(email, callback);
    }

    public static void logout() {
        Stormpath.ensureConfigured();
        apiManager.logout();
    }

    @Nullable
    public static String getAccessToken() {
        Stormpath.ensureConfigured();
        return platform.preferenceStore().getAccessToken();
    }

    @Nullable
    public static String getRefreshToken() {
        Stormpath.ensureConfigured();
        return platform.preferenceStore().getRefreshToken();
    }

    public static StormpathLogger logger() {
        Stormpath.ensureConfigured();
        return platform.logger();
    }

    public static void setLogLevel(int logLevel) {
        Stormpath.logLevel = logLevel;
        if (platform != null) {
            platform.logger().setLogLevel(Stormpath.logLevel);
        }
    }

    static void ensureConfigured() {
        if (!Stormpath.isInitialized()) {
            throw new IllegalStateException("You need to initialize Stormpath before using it. To do that call Stormpath.init() with a valid configuration.");
        }
    }

    static {
        socialLoginManager = new SocialLoginManager();
        logLevel = 100;
    }
}

