/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsIntent;
import com.stormpath.sdk.ApiManager;
import com.stormpath.sdk.Platform;
import com.stormpath.sdk.StormpathCallback;
import com.stormpath.sdk.StormpathConfiguration;
import com.stormpath.sdk.StormpathLogger;
import com.stormpath.sdk.android.AndroidPlatform;
import com.stormpath.sdk.android.CustomTabActivityHelper;
import com.stormpath.sdk.android.WebviewFallback;
import com.stormpath.sdk.models.RegisterParams;
import com.stormpath.sdk.models.SocialProviderConfiguration;
import com.stormpath.sdk.models.SocialProvidersResponse;
import com.stormpath.sdk.models.UserProfile;
import com.stormpath.sdk.providers.FacebookLoginProvider;
import com.stormpath.sdk.providers.GoogleLoginProvider;

public class Stormpath {
    static StormpathConfiguration config;
    static Platform platform;
    static ApiManager apiManager;
    static int logLevel;

    private Stormpath() {
    }

    public static void init(@NonNull Context context, @NonNull StormpathConfiguration config) {
        Stormpath.init(new AndroidPlatform(context), config);
    }

    public static boolean isInitialized() {
        return config != null && platform != null && apiManager != null;
    }

    static void init(@NonNull Platform platform, @NonNull StormpathConfiguration configuration) {
        if (Stormpath.isInitialized()) {
            throw new IllegalStateException("You may only initialize Stormpath once!");
        }
        Stormpath.platform = platform;
        Stormpath.platform.logger().setLogLevel(logLevel);
        config = configuration;
        apiManager = new ApiManager(config, platform);
        Stormpath.logger().v("Initialized Stormpath SDK with baseUrl: " + config.baseUrl(), new Object[0]);
    }

    static void reset() {
        platform = null;
        config = null;
        apiManager = null;
        logLevel = 100;
    }

    public static void login(String username, String password, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.login(username, password, callback);
    }

    public static void register(RegisterParams registerParams, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.register(registerParams, callback);
    }

    public static void socialLogin(String providerId, String accessToken, String code, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        if ("google".equalsIgnoreCase(providerId)) {
            if (code != null) {
                apiManager.socialLogin(providerId, null, code, callback);
            }
            if (accessToken != null) {
                apiManager.socialLogin(providerId, accessToken, null, callback);
            }
        } else if ("facebook".equalsIgnoreCase(providerId)) {
            apiManager.socialLogin(providerId, accessToken, null, callback);
        }
    }

    public static void socialLoginFlow(@NonNull Activity activity, String providerId, SocialProviderConfiguration providerConfig) {
        Stormpath.ensureConfigured();
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        if ("google".equalsIgnoreCase(providerId)) {
            GoogleLoginProvider mGoogLogin = new GoogleLoginProvider();
            CustomTabActivityHelper.openCustomTab(activity, customTabsIntent, Uri.parse((String)mGoogLogin.authenticationRequestURL(providerConfig)), new WebviewFallback());
        } else if ("facebook".equalsIgnoreCase(providerId)) {
            FacebookLoginProvider mFbLogin = new FacebookLoginProvider();
            CustomTabActivityHelper.openCustomTab(activity, customTabsIntent, Uri.parse((String)mFbLogin.authenticationRequestURL(providerConfig)), new WebviewFallback());
        }
    }

    public static void getSocialProviders(StormpathCallback<SocialProvidersResponse> callback) {
        Stormpath.ensureConfigured();
        apiManager.getSocialProviders(callback);
    }

    public static void refreshAccessToken(StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.refreshAccessToken(callback);
    }

    public static void getUserProfile(StormpathCallback<UserProfile> callback) {
        Stormpath.ensureConfigured();
        apiManager.getUserProfile(callback);
    }

    public static void resetPassword(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resetPassword(email, callback);
    }

    public static void verifyEmail(String sptoken, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.verifyEmail(sptoken, callback);
    }

    public static void resendVerificationEmail(String email, StormpathCallback<Void> callback) {
        Stormpath.ensureConfigured();
        apiManager.resendVerificationEmail(email, callback);
    }

    public static void socialGoogleCodeAuth(String code, SocialProviderConfiguration application, StormpathCallback<String> callback) {
        Stormpath.ensureConfigured();
        apiManager.socialGoogleCodeAuth(code, application, callback);
    }

    public static void logout() {
        Stormpath.ensureConfigured();
        apiManager.logout();
    }

    @Nullable
    public static String accessToken() {
        Stormpath.ensureConfigured();
        return platform.preferenceStore().getAccessToken();
    }

    public static StormpathLogger logger() {
        Stormpath.ensureConfigured();
        return platform.logger();
    }

    public static void setLogLevel(int logLevel) {
        Stormpath.logLevel = logLevel;
        if (platform != null) {
            platform.logger().setLogLevel(Stormpath.logLevel);
        }
    }

    static void ensureConfigured() {
        if (!Stormpath.isInitialized()) {
            throw new IllegalStateException("You need to initialize Stormpath before using it. To do that call Stormpath.init() with a valid configuration.");
        }
    }

    static {
        logLevel = 100;
    }
}

