/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class StormpathLogger {
    public static final int SILENT = 100;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private int logLevel = 100;

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    protected abstract void log(int var1, String var2);

    protected void log(int logLevel, Throwable throwable, String message, Object ... args) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        if (message == null) {
            if (throwable == null) {
                return;
            }
            message = this.getStackTraceString(throwable);
        } else {
            if (args.length > 0) {
                message = String.format(message, args);
            }
            if (throwable != null) {
                message = message + "\n" + this.getStackTraceString(throwable);
            }
        }
        this.log(logLevel, message);
    }

    private boolean isLoggable(int level) {
        return level >= this.logLevel;
    }

    private String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public void v(String message, Object ... args) {
        this.log(2, null, message, args);
    }

    public void d(String message, Object ... args) {
        this.log(3, null, message, args);
    }

    public void i(String message, Object ... args) {
        this.log(4, null, message, args);
    }

    public void w(String message, Object ... args) {
        this.log(5, null, message, args);
    }

    public void e(String message, Object ... args) {
        this.log(6, null, message, args);
    }

    public void wtf(String message, Object ... args) {
        this.log(7, null, message, args);
    }

    public void v(Throwable t, String message, Object ... args) {
        this.log(2, t, message, args);
    }

    public void d(Throwable t, String message, Object ... args) {
        this.log(3, t, message, args);
    }

    public void i(Throwable t, String message, Object ... args) {
        this.log(4, t, message, args);
    }

    public void w(Throwable t, String message, Object ... args) {
        this.log(5, t, message, args);
    }

    public void e(Throwable t, String message, Object ... args) {
        this.log(6, t, message, args);
    }

    public void wtf(Throwable t, String message, Object ... args) {
        this.log(7, t, message, args);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

