/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.Uri;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.IOException;
import org.videolan.libvlc.AWindow;
import org.videolan.libvlc.IVLCVout;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.RendererItem;
import org.videolan.libvlc.VLCEvent;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.VideoHelper;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.DisplayManager;
import org.videolan.libvlc.util.VLCUtil;
import org.videolan.libvlc.util.VLCVideoLayout;

public class MediaPlayer
extends VLCObject<Event> {
    public static final int SURFACE_SCALES_COUNT = ScaleType.values().length;
    private Media mMedia = null;
    private RendererItem mRenderer = null;
    private AssetFileDescriptor mAfd = null;
    private boolean mPlaying = false;
    private boolean mPlayRequested = false;
    private boolean mListenAudioPlug = true;
    private int mVoutCount = 0;
    private boolean mAudioReset = false;
    private String mAudioOutput = "android_audiotrack";
    private String mAudioOutputDevice = null;
    private boolean mAudioPlugRegistered = false;
    private boolean mAudioDigitalOutputEnabled = false;
    private String mAudioPlugOutputDevice = "stereo";
    private boolean mCanDoPassthrough;
    private final BroadcastReceiver mAudioPlugReceiver = AndroidUtil.isLolliPopOrLater && !AndroidUtil.isMarshMallowOrLater ? this.createAudioPlugReceiver() : null;
    private final AudioDeviceCallback mAudioDeviceCallback = AndroidUtil.isMarshMallowOrLater ? this.createAudioDeviceCallback() : null;
    private final AWindow mWindow = new AWindow(new AWindow.SurfaceCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesCreated(AWindow vout) {
            boolean play = false;
            boolean enableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (!MediaPlayer.this.mPlaying && MediaPlayer.this.mPlayRequested) {
                    play = true;
                } else if (MediaPlayer.this.mVoutCount == 0) {
                    enableVideo = true;
                }
            }
            if (play) {
                MediaPlayer.this.play();
            } else if (enableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacesDestroyed(AWindow vout) {
            boolean disableVideo = false;
            MediaPlayer mediaPlayer = MediaPlayer.this;
            synchronized (mediaPlayer) {
                if (MediaPlayer.this.mVoutCount > 0) {
                    disableVideo = true;
                }
            }
            if (disableVideo) {
                MediaPlayer.this.setVideoTrackEnabled(false);
            }
        }
    });
    private VideoHelper mVideoHelper = null;

    public MediaPlayer(LibVLC libVLC) {
        super(libVLC);
        this.nativeNewFromLibVlc(libVLC, this.mWindow);
    }

    public MediaPlayer(@NonNull Media media) {
        super(media);
        if (media == null || media.isReleased()) {
            throw new IllegalArgumentException("Media is null or released");
        }
        this.mMedia = media;
        this.mMedia.retain();
        this.nativeNewFromMedia(this.mMedia, this.mWindow);
    }

    private static Title createTitleFromNative(long duration, String name, int flags) {
        return new Title(duration, name, flags);
    }

    private static Chapter createChapterFromNative(long timeOffset, long duration, String name) {
        return new Chapter(timeOffset, duration, name);
    }

    private static TrackDescription createTrackDescriptionFromNative(int id, String name) {
        return new TrackDescription(id, name);
    }

    private synchronized void updateAudioOutputDevice(long encodingFlags, String defaultDevice) {
        String newDeviceId;
        this.mCanDoPassthrough = encodingFlags != 0L;
        String string = newDeviceId = this.mAudioDigitalOutputEnabled && this.mCanDoPassthrough ? "encoded:" + encodingFlags : defaultDevice;
        if (!newDeviceId.equals(this.mAudioPlugOutputDevice)) {
            this.mAudioPlugOutputDevice = newDeviceId;
            this.setAudioOutputDeviceInternal(this.mAudioPlugOutputDevice, false);
        }
    }

    private boolean isEncoded(int encoding) {
        switch (encoding) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private long getEncodingFlags(int[] encodings) {
        if (encodings == null) {
            return 0L;
        }
        long encodingFlags = 0L;
        for (int encoding : encodings) {
            if (!this.isEncoded(encoding)) continue;
            encodingFlags |= (long)(1 << encoding);
        }
        return encodingFlags;
    }

    @TargetApi(value=21)
    private BroadcastReceiver createAudioPlugReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                if (action.equalsIgnoreCase("android.media.action.HDMI_AUDIO_PLUG")) {
                    boolean hasHdmi = intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) == 1;
                    long encodingFlags = !hasHdmi ? 0L : MediaPlayer.this.getEncodingFlags(intent.getIntArrayExtra("android.media.extra.ENCODINGS"));
                    MediaPlayer.this.updateAudioOutputDevice(encodingFlags, "stereo");
                }
            }
        };
    }

    @TargetApi(value=21)
    private void registerAudioPlugV21(boolean register) {
        if (register) {
            IntentFilter intentFilter = new IntentFilter("android.media.action.HDMI_AUDIO_PLUG");
            Intent stickyIntent = this.mLibVLC.mAppContext.registerReceiver(this.mAudioPlugReceiver, intentFilter);
            if (stickyIntent != null) {
                this.mAudioPlugReceiver.onReceive(this.mLibVLC.mAppContext, stickyIntent);
            }
        } else {
            this.mLibVLC.mAppContext.unregisterReceiver(this.mAudioPlugReceiver);
        }
    }

    @TargetApi(value=23)
    private AudioDeviceCallback createAudioDeviceCallback() {
        return new AudioDeviceCallback(){
            private SparseArray<Long> mEncodedDevices = new SparseArray();

            private void onAudioDevicesChanged() {
                long encodingFlags = 0L;
                for (int i = 0; i < this.mEncodedDevices.size(); ++i) {
                    encodingFlags |= ((Long)this.mEncodedDevices.valueAt(i)).longValue();
                }
                String defaultDevice = encodingFlags == 0L ? "stereo" : "pcm";
                MediaPlayer.this.updateAudioOutputDevice(encodingFlags, defaultDevice);
            }

            @RequiresApi(value=23)
            public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                for (AudioDeviceInfo info : addedDevices) {
                    long encodingFlags;
                    if (!info.isSink() || (encodingFlags = MediaPlayer.this.getEncodingFlags(info.getEncodings())) == 0L) continue;
                    this.mEncodedDevices.put(info.getId(), (Object)encodingFlags);
                }
                this.onAudioDevicesChanged();
            }

            @RequiresApi(value=23)
            public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                for (AudioDeviceInfo info : removedDevices) {
                    if (!info.isSink()) continue;
                    this.mEncodedDevices.remove(info.getId());
                }
                this.onAudioDevicesChanged();
            }
        };
    }

    @TargetApi(value=23)
    private void registerAudioPlugV23(boolean register) {
        AudioManager am = (AudioManager)this.mLibVLC.mAppContext.getSystemService("audio");
        if (register) {
            this.mAudioDeviceCallback.onAudioDevicesAdded(am.getDevices(2));
            am.registerAudioDeviceCallback(this.mAudioDeviceCallback, null);
        } else {
            am.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
        }
    }

    private void registerAudioPlug(boolean register) {
        if (register == this.mAudioPlugRegistered) {
            return;
        }
        if (this.mAudioDeviceCallback != null) {
            this.registerAudioPlugV23(register);
        } else if (this.mAudioPlugReceiver != null) {
            this.registerAudioPlugV21(register);
        }
        this.mAudioPlugRegistered = register;
    }

    @NonNull
    public IVLCVout getVLCVout() {
        return this.mWindow;
    }

    public void attachViews(@NonNull VLCVideoLayout surfaceFrame, @Nullable DisplayManager dm, boolean subtitles, boolean textureView) {
        this.mVideoHelper = new VideoHelper(this, surfaceFrame, dm, subtitles, textureView);
        this.mVideoHelper.attachViews();
    }

    public void detachViews() {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.release();
            this.mVideoHelper = null;
        }
    }

    public void updateVideoSurfaces() {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.updateVideoSurfaces();
        }
    }

    @NonNull
    public ScaleType getVideoScale() {
        return this.mVideoHelper != null ? this.mVideoHelper.getVideoScale() : ScaleType.SURFACE_BEST_FIT;
    }

    public void setVideoScale(@NonNull ScaleType type) {
        if (this.mVideoHelper != null) {
            this.mVideoHelper.setVideoScale(type);
        }
    }

    public int setRenderer(@Nullable RendererItem item) {
        if (this.mRenderer != null) {
            this.mRenderer.release();
        }
        if (item != null) {
            item.retain();
        }
        this.mRenderer = item;
        return this.nativeSetRenderer(item);
    }

    public synchronized boolean hasMedia() {
        return this.mMedia != null;
    }

    @Nullable
    public synchronized Media getMedia() {
        if (this.mMedia != null) {
            this.mMedia.retain();
        }
        return this.mMedia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedia(@Nullable Media media) {
        if (media != null) {
            if (media.isReleased()) {
                throw new IllegalArgumentException("Media is released");
            }
            media.setDefaultMediaPlayerOptions();
        }
        this.nativeSetMedia(media);
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mMedia != null) {
                this.mMedia.release();
            }
            if (media != null) {
                media.retain();
            }
            this.mMedia = media;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (!this.mPlaying) {
                if (this.mAudioReset) {
                    if (this.mAudioOutput != null) {
                        this.nativeSetAudioOutput(this.mAudioOutput);
                    }
                    if (this.mAudioOutputDevice != null) {
                        this.nativeSetAudioOutputDevice(this.mAudioOutputDevice);
                    }
                    this.mAudioReset = false;
                }
                if (this.mListenAudioPlug) {
                    this.registerAudioPlug(true);
                }
                this.mPlayRequested = true;
                if (this.mWindow.areSurfacesWaiting()) {
                    return;
                }
            }
            this.mPlaying = true;
        }
        this.nativePlay();
    }

    public void playAsset(@NonNull Context context, @NonNull String assetFilename) throws IOException {
        this.mAfd = context.getAssets().openFd(assetFilename);
        this.play(this.mAfd);
    }

    public void play(@NonNull AssetFileDescriptor afd) {
        Media media = new Media(this.mLibVLC, afd);
        this.play(media);
    }

    public void play(@NonNull String path) {
        Media media = new Media(this.mLibVLC, path);
        this.play(media);
    }

    public void play(@NonNull Uri uri) {
        Media media = new Media(this.mLibVLC, uri);
        this.play(media);
    }

    public void play(@NonNull Media media) {
        this.setMedia(media);
        media.release();
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mPlayRequested = false;
            this.mPlaying = false;
            this.mAudioReset = true;
        }
        this.nativeStop();
        if (this.mAfd != null) {
            try {
                this.mAfd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setVideoTitleDisplay(int position, int timeout) {
        this.nativeSetVideoTitleDisplay(position, timeout);
    }

    public float getScale() {
        return this.nativeGetScale();
    }

    public void setScale(float scale) {
        this.nativeSetScale(scale);
    }

    public String getAspectRatio() {
        return this.nativeGetAspectRatio();
    }

    public void setAspectRatio(String aspect) {
        this.nativeSetAspectRatio(aspect);
    }

    private boolean isAudioTrack() {
        return this.mAudioOutput != null && this.mAudioOutput.equals("android_audiotrack");
    }

    public boolean updateViewpoint(float yaw, float pitch, float roll, float fov, boolean absolute) {
        return this.nativeUpdateViewpoint(yaw, pitch, roll, fov, absolute);
    }

    public synchronized boolean setAudioOutput(String aout) {
        boolean ret;
        this.mAudioOutput = aout;
        this.mListenAudioPlug = this.isAudioTrack();
        if (!this.mListenAudioPlug) {
            this.registerAudioPlug(false);
        }
        if (!(ret = this.nativeSetAudioOutput(aout))) {
            this.mAudioOutput = null;
            this.mListenAudioPlug = false;
        }
        if (this.mListenAudioPlug) {
            this.registerAudioPlug(true);
        }
        return ret;
    }

    public synchronized boolean setAudioDigitalOutputEnabled(boolean enabled) {
        if (enabled == this.mAudioDigitalOutputEnabled) {
            return true;
        }
        if (!this.mListenAudioPlug || !this.isAudioTrack()) {
            return false;
        }
        this.registerAudioPlug(false);
        this.mAudioDigitalOutputEnabled = enabled;
        this.registerAudioPlug(true);
        return true;
    }

    public synchronized boolean forceAudioDigitalEncodings(int[] encodings) {
        if (!this.isAudioTrack()) {
            return false;
        }
        if (encodings.length == 0) {
            this.setAudioOutputDeviceInternal(null, true);
        } else {
            String newDeviceId = "encoded:" + this.getEncodingFlags(encodings);
            if (!newDeviceId.equals(this.mAudioPlugOutputDevice)) {
                this.mAudioPlugOutputDevice = newDeviceId;
                this.setAudioOutputDeviceInternal(this.mAudioPlugOutputDevice, true);
            }
        }
        return true;
    }

    private synchronized boolean setAudioOutputDeviceInternal(String id2, boolean fromUser) {
        boolean ret;
        this.mAudioOutputDevice = id2;
        if (fromUser) {
            boolean bl = this.mListenAudioPlug = this.mAudioOutputDevice == null && this.isAudioTrack();
            if (!this.mListenAudioPlug) {
                this.registerAudioPlug(false);
            }
        }
        if (!(ret = this.nativeSetAudioOutputDevice(id2))) {
            this.mAudioOutputDevice = null;
            this.mListenAudioPlug = false;
        }
        if (this.mListenAudioPlug) {
            this.registerAudioPlug(true);
        }
        return ret;
    }

    public boolean setAudioOutputDevice(String id2) {
        return this.setAudioOutputDeviceInternal(id2, true);
    }

    public Title[] getTitles() {
        return this.nativeGetTitles();
    }

    public Chapter[] getChapters(int title) {
        return this.nativeGetChapters(title);
    }

    public int getVideoTracksCount() {
        return this.nativeGetVideoTracksCount();
    }

    public TrackDescription[] getVideoTracks() {
        return this.nativeGetVideoTracks();
    }

    public int getVideoTrack() {
        return this.nativeGetVideoTrack();
    }

    public boolean setVideoTrack(int index) {
        if (index == -1 || this.mWindow.areViewsAttached() && !this.mWindow.areSurfacesWaiting()) {
            return this.nativeSetVideoTrack(index);
        }
        return false;
    }

    public void setVideoTrackEnabled(boolean enabled) {
        TrackDescription[] tracks;
        if (!enabled) {
            this.setVideoTrack(-1);
        } else if (!this.isReleased() && this.hasMedia() && this.getVideoTrack() == -1 && (tracks = this.getVideoTracks()) != null) {
            for (TrackDescription track : tracks) {
                if (track.id == -1) continue;
                this.setVideoTrack(track.id);
                break;
            }
        }
    }

    public Media.VideoTrack getCurrentVideoTrack() {
        if (this.getVideoTrack() == -1) {
            return null;
        }
        int trackCount = this.mMedia.getTrackCount();
        for (int i = 0; i < trackCount; ++i) {
            Media.Track track = this.mMedia.getTrack(i);
            if (track.type != 1) continue;
            return (Media.VideoTrack)track;
        }
        return null;
    }

    public int getAudioTracksCount() {
        return this.nativeGetAudioTracksCount();
    }

    public TrackDescription[] getAudioTracks() {
        return this.nativeGetAudioTracks();
    }

    public int getAudioTrack() {
        return this.nativeGetAudioTrack();
    }

    public boolean setAudioTrack(int index) {
        return this.nativeSetAudioTrack(index);
    }

    public long getAudioDelay() {
        return this.nativeGetAudioDelay();
    }

    public boolean setAudioDelay(long delay) {
        return this.nativeSetAudioDelay(delay);
    }

    public int getSpuTracksCount() {
        return this.nativeGetSpuTracksCount();
    }

    public TrackDescription[] getSpuTracks() {
        return this.nativeGetSpuTracks();
    }

    public int getSpuTrack() {
        return this.nativeGetSpuTrack();
    }

    public boolean setSpuTrack(int index) {
        return this.nativeSetSpuTrack(index);
    }

    public long getSpuDelay() {
        return this.nativeGetSpuDelay();
    }

    public boolean setSpuDelay(long delay) {
        return this.nativeSetSpuDelay(delay);
    }

    public boolean setEqualizer(Equalizer equalizer) {
        return this.nativeSetEqualizer(equalizer);
    }

    public boolean addSlave(int type, Uri uri, boolean select) {
        return this.nativeAddSlave(type, VLCUtil.encodeVLCUri(uri), select);
    }

    public boolean addSlave(int type, String path, boolean select) {
        return this.addSlave(type, Uri.fromFile((File)new File(path)), select);
    }

    public native float getRate();

    public native void setRate(float var1);

    public native boolean isPlaying();

    public native boolean isSeekable();

    public native void pause();

    public native int getPlayerState();

    public native int getVolume();

    public native int setVolume(int var1);

    public native long getTime();

    public native long setTime(long var1);

    public native float getPosition();

    public native void setPosition(float var1);

    public native long getLength();

    public native int getTitle();

    public native void setTitle(int var1);

    public native int getChapter();

    public native void setChapter(int var1);

    public native int previousChapter();

    public native int nextChapter();

    public native void navigate(int var1);

    public synchronized void setEventListener(EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected synchronized Event onEventNative(int eventType, long arg1, long arg2, float argf1) {
        switch (eventType) {
            case 256: 
            case 262: 
            case 265: 
            case 266: {
                this.mVoutCount = 0;
                this.notify();
            }
            case 258: 
            case 259: {
                return new Event(eventType, argf1);
            }
            case 260: 
            case 261: {
                return new Event(eventType);
            }
            case 267: {
                return new Event(eventType, arg1);
            }
            case 273: {
                return new Event(eventType, arg1);
            }
            case 268: {
                return new Event(eventType, argf1);
            }
            case 274: {
                this.mVoutCount = (int)arg1;
                this.notify();
                return new Event(eventType, arg1);
            }
            case 276: 
            case 277: 
            case 278: {
                return new Event(eventType, arg1, arg2);
            }
            case 269: 
            case 270: {
                return new Event(eventType, arg1);
            }
        }
        return null;
    }

    @Override
    protected void onReleaseNative() {
        this.detachViews();
        this.mWindow.detachViews();
        this.registerAudioPlug(false);
        if (this.mMedia != null) {
            this.mMedia.release();
        }
        if (this.mRenderer != null) {
            this.mRenderer.release();
        }
        this.mVoutCount = 0;
        this.nativeRelease();
    }

    public boolean canDoPassthrough() {
        return this.mCanDoPassthrough;
    }

    private native void nativeNewFromLibVlc(LibVLC var1, AWindow var2);

    private native void nativeNewFromMedia(Media var1, AWindow var2);

    private native void nativeRelease();

    private native void nativeSetMedia(Media var1);

    private native void nativePlay();

    private native void nativeStop();

    private native int nativeSetRenderer(RendererItem var1);

    private native void nativeSetVideoTitleDisplay(int var1, int var2);

    private native float nativeGetScale();

    private native void nativeSetScale(float var1);

    private native String nativeGetAspectRatio();

    private native void nativeSetAspectRatio(String var1);

    private native boolean nativeUpdateViewpoint(float var1, float var2, float var3, float var4, boolean var5);

    private native boolean nativeSetAudioOutput(String var1);

    private native boolean nativeSetAudioOutputDevice(String var1);

    private native Title[] nativeGetTitles();

    private native Chapter[] nativeGetChapters(int var1);

    private native int nativeGetVideoTracksCount();

    private native TrackDescription[] nativeGetVideoTracks();

    private native int nativeGetVideoTrack();

    private native boolean nativeSetVideoTrack(int var1);

    private native int nativeGetAudioTracksCount();

    private native TrackDescription[] nativeGetAudioTracks();

    private native int nativeGetAudioTrack();

    private native boolean nativeSetAudioTrack(int var1);

    private native long nativeGetAudioDelay();

    private native boolean nativeSetAudioDelay(long var1);

    private native int nativeGetSpuTracksCount();

    private native TrackDescription[] nativeGetSpuTracks();

    private native int nativeGetSpuTrack();

    private native boolean nativeSetSpuTrack(int var1);

    private native long nativeGetSpuDelay();

    private native boolean nativeSetSpuDelay(long var1);

    private native boolean nativeAddSlave(int var1, String var2, boolean var3);

    private native boolean nativeSetEqualizer(Equalizer var1);

    public static class Equalizer {
        private long mInstance;

        private Equalizer() {
            this.nativeNew();
        }

        private Equalizer(int index) {
            this.nativeNewFromPreset(index);
        }

        public static Equalizer create() {
            return new Equalizer();
        }

        public static Equalizer createFromPreset(int index) {
            return new Equalizer(index);
        }

        public static int getPresetCount() {
            return Equalizer.nativeGetPresetCount();
        }

        public static String getPresetName(int index) {
            return Equalizer.nativeGetPresetName(index);
        }

        public static int getBandCount() {
            return Equalizer.nativeGetBandCount();
        }

        public static float getBandFrequency(int index) {
            return Equalizer.nativeGetBandFrequency(index);
        }

        private static native int nativeGetPresetCount();

        private static native String nativeGetPresetName(int var0);

        private static native int nativeGetBandCount();

        private static native float nativeGetBandFrequency(int var0);

        protected void finalize() throws Throwable {
            try {
                this.nativeRelease();
            }
            finally {
                super.finalize();
            }
        }

        public float getPreAmp() {
            return this.nativeGetPreAmp();
        }

        public boolean setPreAmp(float preamp) {
            return this.nativeSetPreAmp(preamp);
        }

        public float getAmp(int index) {
            return this.nativeGetAmp(index);
        }

        public boolean setAmp(int index, float amp) {
            return this.nativeSetAmp(index, amp);
        }

        private native void nativeNew();

        private native void nativeNewFromPreset(int var1);

        private native void nativeRelease();

        private native float nativeGetPreAmp();

        private native boolean nativeSetPreAmp(float var1);

        private native float nativeGetAmp(int var1);

        private native boolean nativeSetAmp(int var1, float var2);
    }

    public static class TrackDescription {
        public final int id;
        public final String name;

        private TrackDescription(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Chapter {
        public final long timeOffset;
        public final long duration;
        public final String name;

        private Chapter(long timeOffset, long duration, String name) {
            this.timeOffset = timeOffset;
            this.duration = duration;
            this.name = name;
        }
    }

    public static class Title {
        public final long duration;
        public final String name;
        private final int flags;

        public Title(long duration, String name, int flags) {
            this.duration = duration;
            this.name = name;
            this.flags = flags;
        }

        public boolean isMenu() {
            return (this.flags & 1) != 0;
        }

        public boolean isInteractive() {
            return (this.flags & 2) != 0;
        }

        private static class Flags {
            public static final int MENU = 1;
            public static final int INTERACTIVE = 2;

            private Flags() {
            }
        }
    }

    public static class Navigate {
        public static final int Activate = 0;
        public static final int Up = 1;
        public static final int Down = 2;
        public static final int Left = 3;
        public static final int Right = 4;
    }

    public static class Position {
        public static final int Disable = -1;
        public static final int Center = 0;
        public static final int Left = 1;
        public static final int Right = 2;
        public static final int Top = 3;
        public static final int TopLeft = 4;
        public static final int TopRight = 5;
        public static final int Bottom = 6;
        public static final int BottomLeft = 7;
        public static final int BottomRight = 8;
    }

    public static class Event
    extends VLCEvent {
        public static final int MediaChanged = 256;
        public static final int Opening = 258;
        public static final int Buffering = 259;
        public static final int Playing = 260;
        public static final int Paused = 261;
        public static final int Stopped = 262;
        public static final int EndReached = 265;
        public static final int EncounteredError = 266;
        public static final int TimeChanged = 267;
        public static final int PositionChanged = 268;
        public static final int SeekableChanged = 269;
        public static final int PausableChanged = 270;
        public static final int LengthChanged = 273;
        public static final int Vout = 274;
        public static final int ESAdded = 276;
        public static final int ESDeleted = 277;
        public static final int ESSelected = 278;

        protected Event(int type) {
            super(type);
        }

        protected Event(int type, long arg1) {
            super(type, arg1);
        }

        protected Event(int type, long arg1, long arg2) {
            super(type, arg1, arg2);
        }

        protected Event(int type, float argf) {
            super(type, argf);
        }

        public long getTimeChanged() {
            return this.arg1;
        }

        public long getLengthChanged() {
            return this.arg1;
        }

        public float getPositionChanged() {
            return this.argf1;
        }

        public int getVoutCount() {
            return (int)this.arg1;
        }

        public int getEsChangedType() {
            return (int)this.arg1;
        }

        public int getEsChangedID() {
            return (int)this.arg2;
        }

        public boolean getPausable() {
            return this.arg1 != 0L;
        }

        public boolean getSeekable() {
            return this.arg1 != 0L;
        }

        public float getBuffering() {
            return this.argf1;
        }
    }

    public static interface EventListener
    extends VLCEvent.Listener<Event> {
    }

    public static enum ScaleType {
        SURFACE_BEST_FIT,
        SURFACE_FIT_SCREEN,
        SURFACE_FILL,
        SURFACE_16_9,
        SURFACE_4_3,
        SURFACE_ORIGINAL;

    }
}

