/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.util;

import android.net.Uri;
import android.os.Build;
import java.io.File;

public class AndroidUtil {
    public static final boolean isOOrLater = Build.VERSION.SDK_INT >= 26;
    public static final boolean isNougatOrLater = isOOrLater || Build.VERSION.SDK_INT >= 24;
    public static final boolean isMarshMallowOrLater = isNougatOrLater || Build.VERSION.SDK_INT >= 23;
    public static final boolean isLolliPopOrLater = isMarshMallowOrLater || Build.VERSION.SDK_INT >= 21;
    public static final boolean isKitKatOrLater = isLolliPopOrLater || Build.VERSION.SDK_INT >= 19;
    public static final boolean isJellyBeanMR2OrLater = isKitKatOrLater || Build.VERSION.SDK_INT >= 18;
    public static final boolean isJellyBeanMR1OrLater = isJellyBeanMR2OrLater || Build.VERSION.SDK_INT >= 17;
    public static final boolean isJellyBeanOrLater = isJellyBeanMR1OrLater || Build.VERSION.SDK_INT >= 16;
    public static final boolean isICSOrLater = isJellyBeanOrLater || Build.VERSION.SDK_INT >= 14;
    public static final boolean isHoneycombMr2OrLater = isICSOrLater || Build.VERSION.SDK_INT >= 13;
    public static final boolean isHoneycombMr1OrLater = isHoneycombMr2OrLater || Build.VERSION.SDK_INT >= 12;
    public static final boolean isHoneycombOrLater = isHoneycombMr1OrLater || Build.VERSION.SDK_INT >= 11;

    public static File UriToFile(Uri uri) {
        return new File(uri.getPath().replaceFirst("file://", ""));
    }

    public static Uri PathToUri(String path) {
        return Uri.fromFile((File)new File(path));
    }

    public static Uri LocationToUri(String location) {
        Uri uri = Uri.parse((String)location);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("location has no scheme");
        }
        return uri;
    }

    public static Uri FileToUri(File file) {
        return Uri.fromFile((File)file);
    }
}

