/*
 * Decompiled with CFR 0.152.
 */
package com.stanfy.gsonxml;

import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.stanfy.gsonxml.Stack;
import com.stanfy.gsonxml.XmlParserCreator;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlReader
extends JsonReader {
    private static final int START_TAG = 1;
    private static final int END_TAG = 2;
    private static final int VALUE = 3;
    private static final int IGNORE = -1;
    private final XmlPullParser xmlParser;
    final Options options;
    private final RefsPool<TokenRef> tokensPool = new RefsPool<TokenRef>(new Creator<TokenRef>(){

        @Override
        public TokenRef create() {
            return new TokenRef();
        }
    });
    private final RefsPool<ValueRef> valuesPool = new RefsPool<ValueRef>(new Creator<ValueRef>(){

        @Override
        public ValueRef create() {
            return new ValueRef();
        }
    });
    private TokenRef tokensQueue;
    private TokenRef tokensQueueStart;
    private ValueRef valuesQueue;
    private ValueRef valuesQueueStart;
    private JsonToken expectedToken;
    private boolean endReached;
    private boolean firstStart = true;
    private boolean lastTextWhiteSpace = false;
    private final Stack<Scope> scopeStack = new Stack();
    private final Stack<ClosedTag> closeStack = new Stack();
    private JsonToken token;
    private int textNameCounter = 0;
    private boolean skipping;
    private final XmlTokenInfo xmlToken = new XmlTokenInfo();
    private final AttributesData attributes = new AttributesData(10);

    public XmlReader(Reader in, XmlParserCreator creator, Options options) {
        super(in);
        this.xmlParser = creator.createParser();
        this.options = options;
        this.xmlToken.type = -1;
        try {
            this.xmlParser.setInput(in);
            this.xmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", options.namespaces);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    private CharSequence dump() {
        return new StringBuilder().append("Scopes: ").append(this.scopeStack).append('\n').append("Closed tags: ").append(this.closeStack).append('\n').append("Token: ").append(this.token).append('\n').append("Tokens queue: ").append(this.tokensQueueStart).append('\n').append("Values queue: ").append(this.valuesQueueStart).append('\n');
    }

    public String toString() {
        return "--- XmlReader ---\n" + this.dump();
    }

    private JsonToken peekNextToken() {
        return this.tokensQueueStart != null ? this.tokensQueueStart.token : null;
    }

    private JsonToken nextToken() {
        TokenRef ref = this.tokensQueueStart;
        if (ref == null) {
            return JsonToken.END_DOCUMENT;
        }
        this.tokensQueueStart = ref.next;
        if (ref == this.tokensQueue) {
            this.tokensQueue = null;
        }
        this.tokensPool.release(ref);
        return ref.token;
    }

    private ValueRef nextValue() {
        ValueRef ref = this.valuesQueueStart;
        if (ref == null) {
            throw new IllegalStateException("No value can be given");
        }
        if (ref == this.valuesQueue) {
            this.valuesQueue = null;
        }
        this.valuesPool.release(ref);
        this.valuesQueueStart = ref.next;
        return ref;
    }

    private void expect(JsonToken token) throws IOException {
        JsonToken actual = this.peek();
        this.token = null;
        if (actual != token) {
            throw new IllegalStateException(token + " expected, but met " + actual + "\n" + this.dump());
        }
    }

    public void beginObject() throws IOException {
        this.expectedToken = JsonToken.BEGIN_OBJECT;
        this.expect(this.expectedToken);
    }

    public void endObject() throws IOException {
        this.expectedToken = JsonToken.END_OBJECT;
        this.expect(this.expectedToken);
    }

    public void beginArray() throws IOException {
        this.expectedToken = JsonToken.BEGIN_ARRAY;
        this.expect(this.expectedToken);
    }

    public void endArray() throws IOException {
        this.expectedToken = JsonToken.END_ARRAY;
        this.expect(this.expectedToken);
    }

    public boolean hasNext() throws IOException {
        this.peek();
        return this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipValue() throws IOException {
        this.skipping = true;
        try {
            int count = 0;
            do {
                JsonToken token;
                if ((token = this.peek()) == JsonToken.BEGIN_ARRAY || token == JsonToken.BEGIN_OBJECT) {
                    ++count;
                } else if (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) {
                    --count;
                } else if (this.valuesQueue != null) {
                    this.nextValue();
                }
                this.token = null;
            } while (count != 0);
        }
        finally {
            this.skipping = false;
        }
    }

    private void adaptCurrentToken() throws XmlPullParserException, IOException {
        if (this.token == this.expectedToken) {
            return;
        }
        if (this.expectedToken != JsonToken.BEGIN_ARRAY) {
            return;
        }
        switch (this.token) {
            case BEGIN_OBJECT: {
                this.token = JsonToken.BEGIN_ARRAY;
                Scope lastScope = this.scopeStack.peek();
                if (this.peekNextToken() != JsonToken.NAME) break;
                if (this.options.sameNameList) {
                    this.scopeStack.cleanup(1);
                    this.pushToQueue(JsonToken.BEGIN_OBJECT);
                    this.scopeStack.push(Scope.INSIDE_EMBEDDED_ARRAY);
                    this.scopeStack.push(Scope.INSIDE_OBJECT);
                    if (lastScope != Scope.NAME) break;
                    this.scopeStack.push(Scope.NAME);
                    break;
                }
                this.nextToken();
                this.nextValue();
                int pushPos = this.scopeStack.size();
                if (this.options.primitiveArrays && this.peekNextToken() == null) {
                    this.fillQueues(true);
                }
                pushPos = this.scopeStack.cleanup(3, pushPos);
                if (this.options.primitiveArrays && this.peekNextToken() == JsonToken.STRING) {
                    this.scopeStack.pushAt(pushPos, Scope.INSIDE_PRIMITIVE_ARRAY);
                    break;
                }
                this.scopeStack.pushAt(pushPos, Scope.INSIDE_ARRAY);
                if (this.scopeStack.size() <= pushPos + 1 || this.scopeStack.get(pushPos + 1) != Scope.INSIDE_OBJECT) {
                    this.scopeStack.pushAt(pushPos + 1, Scope.INSIDE_OBJECT);
                }
                if (this.peekNextToken() == JsonToken.BEGIN_OBJECT) break;
                this.pushToQueue(JsonToken.BEGIN_OBJECT);
                break;
            }
            case STRING: {
                this.token = JsonToken.BEGIN_ARRAY;
                if (this.options.sameNameList) {
                    if (this.options.primitiveArrays) {
                        this.pushToQueue(JsonToken.STRING);
                        this.scopeStack.push(Scope.INSIDE_PRIMITIVE_EMBEDDED_ARRAY);
                        break;
                    }
                    String value = this.nextValue().value;
                    this.pushToQueue(JsonToken.END_OBJECT);
                    this.pushToQueue(JsonToken.STRING);
                    this.pushToQueue(JsonToken.NAME);
                    this.pushToQueue(JsonToken.BEGIN_OBJECT);
                    this.pushToQueue(value);
                    this.pushToQueue("$");
                    this.scopeStack.push(Scope.INSIDE_EMBEDDED_ARRAY);
                    break;
                }
                this.pushToQueue(JsonToken.END_ARRAY);
                break;
            }
        }
    }

    public JsonToken peek() throws IOException {
        if (this.expectedToken == null && this.firstStart) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (this.token != null) {
            try {
                this.adaptCurrentToken();
            }
            catch (XmlPullParserException e) {
                throw new JsonSyntaxException("XML parsing exception", (Throwable)e);
            }
            this.expectedToken = null;
            return this.token;
        }
        try {
            this.fillQueues(false);
            this.expectedToken = null;
            this.token = this.nextToken();
            return this.token;
        }
        catch (XmlPullParserException e) {
            throw new JsonSyntaxException("XML parsing exception", (Throwable)e);
        }
    }

    public String nextString() throws IOException {
        this.expect(JsonToken.STRING);
        return this.nextValue().value;
    }

    public boolean nextBoolean() throws IOException {
        this.expect(JsonToken.BOOLEAN);
        String value = this.nextValue().value;
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return true;
        }
        throw new IOException("Cannot parse <" + value + "> to boolean");
    }

    public double nextDouble() throws IOException {
        this.expect(JsonToken.STRING);
        return Double.parseDouble(this.nextValue().value);
    }

    public int nextInt() throws IOException {
        this.expect(JsonToken.STRING);
        return Integer.parseInt(this.nextValue().value);
    }

    public long nextLong() throws IOException {
        this.expect(JsonToken.STRING);
        return Long.parseLong(this.nextValue().value);
    }

    public String nextName() throws IOException {
        this.expectedToken = JsonToken.NAME;
        this.expect(JsonToken.NAME);
        return this.nextValue().value;
    }

    private XmlTokenInfo nextXmlInfo() throws IOException, XmlPullParserException {
        int type = this.xmlParser.next();
        XmlTokenInfo info = this.xmlToken;
        info.clear();
        switch (type) {
            case 2: {
                info.type = 1;
                info.name = this.xmlParser.getName();
                info.ns = this.xmlParser.getNamespace();
                int aCount = this.xmlParser.getAttributeCount();
                if (aCount <= 0) break;
                this.attributes.fill(this.xmlParser);
                info.attributesData = this.attributes;
                break;
            }
            case 3: {
                info.type = 2;
                info.name = this.xmlParser.getName();
                info.ns = this.xmlParser.getNamespace();
                break;
            }
            case 4: {
                String text = this.xmlParser.getText().trim();
                if (text.length() == 0) {
                    this.lastTextWhiteSpace = true;
                    info.type = -1;
                    return info;
                }
                this.lastTextWhiteSpace = false;
                info.type = 3;
                info.value = text;
                break;
            }
            case 1: {
                this.endReached = true;
            }
            default: {
                info.type = -1;
            }
        }
        return info;
    }

    private void addToQueue(JsonToken token) {
        TokenRef tokenRef = this.tokensPool.get();
        tokenRef.token = token;
        tokenRef.next = null;
        if (this.tokensQueue == null) {
            this.tokensQueue = tokenRef;
            this.tokensQueueStart = tokenRef;
        } else {
            this.tokensQueue.next = tokenRef;
            this.tokensQueue = tokenRef;
        }
    }

    private void pushToQueue(JsonToken token) {
        TokenRef tokenRef = this.tokensPool.get();
        tokenRef.token = token;
        tokenRef.next = null;
        if (this.tokensQueueStart == null) {
            this.tokensQueueStart = tokenRef;
            this.tokensQueue = tokenRef;
        } else {
            tokenRef.next = this.tokensQueueStart;
            this.tokensQueueStart = tokenRef;
        }
    }

    private void addToQueue(String value) {
        ValueRef valueRef = this.valuesPool.get();
        valueRef.value = value.trim();
        valueRef.next = null;
        if (this.valuesQueue == null) {
            this.valuesQueue = valueRef;
            this.valuesQueueStart = valueRef;
        } else {
            this.valuesQueue.next = valueRef;
            this.valuesQueue = valueRef;
        }
    }

    private void pushToQueue(String value) {
        ValueRef valueRef = this.valuesPool.get();
        valueRef.value = value;
        valueRef.next = null;
        if (this.valuesQueueStart == null) {
            this.valuesQueue = valueRef;
            this.valuesQueueStart = valueRef;
        } else {
            valueRef.next = this.valuesQueueStart;
            this.valuesQueueStart = valueRef;
        }
    }

    private void addToQueue(AttributesData attrData) throws IOException, XmlPullParserException {
        int count = attrData.count;
        for (int i = 0; i < count; ++i) {
            this.addToQueue(JsonToken.NAME);
            this.addToQueue("@" + attrData.getName(i));
            this.addToQueue(JsonToken.STRING);
            this.addToQueue(attrData.values[i]);
        }
    }

    private void fillQueues(boolean force) throws IOException, XmlPullParserException {
        boolean mustRepeat = force;
        while (this.tokensQueue == null && !this.endReached || mustRepeat) {
            XmlTokenInfo xml = this.nextXmlInfo();
            if (this.endReached) {
                if (this.options.skipRoot) break;
                this.addToQueue(JsonToken.END_OBJECT);
                break;
            }
            if (xml.type == -1) continue;
            mustRepeat = false;
            switch (xml.type) {
                case 1: {
                    if (this.firstStart) {
                        this.firstStart = false;
                        this.processRoot(xml);
                        break;
                    }
                    this.processStart(xml);
                    break;
                }
                case 3: {
                    mustRepeat = this.processText(xml);
                    break;
                }
                case 2: {
                    this.processEnd(xml);
                    break;
                }
            }
            if (mustRepeat || !this.skipping) continue;
            break;
        }
    }

    private void processRoot(XmlTokenInfo xml) throws IOException, XmlPullParserException {
        if (!this.options.skipRoot) {
            this.addToQueue(this.expectedToken);
            this.scopeStack.push(Scope.INSIDE_OBJECT);
            this.processStart(xml);
        } else if (xml.attributesData != null) {
            this.addToQueue(JsonToken.BEGIN_OBJECT);
            this.scopeStack.push(Scope.INSIDE_OBJECT);
            this.addToQueue(xml.attributesData);
        } else {
            switch (this.expectedToken) {
                case BEGIN_OBJECT: {
                    this.addToQueue(JsonToken.BEGIN_OBJECT);
                    this.scopeStack.push(Scope.INSIDE_OBJECT);
                    break;
                }
                case BEGIN_ARRAY: {
                    this.addToQueue(JsonToken.BEGIN_ARRAY);
                    this.scopeStack.push(this.options.rootArrayPrimitive ? Scope.INSIDE_PRIMITIVE_ARRAY : Scope.INSIDE_ARRAY);
                    break;
                }
                default: {
                    throw new IllegalStateException("First expectedToken=" + this.expectedToken + " (not begin_object/begin_array)");
                }
            }
        }
    }

    private void processStart(XmlTokenInfo xml) throws IOException, XmlPullParserException {
        boolean processTagName = true;
        Scope lastScope = this.scopeStack.peek();
        if (this.options.sameNameList && lastScope.insideArray && this.closeStack.size() > 0) {
            ClosedTag lastClosedInfo = this.closeStack.peek();
            if (lastClosedInfo.depth == this.xmlParser.getDepth()) {
                String currentName;
                String string = currentName = this.options.namespaces ? xml.getName(this.xmlParser) : xml.name;
                if (!currentName.equals(lastClosedInfo.name)) {
                    this.addToQueue(JsonToken.END_ARRAY);
                    this.fixScopeStack();
                    lastScope = this.scopeStack.peek();
                }
            }
        }
        switch (lastScope) {
            case INSIDE_PRIMITIVE_ARRAY: 
            case INSIDE_PRIMITIVE_EMBEDDED_ARRAY: {
                processTagName = false;
                this.scopeStack.push(Scope.PRIMITIVE_VALUE);
                break;
            }
            case INSIDE_EMBEDDED_ARRAY: 
            case INSIDE_ARRAY: {
                processTagName = false;
            }
            case NAME: {
                this.addToQueue(JsonToken.BEGIN_OBJECT);
                this.scopeStack.push(Scope.INSIDE_OBJECT);
                break;
            }
        }
        if (processTagName) {
            this.scopeStack.push(Scope.NAME);
            this.addToQueue(JsonToken.NAME);
            this.addToQueue(xml.getName(this.xmlParser));
            this.lastTextWhiteSpace = true;
        }
        if (xml.attributesData != null) {
            lastScope = this.scopeStack.peek();
            if (lastScope == Scope.PRIMITIVE_VALUE) {
                throw new IllegalStateException("Attributes data in primitive scope");
            }
            if (lastScope == Scope.NAME) {
                this.addToQueue(JsonToken.BEGIN_OBJECT);
                this.scopeStack.push(Scope.INSIDE_OBJECT);
            }
            this.addToQueue(xml.attributesData);
        }
    }

    private boolean processText(XmlTokenInfo xml) {
        switch (this.scopeStack.peek()) {
            case PRIMITIVE_VALUE: {
                this.addTextToQueue(xml.value, false);
                return false;
            }
            case NAME: {
                this.addTextToQueue(xml.value, true);
                return true;
            }
            case INSIDE_OBJECT: {
                String name = "$";
                if (this.textNameCounter > 0) {
                    name = name + this.textNameCounter;
                }
                ++this.textNameCounter;
                this.addToQueue(JsonToken.NAME);
                this.addToQueue(name);
                this.addTextToQueue(xml.value, false);
                return false;
            }
        }
        throw new JsonSyntaxException("Cannot process text '" + xml.value + "' inside scope " + (Object)((Object)this.scopeStack.peek()));
    }

    private void addTextToQueue(String value, boolean canBeAppended) {
        if (canBeAppended && this.tokensQueue != null && this.tokensQueue.token == JsonToken.STRING) {
            if (value.length() > 0) {
                this.valuesQueue.value = this.valuesQueue.value + " " + value;
            }
        } else {
            this.addToQueue(JsonToken.STRING);
            this.addToQueue(value);
        }
    }

    private void fixScopeStack() {
        this.scopeStack.fix(Scope.NAME);
    }

    private void processEnd(XmlTokenInfo xml) throws IOException, XmlPullParserException {
        switch (this.scopeStack.peek()) {
            case INSIDE_OBJECT: {
                this.addToQueue(JsonToken.END_OBJECT);
                this.textNameCounter = 0;
                this.fixScopeStack();
                break;
            }
            case PRIMITIVE_VALUE: {
                this.scopeStack.drop();
                break;
            }
            case INSIDE_PRIMITIVE_EMBEDDED_ARRAY: 
            case INSIDE_EMBEDDED_ARRAY: {
                this.addToQueue(JsonToken.END_ARRAY);
                this.addToQueue(JsonToken.END_OBJECT);
                this.fixScopeStack();
                this.fixScopeStack();
                break;
            }
            case INSIDE_PRIMITIVE_ARRAY: 
            case INSIDE_ARRAY: {
                this.addToQueue(JsonToken.END_ARRAY);
                this.fixScopeStack();
                break;
            }
            case NAME: {
                if (this.lastTextWhiteSpace) {
                    this.addTextToQueue("", true);
                }
                this.fixScopeStack();
                break;
            }
        }
        if (this.options.sameNameList) {
            int stackSize = this.xmlParser.getDepth();
            String name = this.options.namespaces ? xml.getName(this.xmlParser) : xml.name;
            Stack<ClosedTag> closeStack = this.closeStack;
            boolean nameChange = false;
            while (closeStack.size() > 0 && closeStack.peek().depth > stackSize) {
                closeStack.drop();
            }
            if (closeStack.size() == 0 || closeStack.peek().depth < stackSize) {
                closeStack.push(new ClosedTag(stackSize, name));
            } else {
                closeStack.peek().name = name;
            }
        }
    }

    static String nameWithNs(String name, String namespace, XmlPullParser parser) throws XmlPullParserException {
        String result = name;
        String ns = namespace;
        if (ns != null && ns.length() > 0) {
            if (parser != null) {
                int count = parser.getNamespaceCount(parser.getDepth());
                for (int i = 0; i < count; ++i) {
                    if (!ns.equals(parser.getNamespaceUri(i))) continue;
                    ns = parser.getNamespacePrefix(i);
                    break;
                }
            }
            result = "<" + ns + ">" + result;
        }
        return result;
    }

    private static interface Creator<T> {
        public T create();
    }

    private static final class RefsPool<T> {
        private static final int SIZE = 32;
        private final Creator<T> creator;
        private final Object[] store = new Object[32];
        private int len = 0;

        public RefsPool(Creator<T> factory) {
            this.creator = factory;
        }

        public T get() {
            if (this.len == 0) {
                return this.creator.create();
            }
            return (T)this.store[--this.len];
        }

        public void release(T obj) {
            if (this.len < 32) {
                this.store[this.len++] = obj;
            }
        }
    }

    private static class ClosedTag {
        int depth;
        String name;

        public ClosedTag(int depth, String name) {
            this.depth = depth;
            this.name = name;
        }

        public String toString() {
            return "'" + this.name + "'/" + this.depth;
        }
    }

    public static class Options {
        boolean primitiveArrays;
        boolean skipRoot;
        boolean sameNameList;
        boolean namespaces;
        boolean rootArrayPrimitive;
    }

    private final class AttributesData {
        String[] names;
        String[] values;
        String[] ns;
        int count = 0;

        public AttributesData(int capacity) {
            this.createArrays(capacity);
        }

        private void createArrays(int capacity) {
            this.names = new String[capacity];
            this.values = new String[capacity];
            this.ns = new String[capacity];
        }

        public void fill(XmlPullParser parser) {
            int aCount = parser.getAttributeCount();
            if (aCount > this.names.length) {
                this.createArrays(aCount);
            }
            this.count = aCount;
            for (int i = 0; i < aCount; ++i) {
                this.names[i] = parser.getAttributeName(i);
                if (XmlReader.this.options.namespaces) {
                    this.ns[i] = parser.getAttributePrefix(i);
                }
                this.values[i] = parser.getAttributeValue(i);
            }
        }

        public String getName(int i) throws IOException, XmlPullParserException {
            return XmlReader.nameWithNs(this.names[i], this.ns[i], null);
        }
    }

    private static final class XmlTokenInfo {
        int type;
        String name;
        String value;
        String ns;
        AttributesData attributesData;

        private XmlTokenInfo() {
        }

        public void clear() {
            this.type = -1;
            this.name = null;
            this.value = null;
            this.ns = null;
            this.attributesData = null;
        }

        public String toString() {
            return "xml " + (this.type == 1 ? "start" : (this.type == 2 ? "end" : "value")) + " <" + this.ns + ":" + this.name + ">=" + this.value + (this.attributesData != null ? ", " + this.attributesData : "");
        }

        public String getName(XmlPullParser parser) throws IOException, XmlPullParserException {
            return XmlReader.nameWithNs(this.name, this.ns, parser);
        }
    }

    private static final class ValueRef {
        String value;
        ValueRef next;

        private ValueRef() {
        }

        public String toString() {
            return this.value + ", " + this.next;
        }
    }

    private static final class TokenRef {
        JsonToken token;
        TokenRef next;

        private TokenRef() {
        }

        public String toString() {
            return this.token + ", " + this.next;
        }
    }

    private static enum Scope {
        INSIDE_OBJECT(false),
        INSIDE_ARRAY(true),
        INSIDE_EMBEDDED_ARRAY(true),
        INSIDE_PRIMITIVE_EMBEDDED_ARRAY(true),
        INSIDE_PRIMITIVE_ARRAY(true),
        PRIMITIVE_VALUE(false),
        NAME(false);

        final boolean insideArray;

        private Scope(boolean insideArray) {
            this.insideArray = insideArray;
        }
    }
}

