/*
 * Decompiled with CFR 0.152.
 */
package com.stanfy.gsonxml;

final class Stack<T> {
    private Object[] array = new Object[32];
    private int size = 0;

    Stack() {
    }

    public T peek() {
        return (T)this.array[this.size - 1];
    }

    public int size() {
        return this.size;
    }

    public T get(int pos) {
        return (T)this.array[pos];
    }

    public void drop() {
        --this.size;
    }

    public int cleanup(int count) {
        return this.cleanup(count, this.size);
    }

    public int cleanup(int count, int oldStackSize) {
        int curStackSize = this.size;
        if (oldStackSize < curStackSize) {
            for (int i = oldStackSize; i < curStackSize; ++i) {
                this.array[i - count] = this.array[i];
            }
            this.size -= count;
        } else {
            this.size -= count - oldStackSize + curStackSize;
        }
        if (this.size < 0) {
            this.size = 0;
        }
        return oldStackSize - count;
    }

    public void fix(T check) {
        --this.size;
        if (this.size > 0 && this.array[this.size - 1] == check) {
            --this.size;
        }
    }

    private void ensureStack() {
        if (this.size == this.array.length) {
            Object[] newStack = new Object[this.size * 2];
            System.arraycopy(this.array, 0, newStack, 0, this.size);
            this.array = newStack;
        }
    }

    public void push(T value) {
        this.ensureStack();
        this.array[this.size++] = value;
    }

    public void pushAt(int position, T scope) {
        int pos = position;
        if (pos < 0) {
            pos = 0;
        }
        this.ensureStack();
        for (int i = this.size - 1; i >= pos; --i) {
            this.array[i + 1] = this.array[i];
        }
        this.array[pos] = scope;
        ++this.size;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            res.append(this.array[i]).append('>');
        }
        if (res.length() > 0) {
            res.delete(res.length() - 1, res.length());
        }
        return res.toString();
    }
}

