/*
 * Decompiled with CFR 0.152.
 */
package com.ssomai.android.scalablelayout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.ssomai.android.scalablelayout.R;

public class ScalableLayout
extends FrameLayout {
    private static final float Default_Scale_Base_Width = 100.0f;
    private static final float Default_Scale_Base_Height = 100.0f;
    private static final float Default_Scale_Left = 0.0f;
    private static final int Default_Scale_Left_BasePosition = 0;
    private static final float Default_Scale_Top = 0.0f;
    private static final int Default_Scale_Top_BasePosition = 0;
    private static final float Default_Scale_Width = 100.0f;
    private static final float Default_Scale_Height = 100.0f;
    private static final float Default_TextView_WrapContent_Scale_MaxWidth = -1.0f;
    private static final float Default_Scale_TextSize = 100.0f;
    private float mScale_Root_Width = 100.0f;
    private float mScale_Root_Height = 100.0f;
    private float mRatioOfWidthHeight = this.mScale_Root_Height / this.mScale_Root_Width;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            ScalableLayout.this.requestLayout();
            ScalableLayout.this.forceLayout();
        }
    };
    private long mLastRequestPostTime = 0L;
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence pS, int pStart, int pBefore, int pCount) {
            ScalableLayout.this.postDelayedRequestLayout();
        }

        public void beforeTextChanged(CharSequence pS, int pStart, int pCount, int pAfter) {
        }

        public void afterTextChanged(Editable pS) {
            ScalableLayout.this.postDelayedRequestLayout();
        }
    };
    private String mLogTag_This = null;
    private static String sLogTag_Global = null;

    public float getScaleWidth() {
        return this.mScale_Root_Width;
    }

    public float getScaleHeight() {
        return this.mScale_Root_Height;
    }

    public void setScaleWidth(float pWidth) {
        this.setScaleSize(pWidth, this.mScale_Root_Height);
    }

    public void setScaleHeight(float pHeight) {
        this.setScaleSize(this.mScale_Root_Width, pHeight);
    }

    public void setScaleSize(float pWidth, float pHeight) {
        this.setScaleSize(pWidth, pHeight, true);
    }

    private void setScaleSize(float pWidth, float pHeight, boolean pWithInvalidate) {
        this.mScale_Root_Width = pWidth;
        this.mScale_Root_Height = pHeight;
        this.mRatioOfWidthHeight = this.mScale_Root_Height / this.mScale_Root_Width;
        if (pWithInvalidate) {
            this.postDelayedRequestLayout();
        }
    }

    private void postDelayedRequestLayout() {
        if (this.isInEditMode()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.mLastRequestPostTime < now - 50L || now < this.mLastRequestPostTime) {
            this.mLastRequestPostTime = now;
            this.postDelayed(this.mRunnable, 10L);
        }
    }

    public ScalableLayout(Context pContext) {
        this(pContext, 100.0f, 100.0f);
    }

    public ScalableLayout(Context pContext, AttributeSet pAttrs) {
        this(pContext, pAttrs, pContext.obtainStyledAttributes(pAttrs, R.styleable.ScalableLayout).getFloat(R.styleable.ScalableLayout_scale_base_width, 100.0f), pContext.obtainStyledAttributes(pAttrs, R.styleable.ScalableLayout).getFloat(R.styleable.ScalableLayout_scale_base_height, 100.0f));
    }

    public ScalableLayout(Context pContext, float pScale_Width, float pScale_Height) {
        this(pContext, null, pScale_Width, pScale_Height);
    }

    private ScalableLayout(Context pContext, AttributeSet pAttrs, float pScale_Width, float pScale_Height) {
        super(pContext, pAttrs);
        this.setScaleSize(pScale_Width, pScale_Height, true);
    }

    public LayoutParams getChildLayoutParams(View pChild) {
        Object lp = pChild.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
            pChild.setLayoutParams(lp);
        }
        if (!(lp instanceof LayoutParams)) {
            throw new IllegalArgumentException("pChild has not ScalableLayout.LayoutParams " + pChild.getLayoutParams());
        }
        return (LayoutParams)pChild.getLayoutParams();
    }

    public void setScale_TextSize(TextView pTextView, float pScale_TextSize) {
        this.getChildLayoutParams((View)pTextView).setScale_TextSize(pScale_TextSize);
    }

    public void setTextView_WrapContent(TextView pTextView, TextView_WrapContent_Direction pDirection, boolean pRescaleSurrounded) {
        this.setTextView_WrapContent(pTextView, pDirection, pRescaleSurrounded, true);
    }

    public void setTextView_WrapContent(TextView pTextView, TextView_WrapContent_Direction pDirection, boolean pRescaleSurrounded, boolean pMoveSibligs) {
        this.getChildLayoutParams((View)pTextView).setTextView_WrapContent(pDirection, pRescaleSurrounded, pMoveSibligs);
        this.refreshTextChangedListener(pTextView);
    }

    private void refreshTextChangedListener(TextView pTextView) {
        LayoutParams lSLLP = this.getChildLayoutParams((View)pTextView);
        try {
            pTextView.removeTextChangedListener(this.mTextWatcher);
        }
        catch (Throwable e) {
            ScalableLayout.ex(e);
        }
        if (lSLLP.mTextView_WrapContent_Direction != TextView_WrapContent_Direction.None) {
            pTextView.addTextChangedListener(this.mTextWatcher);
        }
    }

    public void addView(View pChild) {
        this.addView(pChild, this.getChildCount());
    }

    public void addView(View pChild, int pIndex) {
        this.addView(pChild, pIndex, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
    }

    public void addView(View pChild, int pWidth, int pHeight) {
        this.addView(pChild, new ViewGroup.LayoutParams(pWidth, pHeight));
    }

    public void addView(View pChild, ViewGroup.LayoutParams pParams) {
        this.addView(pChild, this.getChildCount(), pParams);
    }

    public void addView(View pChild, int pIndex, ViewGroup.LayoutParams pParams) {
        if (pParams instanceof LayoutParams) {
            this.addView_Final(pChild, pIndex, (LayoutParams)pParams);
        } else {
            this.addView_Final(pChild, pIndex, this.generateLayoutParams(pParams));
        }
    }

    public void addView(View pChild, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        this.addView_Final(pChild, this.getChildCount(), new LayoutParams(pScale_Left, pScale_Top, pScale_Width, pScale_Height));
    }

    private final void addView_Final(View pChild, int pIndex, LayoutParams pScaledLayoutParams) {
        super.addView(pChild, pIndex, (ViewGroup.LayoutParams)pScaledLayoutParams);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(0.0f, 0.0f, this.getScaleWidth(), this.getScaleHeight());
    }

    public LayoutParams generateLayoutParams(AttributeSet pAttrs) {
        return new LayoutParams(this.getContext(), pAttrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams pP) {
        if (pP instanceof LayoutParams) {
            return (LayoutParams)pP;
        }
        return new LayoutParams(pP);
    }

    public void moveChildView(View pChildView, float pScale_Left, float pScale_Top) {
        LayoutParams lSLLP = this.getChildLayoutParams(pChildView);
        lSLLP.mScale_Left = pScale_Left;
        lSLLP.mScale_Top = pScale_Top;
        this.postInvalidate();
    }

    public void moveChildView(View pChildView, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        LayoutParams lSLLP = this.getChildLayoutParams(pChildView);
        lSLLP.mScale_Left = pScale_Left;
        lSLLP.mScale_Top = pScale_Top;
        lSLLP.mScale_Width = pScale_Width;
        lSLLP.mScale_Height = pScale_Height;
        this.postInvalidate();
    }

    protected void onMeasure(int pWidthMeasureSpec, int pHeightMeasureSpec) {
        float lRoot_Width_Max = 0.0f;
        int lRoot_MeasureSpec_WidthMode = View.MeasureSpec.getMode((int)pWidthMeasureSpec);
        float lRoot_Height_Max = 0.0f;
        int lRoot_MeasureSpec_HeightMode = View.MeasureSpec.getMode((int)pHeightMeasureSpec);
        int lRoot_MeasureSpec_Width = View.MeasureSpec.getSize((int)pWidthMeasureSpec);
        int lRoot_MeasureSpec_Height = View.MeasureSpec.getSize((int)pHeightMeasureSpec);
        switch (lRoot_MeasureSpec_WidthMode) {
            case 0x40000000: {
                lRoot_Width_Max = lRoot_MeasureSpec_Width;
                break;
            }
            case -2147483648: {
                if (lRoot_MeasureSpec_HeightMode == 0x40000000) {
                    lRoot_Width_Max = Float.MAX_VALUE;
                    break;
                }
                lRoot_Width_Max = lRoot_MeasureSpec_Width;
                break;
            }
            default: {
                lRoot_Width_Max = Float.MAX_VALUE;
            }
        }
        switch (lRoot_MeasureSpec_HeightMode) {
            case 0x40000000: {
                lRoot_Height_Max = lRoot_MeasureSpec_Height;
                break;
            }
            case -2147483648: {
                if (lRoot_MeasureSpec_WidthMode == 0x40000000) {
                    lRoot_Height_Max = Float.MAX_VALUE;
                    break;
                }
                lRoot_Height_Max = lRoot_MeasureSpec_Height;
                break;
            }
            default: {
                lRoot_Height_Max = Float.MAX_VALUE;
            }
        }
        float lRoot_Width = 0.0f;
        float lRoot_Height = 0.0f;
        for (int tryi = 0; tryi < 3; ++tryi) {
            float lScale_Ratio_Pre = Math.min(lRoot_Width_Max / this.mScale_Root_Width, lRoot_Height_Max / this.mScale_Root_Height);
            for (int i = 0; i < this.getChildCount(); ++i) {
                View lView = this.getChildAt(i);
                if (!(lView instanceof TextView)) continue;
                this.updateTextViewSize((TextView)lView, lScale_Ratio_Pre);
            }
            float lScale_Ratio_Post = Math.min(lRoot_Width_Max / this.mScale_Root_Width, lRoot_Height_Max / this.mScale_Root_Height);
            lRoot_Width = this.mScale_Root_Width * lScale_Ratio_Post;
            lRoot_Height = this.mScale_Root_Height * lScale_Ratio_Post;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View lView = this.getChildAt(i);
                LayoutParams lParams = this.getChildLayoutParams(lView);
                boolean dif = false;
                int lParams_Left = Math.round(lScale_Ratio_Post * lParams.getScale_Left());
                if (lParams.leftMargin != lParams_Left) {
                    dif = true;
                }
                lParams.leftMargin = lParams_Left;
                int lParams_Width = Math.round(lScale_Ratio_Post * lParams.getScale_Width());
                if (lParams.width != lParams_Width) {
                    dif = true;
                }
                lParams.width = lParams_Width;
                switch (lParams.mScale_Left_BasePosition) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lParams.leftMargin -= lParams.width / 2;
                        break;
                    }
                    case 2: {
                        lParams.leftMargin -= lParams.width;
                    }
                }
                int lParams_Top = Math.round(lScale_Ratio_Post * lParams.getScale_Top());
                if (lParams.topMargin != lParams_Top) {
                    dif = true;
                }
                lParams.topMargin = lParams_Top;
                int lParams_Height = Math.round(lScale_Ratio_Post * lParams.getScale_Height());
                if (lParams.height != lParams_Height) {
                    dif = true;
                }
                lParams.height = lParams_Height;
                switch (lParams.mScale_Top_BasePosition) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lParams.topMargin -= lParams.height / 2;
                        break;
                    }
                    case 2: {
                        lParams.topMargin -= lParams.height;
                    }
                }
                if (lParams.mScale_TextSize != -1.0f && lView instanceof TextView) {
                    TextView v = (TextView)lView;
                    if (this.isDifferentSufficiently(lParams.mScale_TextSize * lScale_Ratio_Post, v.getTextSize())) {
                        v.setTextSize(0, lParams.mScale_TextSize * lScale_Ratio_Post);
                    }
                }
                if (!dif) continue;
                lView.setLayoutParams((ViewGroup.LayoutParams)lParams);
            }
            if (!this.isDifferentSufficiently(lScale_Ratio_Post, lScale_Ratio_Pre, 1.01f)) break;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)Math.round(lRoot_Width), (int)lRoot_MeasureSpec_WidthMode), View.MeasureSpec.makeMeasureSpec((int)Math.round(lRoot_Height), (int)lRoot_MeasureSpec_HeightMode));
        this.setMeasuredDimension(Math.round(lRoot_Width), Math.round(lRoot_Height));
    }

    private boolean isDifferentSufficiently(float pNew, float pOld) {
        return this.isDifferentSufficiently(pNew, pOld, 1.1f);
    }

    private boolean isDifferentSufficiently(float pNew, float pOld, float pDiffDelta) {
        return pNew < pOld / pDiffDelta || pOld * pDiffDelta < pNew;
    }

    private ViewPosition getViewPosition(LayoutParams pSrc, LayoutParams pDst) {
        if (pSrc.getScale_Top() >= pDst.getScale_Bottom() && (pSrc.getScale_Left() <= pDst.getScale_Left() && pDst.getScale_Left() <= pSrc.getScale_Right() || pSrc.getScale_Left() <= pDst.getScale_Right() && pDst.getScale_Right() <= pSrc.getScale_Right() || pDst.getScale_Left() <= pSrc.getScale_Left() && pSrc.getScale_Right() <= pDst.getScale_Right())) {
            return ViewPosition.Top;
        }
        if (pSrc.getScale_Bottom() <= pDst.getScale_Top() && (pSrc.getScale_Left() <= pDst.getScale_Left() && pDst.getScale_Left() <= pSrc.getScale_Right() || pSrc.getScale_Left() <= pDst.getScale_Right() && pDst.getScale_Right() <= pSrc.getScale_Right() || pDst.getScale_Left() <= pSrc.getScale_Left() && pSrc.getScale_Right() <= pDst.getScale_Right())) {
            return ViewPosition.Bottom;
        }
        if (pSrc.getScale_Left() >= pDst.getScale_Right() && (pSrc.getScale_Top() <= pDst.getScale_Top() && pDst.getScale_Top() <= pSrc.getScale_Bottom() || pSrc.getScale_Top() <= pDst.getScale_Bottom() && pDst.getScale_Bottom() <= pSrc.getScale_Bottom() || pSrc.getScale_Top() >= pDst.getScale_Top() && pDst.getScale_Bottom() >= pSrc.getScale_Bottom())) {
            return ViewPosition.Left;
        }
        if (pSrc.getScale_Right() <= pDst.getScale_Left() && (pSrc.getScale_Top() <= pDst.getScale_Top() && pDst.getScale_Top() <= pSrc.getScale_Bottom() || pSrc.getScale_Top() <= pDst.getScale_Bottom() && pDst.getScale_Bottom() <= pSrc.getScale_Bottom() || pSrc.getScale_Top() >= pDst.getScale_Top() && pDst.getScale_Bottom() >= pSrc.getScale_Bottom())) {
            return ViewPosition.Right;
        }
        if (pDst.getScale_Top() <= pSrc.getScale_Top() && pDst.getScale_Left() <= pSrc.getScale_Left() && pDst.getScale_Right() >= pSrc.getScale_Right() && pDst.getScale_Bottom() >= pSrc.getScale_Bottom()) {
            return ViewPosition.Surrounded;
        }
        return ViewPosition.Nothing;
    }

    private void updateTextViewSize(TextView pTV_Text, float pScale_TextViewMeasure_Pre) {
        int i;
        this.refreshTextChangedListener(pTV_Text);
        LayoutParams lTV_SLLP = this.getChildLayoutParams((View)pTV_Text);
        TextView_WrapContent_Direction lTextView_WrapContent_Direction = lTV_SLLP.mTextView_WrapContent_Direction;
        if (lTextView_WrapContent_Direction == TextView_WrapContent_Direction.None) {
            return;
        }
        float lTextView_ScaleWidth_Old = lTV_SLLP.getScale_Width();
        float lTextView_ScaleHeight_Old = lTV_SLLP.getScale_Height();
        float lTextView_ScaleWidth_New = lTextView_ScaleWidth_Old;
        float lTextView_ScaleHeight_New = lTextView_ScaleHeight_Old;
        float lTextSize_New = lTV_SLLP.mScale_TextSize * pScale_TextViewMeasure_Pre;
        if (this.isDifferentSufficiently(lTextSize_New, pTV_Text.getTextSize())) {
            pTV_Text.setTextSize(0, lTextSize_New);
        }
        switch (lTextView_WrapContent_Direction) {
            case Top: 
            case Bottom: 
            case Center_Vertical: {
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(lTextView_ScaleWidth_Old * pScale_TextViewMeasure_Pre)), (int)0x40000000);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                pTV_Text.measure(widthMeasureSpec, heightMeasureSpec);
                float lTextView_Height_New = (float)pTV_Text.getMeasuredHeight() * 1.01f;
                lTextView_ScaleHeight_New = lTextView_Height_New / pScale_TextViewMeasure_Pre;
                break;
            }
            case Left: 
            case Right: 
            case Center_Horizontal: {
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(lTextView_ScaleHeight_Old * pScale_TextViewMeasure_Pre)), (int)0x40000000);
                pTV_Text.measure(widthMeasureSpec, heightMeasureSpec);
                float lTextView_Width_New = (float)pTV_Text.getMeasuredWidth() * 1.01f;
                lTextView_ScaleWidth_New = lTextView_Width_New / pScale_TextViewMeasure_Pre;
                if (lTV_SLLP.getTextView_WrapContent_Scale_MaxWidth() == -1.0f || !(lTextView_ScaleWidth_New > lTV_SLLP.getTextView_WrapContent_Scale_MaxWidth())) break;
                lTextView_ScaleWidth_New = lTV_SLLP.getTextView_WrapContent_Scale_MaxWidth();
                break;
            }
        }
        if (!this.isDifferentSufficiently(lTextView_ScaleWidth_New, lTextView_ScaleWidth_Old) && !this.isDifferentSufficiently(lTextView_ScaleHeight_New, lTextView_ScaleHeight_Old)) {
            return;
        }
        float lTextView_ScaleWidth_Diff = lTextView_ScaleWidth_New - lTextView_ScaleWidth_Old;
        float lTextView_ScaleHeight_Diff = lTextView_ScaleHeight_New - lTextView_ScaleHeight_Old;
        if (lTV_SLLP.mTextView_WrapContent_MoveSiblings) {
            block92: for (i = 0; i < this.getChildCount(); ++i) {
                View v = this.getChildAt(i);
                if (v == pTV_Text) continue;
                LayoutParams lSLLP = this.getChildLayoutParams(v);
                ViewPosition position = this.getViewPosition(lTV_SLLP, lSLLP);
                switch (lTextView_WrapContent_Direction) {
                    case Top: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Top: {
                                    continue block92;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                                    continue block92;
                                }
                            }
                            this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff);
                            continue block92;
                        }
                        switch (position) {
                            case Top: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() - lTextView_ScaleHeight_Diff);
                            }
                        }
                        continue block92;
                    }
                    case Bottom: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Bottom: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff);
                                    break;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                                }
                            }
                            continue block92;
                        }
                        switch (position) {
                            case Bottom: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff);
                            }
                        }
                        continue block92;
                    }
                    case Center_Vertical: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Top: {
                                    continue block92;
                                }
                                case Bottom: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff);
                                    continue block92;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                                    continue block92;
                                }
                            }
                            this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff / 2.0f, lSLLP.getScale_Width(), lSLLP.getScale_Height());
                            continue block92;
                        }
                        switch (position) {
                            case Top: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() - lTextView_ScaleHeight_Diff / 2.0f);
                                break;
                            }
                            case Bottom: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff / 2.0f);
                            }
                        }
                        continue block92;
                    }
                    case Left: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Left: {
                                    continue block92;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                                    continue block92;
                                }
                            }
                            this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                            continue block92;
                        }
                        switch (position) {
                            case Left: {
                                this.moveChildView(v, lSLLP.getScale_Left() - lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                            }
                        }
                        continue block92;
                    }
                    case Right: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Right: {
                                    this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                                    break;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                                }
                            }
                            continue block92;
                        }
                        switch (position) {
                            case Right: {
                                this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                            }
                        }
                        continue block92;
                    }
                    case Center_Horizontal: {
                        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                            switch (position) {
                                case Left: {
                                    continue block92;
                                }
                                case Right: {
                                    this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                                    continue block92;
                                }
                                case Surrounded: {
                                    this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                                    continue block92;
                                }
                            }
                            this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff / 2.0f, lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height());
                            continue block92;
                        }
                        switch (position) {
                            case Left: {
                                this.moveChildView(v, lSLLP.getScale_Left() - lTextView_ScaleWidth_Diff / 2.0f, lSLLP.getScale_Top());
                                break;
                            }
                            case Right: {
                                this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff / 2.0f, lSLLP.getScale_Top());
                            }
                        }
                        continue block92;
                    }
                }
            }
        } else {
            block93: for (i = 0; i < this.getChildCount(); ++i) {
                View v = this.getChildAt(i);
                if (v == pTV_Text) continue;
                LayoutParams lSLLP = this.getChildLayoutParams(v);
                ViewPosition position = this.getViewPosition(lTV_SLLP, lSLLP);
                switch (lTextView_WrapContent_Direction) {
                    case Top: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                                continue block93;
                            }
                        }
                        this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff);
                        continue block93;
                    }
                    case Bottom: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                            }
                        }
                        continue block93;
                    }
                    case Center_Vertical: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height() + lTextView_ScaleHeight_Diff);
                                continue block93;
                            }
                        }
                        this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top() + lTextView_ScaleHeight_Diff / 2.0f, lSLLP.getScale_Width(), lSLLP.getScale_Height());
                        continue block93;
                    }
                    case Left: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                                continue block93;
                            }
                        }
                        this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Top());
                        continue block93;
                    }
                    case Right: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                            }
                        }
                        continue block93;
                    }
                    case Center_Horizontal: {
                        if (!lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) continue block93;
                        switch (position) {
                            case Surrounded: {
                                this.moveChildView(v, lSLLP.getScale_Left(), lSLLP.getScale_Top(), lSLLP.getScale_Width() + lTextView_ScaleWidth_Diff, lSLLP.getScale_Height());
                                continue block93;
                            }
                        }
                        this.moveChildView(v, lSLLP.getScale_Left() + lTextView_ScaleWidth_Diff / 2.0f, lSLLP.getScale_Top(), lSLLP.getScale_Width(), lSLLP.getScale_Height());
                        continue block93;
                    }
                }
            }
        }
        switch (lTextView_WrapContent_Direction) {
            case Top: {
                if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                    this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTV_SLLP.getScale_Width(), lTextView_ScaleHeight_New);
                    break;
                }
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top() - lTextView_ScaleHeight_Diff, lTV_SLLP.getScale_Width(), lTextView_ScaleHeight_New);
                break;
            }
            case Bottom: {
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTV_SLLP.getScale_Width(), lTextView_ScaleHeight_New);
                break;
            }
            case Center_Vertical: {
                if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                    this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTV_SLLP.getScale_Width(), lTextView_ScaleHeight_New);
                    break;
                }
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top() - lTextView_ScaleHeight_Diff / 2.0f, lTV_SLLP.getScale_Width(), lTextView_ScaleHeight_New);
                break;
            }
            case Left: {
                if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                    this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTextView_ScaleWidth_New, lTV_SLLP.getScale_Height());
                    break;
                }
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left() - lTextView_ScaleWidth_Diff, lTV_SLLP.getScale_Top(), lTextView_ScaleWidth_New, lTV_SLLP.getScale_Height());
                break;
            }
            case Right: {
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTextView_ScaleWidth_New, lTV_SLLP.getScale_Height());
                break;
            }
            case Center_Horizontal: {
                if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
                    this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left(), lTV_SLLP.getScale_Top(), lTextView_ScaleWidth_New, lTV_SLLP.getScale_Height());
                    break;
                }
                this.moveChildView((View)pTV_Text, lTV_SLLP.getScale_Left() - lTextView_ScaleWidth_Diff / 2.0f, lTV_SLLP.getScale_Top(), lTextView_ScaleWidth_New, lTV_SLLP.getScale_Height());
                break;
            }
        }
        if (lTV_SLLP.mTextView_WrapContent_ResizeSurrounded) {
            this.setScaleSize(this.getScaleWidth() + lTextView_ScaleWidth_Diff, this.getScaleHeight() + lTextView_ScaleHeight_Diff, false);
        }
    }

    public TextView addNewTextView(String pText, float pScale_TextSize, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        return this.addNewTextView(pText, pScale_TextSize, pScale_Left, pScale_Top, pScale_Width, pScale_Height, false);
    }

    public TextView addNewTextView(String pText, float pScale_TextSize, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height, boolean pDuplicateState) {
        TextView ret = new TextView(this.getContext());
        this.addView((View)ret, pScale_Left, pScale_Top, pScale_Width, pScale_Height);
        this.setScale_TextSize(ret, pScale_TextSize);
        ret.setText((CharSequence)pText);
        ret.setGravity(17);
        ret.setTextColor(-16777216);
        ret.setDuplicateParentStateEnabled(pDuplicateState);
        return ret;
    }

    public EditText addNewEditText(float pScale_TextSize, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        EditText ret = new EditText(this.getContext());
        this.addView((View)ret, pScale_Left, pScale_Top, pScale_Width, pScale_Height);
        this.setScale_TextSize((TextView)ret, pScale_TextSize);
        ret.setGravity(17);
        ret.setTextColor(-16777216);
        return ret;
    }

    public ImageView addNewImageView(float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        return this.addNewImageView(null, pScale_Left, pScale_Top, pScale_Width, pScale_Height, false);
    }

    public ImageView addNewImageView(Bitmap pBitmap, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        BitmapDrawable bm = new BitmapDrawable(this.getResources(), pBitmap);
        return this.addNewImageView((Drawable)bm, pScale_Left, pScale_Top, pScale_Width, pScale_Height, false);
    }

    public ImageView addNewImageView(int pResID, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        return this.addNewImageView(pResID, pScale_Left, pScale_Top, pScale_Width, pScale_Height, false);
    }

    public ImageView addNewImageView(int pResID, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height, boolean pDuplicateState) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return this.addNewImageView((Drawable)new BitmapDrawable(this.getResources(), BitmapFactory.decodeResource((Resources)this.getResources(), (int)pResID, (BitmapFactory.Options)options)), pScale_Left, pScale_Top, pScale_Width, pScale_Height, pDuplicateState);
    }

    public ImageView addNewImageView(Drawable drawable, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
        return this.addNewImageView(drawable, pScale_Left, pScale_Top, pScale_Width, pScale_Height, false);
    }

    public ImageView addNewImageView(Drawable drawable, float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height, boolean pDuplicateState) {
        ImageView lNewImageView = new ImageView(this.getContext());
        lNewImageView.setImageDrawable(drawable);
        lNewImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        lNewImageView.setDuplicateParentStateEnabled(pDuplicateState);
        this.addView((View)lNewImageView, pScale_Left, pScale_Top, pScale_Width, pScale_Height);
        return lNewImageView;
    }

    public String toString() {
        return String.format("{ScalableLayout:%08x}", ((Object)((Object)this)).hashCode());
    }

    void log(String pLog) {
        if (sLogTag_Global != null) {
            Log.e((String)sLogTag_Global, (String)((Object)((Object)this) + "] " + pLog));
        }
        if (this.mLogTag_This != null) {
            Log.e((String)this.mLogTag_This, (String)((Object)((Object)this) + "] " + pLog));
        }
    }

    public String getLogTag_This() {
        return this.mLogTag_This;
    }

    public void setThisLoggable() {
        this.setThisLoggable("ScalableLayout");
    }

    public void setThisLoggable(String pLogTag) {
        this.mLogTag_This = pLogTag;
    }

    private static String getStackTrace(StackTraceElement[] ste) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ste.length; ++i) {
            sb.append("\t" + ste[i].toString() + "\n");
        }
        return sb.toString();
    }

    private static void ex(Throwable e) {
    }

    public static void setLoggable() {
        ScalableLayout.setLoggable("ScalableLayout");
    }

    public static void setLoggable(String pLogTag) {
        sLogTag_Global = pLogTag;
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        private float mScale_Left = 0.0f;
        private int mScale_Left_BasePosition;
        private float mScale_Top = 0.0f;
        private int mScale_Top_BasePosition;
        private float mScale_Width = 100.0f;
        private float mScale_Height = 100.0f;
        private float mScale_TextSize = -1.0f;
        private float mTextView_WrapContent_Scale_MaxWidth = -1.0f;
        private TextView_WrapContent_Direction mTextView_WrapContent_Direction = TextView_WrapContent_Direction.None;
        private boolean mTextView_WrapContent_ResizeSurrounded = false;
        private boolean mTextView_WrapContent_MoveSiblings = true;

        public LayoutParams(Context pContext, AttributeSet pAttrs) {
            super(pContext, pAttrs);
            TextView_WrapContent_Direction dir = TextView_WrapContent_Direction.None;
            TypedArray attrs_view = pContext.obtainStyledAttributes(pAttrs, R.styleable.View2);
            float lScale_Left = attrs_view.getFloat(R.styleable.View2_scale_left, 0.0f);
            int lLeft_BasePosition = attrs_view.getInteger(R.styleable.View2_scale_left_baseposition, 0);
            float lScale_Top = attrs_view.getFloat(R.styleable.View2_scale_top, 0.0f);
            int lTop_BasePosition = attrs_view.getInteger(R.styleable.View2_scale_top_baseposition, 0);
            this.setScale_Left(lScale_Left);
            this.setScale_Left_BasePosition(lLeft_BasePosition);
            this.setScale_Top(lScale_Top);
            this.setScale_Top_BasePosition(lTop_BasePosition);
            this.setScale_Width(attrs_view.getFloat(R.styleable.View2_scale_width, 100.0f));
            this.setScale_Height(attrs_view.getFloat(R.styleable.View2_scale_height, 100.0f));
            this.setScale_TextSize(attrs_view.getFloat(R.styleable.View2_scale_textsize, 100.0f));
            TypedArray attrs_textview = pContext.obtainStyledAttributes(pAttrs, R.styleable.TextView);
            int dirstr = attrs_textview.getInteger(R.styleable.TextView_textview_wrapcontent_direction, 0);
            for (TextView_WrapContent_Direction d : TextView_WrapContent_Direction.values()) {
                if (d.mValue != dirstr) continue;
                dir = d;
                break;
            }
            this.setTextView_WrapContent(dir, attrs_textview.getBoolean(R.styleable.TextView_textview_wrapcontent_resizesurrounded, false), attrs_textview.getBoolean(R.styleable.TextView_textview_wrapcontent_movesiblings, true));
            this.setTextView_WrapContent_Scale_MaxWidth(attrs_textview.getFloat(R.styleable.TextView_textview_wrapcontent_scale_maxwidth, -1.0f));
        }

        public LayoutParams(float pScale_Left, float pScale_Top, float pScale_Width, float pScale_Height) {
            this(pScale_Left, 0, pScale_Top, 0, pScale_Width, pScale_Height);
        }

        public LayoutParams(float pScale_Left, int pScale_Left_BasePosition, float pScale_Top, int pScale_Top_BasePosition, float pScale_Width, float pScale_Height) {
            this(pScale_Left, pScale_Left_BasePosition, pScale_Top, pScale_Top_BasePosition, pScale_Width, pScale_Height, 100.0f, TextView_WrapContent_Direction.None, false, true);
        }

        private LayoutParams(float pScale_Left, int pScale_Left_BasePosition, float pScale_Top, int pScale_Top_BasePosition, float pScale_Width, float pScale_Height, float pScale_TextSize, TextView_WrapContent_Direction pTextView_WrapContent_Direction, boolean pTextView_WrapContent_ResizeSurrounded, boolean pTextView_WrapContent_MoveSiblings) {
            super(-2, -2, 51);
            this.setScale_Left(pScale_Left);
            this.setScale_Left_BasePosition(pScale_Left_BasePosition);
            this.setScale_Top(pScale_Top);
            this.setScale_Top_BasePosition(pScale_Top_BasePosition);
            this.setScale_Width(pScale_Width);
            this.setScale_Height(pScale_Height);
            this.setScale_TextSize(pScale_TextSize);
            this.setTextView_WrapContent(pTextView_WrapContent_Direction, pTextView_WrapContent_ResizeSurrounded, pTextView_WrapContent_MoveSiblings);
        }

        private LayoutParams(ViewGroup.LayoutParams pLayoutParams) {
            this(0.0f, 0.0f, 100.0f, 100.0f);
            this.width = pLayoutParams.width;
            this.height = pLayoutParams.height;
            this.layoutAnimationParameters = pLayoutParams.layoutAnimationParameters;
            this.gravity = 51;
        }

        public String toString() {
            return String.format("%08x (%6.3f, %6.3f) (%6.3f, %6.3f)", ((Object)((Object)this)).hashCode(), Float.valueOf(this.getScale_Left()), Float.valueOf(this.getScale_Top()), Float.valueOf(this.getScale_Right()), Float.valueOf(this.getScale_Bottom()));
        }

        public float getScale_Left() {
            return this.mScale_Left;
        }

        public void setScale_Left(float pScale_Left) {
            this.mScale_Left = pScale_Left;
        }

        public float getScale_Right() {
            return this.getScale_Left() + this.getScale_Width();
        }

        public int getScale_Left_BasePosition() {
            return this.mScale_Left_BasePosition;
        }

        public void setScale_Left_BasePosition(int pScale_Left_BasePosition) {
            this.mScale_Left_BasePosition = pScale_Left_BasePosition;
        }

        public float getScale_Top() {
            return this.mScale_Top;
        }

        public void setScale_Top(float pScale_Top) {
            this.mScale_Top = pScale_Top;
        }

        public float getScale_Bottom() {
            return this.getScale_Top() + this.getScale_Height();
        }

        public int getScale_Top_BasePosition() {
            return this.mScale_Top_BasePosition;
        }

        public void setScale_Top_BasePosition(int pScale_Top_BasePosition) {
            this.mScale_Top_BasePosition = pScale_Top_BasePosition;
        }

        public float getScale_Width() {
            return this.mScale_Width;
        }

        public void setScale_Width(float pScale_Width) {
            this.mScale_Width = pScale_Width;
        }

        public float getScale_Height() {
            return this.mScale_Height;
        }

        public void setScale_Height(float pScale_Height) {
            this.mScale_Height = pScale_Height;
        }

        public float getScale_TextSize() {
            return this.mScale_TextSize;
        }

        public void setScale_TextSize(float pScale_TextSize) {
            this.mScale_TextSize = pScale_TextSize;
        }

        public float getTextView_WrapContent_Scale_MaxWidth() {
            return this.mTextView_WrapContent_Scale_MaxWidth;
        }

        public void setTextView_WrapContent_Scale_MaxWidth(float pTextView_WrapContent_Scale_MaxWidth) {
            this.mTextView_WrapContent_Scale_MaxWidth = pTextView_WrapContent_Scale_MaxWidth;
        }

        public void setTextView_WrapContent(TextView_WrapContent_Direction pTextView_WrapContent_Direction, boolean pTextView_WrapContent_ResizeSurrounded, boolean pTextView_WrapContent_MoveSiblings) {
            this.mTextView_WrapContent_Direction = pTextView_WrapContent_Direction;
            this.mTextView_WrapContent_ResizeSurrounded = pTextView_WrapContent_ResizeSurrounded;
            this.mTextView_WrapContent_MoveSiblings = pTextView_WrapContent_MoveSiblings;
        }
    }

    public static enum TextView_WrapContent_Direction {
        None(0),
        Left(10),
        Center_Horizontal(20),
        Right(30),
        Top(100),
        Center_Vertical(200),
        Bottom(300);

        int mValue = 0;

        private TextView_WrapContent_Direction(int pValue) {
            this.mValue = pValue;
        }
    }

    private static enum ViewPosition {
        Top,
        Bottom,
        Left,
        Right,
        Surrounded,
        Nothing;

    }
}

