package com.sshtools.server.vsession.commands.admin;

/*-
 * #%L
 * Virtual Sessions
 * %%
 * Copyright (C) 2002 - 2024 JADAPTIVE Limited
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.io.IOException;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.jvm.Mem;
import com.sshtools.server.vsession.jvm.ThreadDump;
import com.sshtools.server.vsession.jvm.Threads;

public class AdminCommandFactory extends CommandFactory<ShellCommand> {

	public AdminCommandFactory() {

		installShellCommands();
	}
	
	protected void installShellCommands() {
		
		commands.put("threads", Threads.class);
		commands.put("shutdown", Shutdown.class);
		commands.put("con", Connections.class);
		commands.put("mem", Mem.class);
		commands.put("threaddump", ThreadDump.class);
	}

	@Override
	protected void configureCommand(ShellCommand c, SshConnection con) throws IOException, PermissionDeniedException {
		super.configureCommand(c, con);
	}

}
