/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.sftp;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.commands.sftp.SftpCommand;
import java.io.IOException;

public class Lcd
extends SftpCommand {
    public Lcd() {
        super("lcd", "SFTP", "lcd", "Moves the working directory to a new directory");
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        if (args.length > 2) {
            throw new IllegalArgumentException("Too many arguments.");
        }
        if (args.length > 1) {
            this.cdLocal(args[1]);
        } else {
            this.cdLocal((String)console.getEnvironment().getOrDefault("HOME", ""));
        }
    }

    private void cdLocal(String directory) {
        try {
            this.sftp.lcd(directory);
        }
        catch (PermissionDeniedException | SftpStatusException | IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

