/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBufferPool {
    private ArrayList<ByteBuffer> pool = new ArrayList();
    private int capacity = 4096;
    private int allocated = 0;
    private long totalDirectMemoryAllocated = 0L;

    public ByteBufferPool() {
    }

    public ByteBufferPool(int capacity, boolean direct) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getAllocatedBuffers() {
        return this.allocated;
    }

    public int getFreeBuffers() {
        return this.pool.size();
    }

    public long getTotalMemoryInUse() {
        return this.totalDirectMemoryAllocated - (long)(this.pool.size() * this.capacity);
    }

    public synchronized long getTotalMemoryAllocated() {
        return this.totalDirectMemoryAllocated;
    }

    public synchronized ByteBuffer get() {
        if (this.pool.isEmpty()) {
            ++this.allocated;
            ByteBuffer buf = ByteBuffer.allocate(this.capacity);
            this.totalDirectMemoryAllocated += (long)this.capacity;
            return buf;
        }
        ByteBuffer buffer = this.pool.remove(this.pool.size() - 1);
        buffer.clear();
        return buffer;
    }

    public synchronized void add(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.capacity() == this.capacity) {
            buffer.clear();
            this.pool.add(buffer);
        }
    }
}

