/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.KeyConstraints;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class SshAgentAddKey
extends AgentMessage {
    SshPrivateKey prvkey;
    SshPublicKey pubkey;
    String description;
    KeyConstraints constraints;

    public SshAgentAddKey() {
        super(202);
    }

    public SshAgentAddKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) {
        super(202);
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.description = description;
        this.constraints = constraints;
    }

    public SshPrivateKey getPrivateKey() {
        return this.prvkey;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyConstraints getKeyConstraints() {
        return this.constraints;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_ADD_KEY";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.write(202);
            SshKeyPair keyPair = new SshKeyPair();
            keyPair.setPrivateKey(this.prvkey);
            keyPair.setPublicKey(this.pubkey);
            baw.writeBinaryString(SshPrivateKeyFileFactory.create((SshKeyPair)keyPair, null, null).getFormattedKey());
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeString(this.description);
            baw.write(this.constraints.toByteArray());
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (SshException e) {
            throw new InvalidMessageException(e.getMessage(), 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            bar.read();
            SshKeyPair keyPair = SshPrivateKeyFileFactory.parse((byte[])bar.readBinaryString()).toKeyPair(null);
            bar.readBinaryString();
            this.prvkey = keyPair.getPrivateKey();
            this.pubkey = keyPair.getPublicKey();
            this.description = bar.readString();
            this.constraints = new KeyConstraints(bar);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (InvalidPassphraseException e) {
            e.printStackTrace();
        }
    }
}

