/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.openssh;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class OpenSshSignRequest
extends AgentMessage {
    SshPublicKey pubkey;
    byte[] data;
    int flags;

    public OpenSshSignRequest() {
        super(13);
    }

    public OpenSshSignRequest(SshPublicKey pubkey, byte[] data) {
        super(13);
        this.pubkey = pubkey;
        this.data = data;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public byte[] getOperationData() {
        return this.data;
    }

    @Override
    public String getMessageName() {
        return "SSH2_AGENTC_SIGN_REQUEST";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeBinaryString(this.data);
            baw.writeInt(this.flags);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (SshException e) {
            throw new InvalidMessageException(e.getMessage(), 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.pubkey = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])bar.readBinaryString());
            this.data = bar.readBinaryString();
            this.flags = (int)bar.readInt();
            bar.read(this.data);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }
}

