/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class SshAgentFailure
extends AgentMessage {
    private int errorcode;

    public SshAgentFailure() {
        super(102);
    }

    public SshAgentFailure(int errorcode) {
        super(102);
        this.errorcode = errorcode;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_FAILURE";
    }

    public int getErrorCode() {
        return this.errorcode;
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeInt(this.errorcode);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException(ioe.getMessage(), 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            if (bar.available() > 0) {
                this.errorcode = (int)bar.readInt();
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException(ioe.getMessage(), 13);
        }
    }
}

