/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent;

import com.sshtools.agent.ForwardingNotice;
import com.sshtools.agent.KeyConstraints;
import com.sshtools.agent.KeyStore;
import com.sshtools.agent.KeyStoreListener;
import com.sshtools.agent.exceptions.KeyTimeoutException;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class InMemoryKeyStore
implements KeyStore {
    HashMap<String, String> descriptions = new HashMap();
    HashMap<String, SshPublicKey> publickeys = new HashMap();
    HashMap<String, SshPrivateKey> privatekeys = new HashMap();
    HashMap<String, KeyConstraints> constraints = new HashMap();
    Vector<SshPublicKey> index = new Vector();
    Vector<KeyStoreListener> listeners = new Vector();
    String lockedPassword = null;

    @Override
    public Map<SshPublicKey, String> getPublicKeys() {
        HashMap<SshPublicKey, String> res = new HashMap<SshPublicKey, String>();
        for (Map.Entry<String, SshPublicKey> key : this.publickeys.entrySet()) {
            res.put(key.getValue(), this.descriptions.get(key.getKey()));
        }
        return Collections.unmodifiableMap(res);
    }

    public int indexOf(SshPublicKey key) {
        return this.index.indexOf(key);
    }

    public SshPublicKey elementAt(int i) {
        return this.index.elementAt(i);
    }

    @Override
    public KeyConstraints getKeyConstraints(SshPublicKey key) {
        return this.constraints.get(SshKeyUtils.getFingerprint((SshPublicKey)key));
    }

    @Override
    public int size() {
        return this.index.size();
    }

    public void addKeyStoreListener(KeyStoreListener listener) {
        this.listeners.add(listener);
    }

    public void removeKeyStoreListener(KeyStoreListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints cs) throws IOException {
        String fingerprint = this.getFingerprint(pubkey);
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            if (!this.publickeys.containsKey(fingerprint)) {
                this.publickeys.put(fingerprint, pubkey);
                this.privatekeys.put(fingerprint, prvkey);
                this.constraints.put(fingerprint, cs);
                this.descriptions.put(fingerprint, description);
                this.index.add(pubkey);
                for (KeyStoreListener listener : this.listeners) {
                    listener.onAddKey(this);
                }
                return true;
            }
            return false;
        }
    }

    private String getFingerprint(SshPublicKey key) {
        try {
            return key.getFingerprint();
        }
        catch (SshException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean addKey(SshKeyPair pair, String description, KeyConstraints cs) throws IOException {
        return this.addKey(pair.getPrivateKey(), pair.getPublicKey(), description, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAllKeys() {
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            this.publickeys.clear();
            this.privatekeys.clear();
            this.constraints.clear();
            this.index.clear();
            for (KeyStoreListener listener : this.listeners) {
                listener.onDeleteAllKeys(this);
            }
        }
        return true;
    }

    @Override
    public byte[] performHashAndSign(SshPublicKey pubkey, List<ForwardingNotice> forwardingNodes, byte[] data, int flags) throws KeyTimeoutException, SshException {
        String fingerprint = this.getFingerprint(pubkey);
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.privatekeys.containsKey(fingerprint)) {
                SshPrivateKey key = this.privatekeys.get(fingerprint);
                KeyConstraints cs = this.constraints.get(fingerprint);
                if (cs.canUse()) {
                    if (!cs.hasTimedOut()) {
                        cs.use();
                        try {
                            String signingAlgorithm = pubkey.getSigningAlgorithm();
                            switch (flags) {
                                case 2: {
                                    if (!(pubkey instanceof SshRsaPublicKey)) break;
                                    signingAlgorithm = "rsa-sha2-256";
                                    break;
                                }
                                case 4: {
                                    if (!(pubkey instanceof SshRsaPublicKey)) break;
                                    signingAlgorithm = "rsa-sha2-512";
                                    break;
                                }
                            }
                            byte[] sig = key.sign(data, signingAlgorithm);
                            for (KeyStoreListener listener : this.listeners) {
                                listener.onKeyOperation(this, "hash-and-sign");
                            }
                            return sig;
                        }
                        catch (IOException ioe) {
                            throw new SshException(ioe.getMessage(), 13);
                        }
                    }
                    throw new KeyTimeoutException();
                }
                throw new KeyTimeoutException();
            }
            throw new SshException("The key does not exist", 13);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteKey(SshPublicKey pubkey) throws IOException {
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            String fingerprint = SshKeyUtils.getFingerprint((SshPublicKey)pubkey);
            if (this.publickeys.containsKey(fingerprint)) {
                this.publickeys.remove(fingerprint);
                this.privatekeys.remove(fingerprint);
                this.constraints.remove(fingerprint);
                this.index.remove(pubkey);
                for (KeyStoreListener listener : this.listeners) {
                    listener.onDeleteKey(this);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(String password) throws IOException {
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword == null) {
                this.lockedPassword = password;
                for (KeyStoreListener listener : this.listeners) {
                    listener.onLock(this);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(String password) throws IOException {
        HashMap<String, SshPublicKey> hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword != null && password.equals(this.lockedPassword)) {
                this.lockedPassword = null;
                for (KeyStoreListener listener : this.listeners) {
                    listener.onUnlock(this);
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean isLocked() {
        return this.lockedPassword != null;
    }
}

