/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;

public class SshAgentForwardingNotice
extends AgentMessage {
    String remoteHostname;
    String remoteIPAddress;
    UnsignedInteger32 remotePort;

    public SshAgentForwardingNotice() {
        super(206);
    }

    public SshAgentForwardingNotice(String remoteHostname, String remoteIPAddress, int remotePort) {
        super(206);
        this.remoteHostname = remoteHostname;
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = new UnsignedInteger32((long)remotePort);
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public int getRemotePort() {
        return this.remotePort.intValue();
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_FORWARDING_NOTICE";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeString(this.remoteHostname);
            baw.writeString(this.remoteIPAddress);
            baw.writeUINT32(this.remotePort);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.remoteHostname = bar.readString();
            this.remoteIPAddress = bar.readString();
            this.remotePort = bar.readUINT32();
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }
}

