/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.server;

import com.sshtools.agent.KeyStore;
import com.sshtools.agent.exceptions.AgentNotAvailableException;
import com.sshtools.agent.rfc.RFCAgentConnection;
import com.sshtools.common.logger.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SshAgentSocketListener {
    private boolean start = false;
    KeyStore keystore;
    ServerSocket server;
    int port;
    Thread thread;
    String location;

    public SshAgentSocketListener(String location, KeyStore keystore) throws AgentNotAvailableException {
        Log.info((String)"New SshAgent instance created", (Object[])new Object[0]);
        this.location = location;
        if (location == null) {
            throw new AgentNotAvailableException();
        }
        int idx = location.indexOf(":");
        if (idx == -1) {
            throw new AgentNotAvailableException();
        }
        String host = location.substring(0, idx);
        this.port = Integer.parseInt(location.substring(idx + 1));
        this.keystore = keystore;
        try {
            this.server = new ServerSocket(this.port, 5, InetAddress.getByName(host));
            this.port = this.server.getLocalPort();
            this.location = host + ":" + this.port;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getState() {
        return this.start;
    }

    public void start() {
        Log.info((String)"Staring..", (Object[])new Object[0]);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket socket;
                    System.setProperty("sshtools.agent", SshAgentSocketListener.this.location);
                    SshAgentSocketListener.this.start = true;
                    while ((socket = SshAgentSocketListener.this.server.accept()) != null) {
                        Log.info((String)"waiting for client", (Object[])new Object[0]);
                        new RFCAgentConnection(SshAgentSocketListener.this.keystore, socket.getInputStream(), socket.getOutputStream(), socket);
                    }
                    SshAgentSocketListener.this.thread = null;
                }
                catch (IOException ex) {
                    Log.info((String)("The agent listener closed: " + ex.getMessage()), (Object[])new Object[0]);
                }
                finally {
                    SshAgentSocketListener.this.start = false;
                }
            }
        });
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected KeyStore getKeystore() {
        return this.keystore;
    }

    public String getLocation() {
        return this.location;
    }
}

