/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Comment;
import com.sromku.simple.fb.entities.Photo;
import com.sromku.simple.fb.entities.Privacy;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.User;
import com.sromku.simple.fb.utils.Logger;
import com.sromku.simple.fb.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;

public class Video
implements Publishable {
    private static final String COMMENTS = "comments";
    private static final String CREATED_TIME = "created_time";
    private static final String DESCRIPTION = "description";
    private static final String EMBED_HTML = "embed_html";
    private static final String FROM = "from";
    private static final String ICON = "icon";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PICTURE = "picture";
    private static final String SOURCE = "source";
    private static final String TAGS = "tags";
    private static final String UPDATED_TIME = "updated_time";
    private static final String TITLE = "title";
    private static final String PRIVACY = "privacy";
    @SerializedName(value="comments")
    private Utils.DataResult<Comment> mComments;
    @SerializedName(value="created_time")
    private Date mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="embed_html")
    private String mEmbedHtml = null;
    @SerializedName(value="from")
    private User mFrom = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="tags")
    private Utils.DataResult<User> mTags = null;
    @SerializedName(value="updated_time")
    private Date mUpdatedTime = null;
    @SerializedName(value="privacy")
    private Privacy mPrivacy = null;
    private String mFileName = null;
    private Parcelable mParcelable = null;
    private byte[] mBytes = null;

    private Video(Builder builder) {
        this.mDescription = builder.mDescription;
        this.mName = builder.mTitle;
        this.mFileName = builder.mFileName;
        this.mPrivacy = builder.mPrivacy;
        this.mParcelable = builder.mParcelable;
        this.mBytes = builder.mBytes;
    }

    @Override
    public String getPath() {
        return "videos";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.mName != null) {
            bundle.putString(TITLE, this.mName);
        }
        if (this.mDescription != null) {
            bundle.putString(DESCRIPTION, this.mDescription);
        }
        if (this.mPrivacy != null) {
            bundle.putString(PRIVACY, this.mPrivacy.getJSONString());
        }
        if (this.mParcelable != null) {
            bundle.putParcelable(this.mFileName, this.mParcelable);
        } else if (this.mBytes != null) {
            bundle.putByteArray(this.mFileName, this.mBytes);
        }
        return bundle;
    }

    public List<Comment> getComments() {
        return this.mComments.data;
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getEmbedHtml() {
        return this.mEmbedHtml;
    }

    public User getFrom() {
        return this.mFrom;
    }

    public String getIcon() {
        return this.mIcon;
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getPicture() {
        return this.mPicture;
    }

    public String getSource() {
        return this.mSource;
    }

    public List<User> getTags() {
        return this.mTags.data;
    }

    public Date getUpdateTime() {
        return this.mUpdatedTime;
    }

    public static class Builder {
        private String mDescription = null;
        private String mTitle = null;
        private String mFileName = null;
        private Privacy mPrivacy = null;
        private Parcelable mParcelable = null;
        private byte[] mBytes = null;

        public Builder setVideo(File file) {
            try {
                this.mParcelable = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                this.mFileName = file.getName();
            }
            catch (FileNotFoundException e) {
                Logger.logError(Photo.class, "Failed to create photo from file", e);
            }
            return this;
        }

        public Builder setVideo(String fileName, byte[] bytes) {
            this.mBytes = bytes;
            this.mFileName = fileName;
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setName(String name) {
            this.mTitle = name;
            return this;
        }

        public Builder setPrivacy(Privacy privacy) {
            this.mPrivacy = privacy;
            return this;
        }

        public Video build() {
            return new Video(this);
        }
    }
}

