/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Privacy;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Feed
implements Publishable {
    private Bundle mBundle = null;

    private Feed(Builder builder) {
        this.mBundle = builder.mBundle;
    }

    @Override
    public Bundle getBundle() {
        return this.mBundle;
    }

    @Override
    public String getPath() {
        return "feed";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public static class Builder {
        Bundle mBundle;
        JSONObject mProperties = new JSONObject();
        JSONObject mActions = new JSONObject();

        public Builder() {
            this.mBundle = new Bundle();
        }

        public Builder setPlace(String pageId) {
            this.mBundle.putString("place", pageId);
            return this;
        }

        public Builder setName(String name) {
            this.mBundle.putString("name", name);
            return this;
        }

        public Builder setMessage(String message) {
            this.mBundle.putString("message", message);
            return this;
        }

        public Builder setLink(String link) {
            this.mBundle.putString("link", link);
            return this;
        }

        public Builder setPicture(String picture) {
            this.mBundle.putString("picture", picture);
            return this;
        }

        public Builder setCaption(String caption) {
            this.mBundle.putString("caption", caption);
            return this;
        }

        public Builder setDescription(String description) {
            this.mBundle.putString("description", description);
            return this;
        }

        public Builder setPrivacy(Privacy privacy) {
            this.mBundle.putString("privacy", privacy.getJSONString());
            return this;
        }

        public Builder addProperty(String text, String secondText) {
            try {
                this.mProperties.put(text, (Object)secondText);
            }
            catch (JSONException e) {
                Logger.logError(Feed.class, "Failed to add property", e);
            }
            return this;
        }

        public Builder addProperty(String text, String linkName, String link) {
            JSONObject json = new JSONObject();
            try {
                json.put("text", (Object)linkName);
                json.put("href", (Object)link);
                this.mProperties.put(text, (Object)json);
            }
            catch (JSONException e) {
                Logger.logError(Feed.class, "Failed to add property", e);
            }
            return this;
        }

        public Builder addAction(String name, String link) {
            try {
                this.mActions.put("name", (Object)name);
                this.mActions.put("link", (Object)link);
            }
            catch (JSONException e) {
                Logger.logError(Feed.class, "Failed to add action", e);
            }
            return this;
        }

        public Feed build() {
            if (this.mProperties.length() > 0) {
                this.mBundle.putString("properties", this.mProperties.toString());
            }
            if (this.mActions.length() > 0) {
                this.mBundle.putString("actions", this.mActions.toString());
            }
            return new Feed(this);
        }

        public static class Parameters {
            public static final String MESSAGE = "message";
            public static final String LINK = "link";
            public static final String PICTURE = "picture";
            public static final String NAME = "name";
            public static final String CAPTION = "caption";
            public static final String DESCRIPTION = "description";
            public static final String PROPERTIES = "properties";
            public static final String ACTIONS = "actions";
            public static final String PRIVACY = "privacy";
            public static final String PLACE = "place";
        }
    }
}

