/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Privacy;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.User;
import java.util.Date;

public class Album
implements Publishable {
    private static final String ID = "id";
    private static final String FROM = "from";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MESSAGE = "message";
    private static final String LOCATION = "location";
    private static final String LINK = "link";
    private static final String COUNT = "count";
    private static final String PRIVACY = "privacy";
    private static final String COVER_PHOTO = "cover_photo";
    private static final String TYPE = "type";
    private static final String CREATED_TIME = "created_time";
    private static final String UPDATED_TIME = "updated_time";
    private static final String CAN_UPLOAD = "can_upload";
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="from")
    private User mFrom = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="location")
    private String mLocation = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="count")
    private Integer mCount = null;
    @SerializedName(value="privacy")
    private String mPrivacy = null;
    @SerializedName(value="cover_photo")
    private String mCoverPhotoId = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="created_time")
    private Date mCreatedTime;
    @SerializedName(value="updated_time")
    private Date mUpdatedTime;
    @SerializedName(value="can_upload")
    private boolean mCanUpload;
    private Privacy mPublishPrivacy = null;

    private Album(Builder builder) {
        this.mName = builder.mName;
        this.mDescription = builder.mMessage;
        this.mPublishPrivacy = builder.mPublishPrivacy;
    }

    public String getId() {
        return this.mId;
    }

    public User getFrom() {
        return this.mFrom;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getLink() {
        return this.mLink;
    }

    public Integer getCount() {
        return this.mCount;
    }

    public String getPrivacy() {
        return this.mPrivacy;
    }

    public String getCoverPhotoId() {
        return this.mCoverPhotoId;
    }

    public String getType() {
        return this.mType;
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public Date getUpdatedTime() {
        return this.mUpdatedTime;
    }

    public boolean canUpload() {
        return this.mCanUpload;
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.mName != null) {
            bundle.putString(NAME, this.mName);
        }
        if (this.mDescription != null) {
            bundle.putString(MESSAGE, this.mDescription);
        }
        if (this.mPublishPrivacy != null) {
            bundle.putString(PRIVACY, this.mPublishPrivacy.getJSONString());
        }
        return bundle;
    }

    @Override
    public String getPath() {
        return "albums";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public static class Builder {
        private String mName = null;
        private String mMessage = null;
        private Privacy mPublishPrivacy = null;

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public Builder setPrivacy(Privacy privacy) {
            this.mPublishPrivacy = privacy;
            return this;
        }

        public Album build() {
            return new Album(this);
        }
    }
}

