/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.actions.GetAction;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.listeners.OnLoginListener;
import com.sromku.simple.fb.listeners.OnPublishListener;
import com.sromku.simple.fb.utils.Errors;
import com.sromku.simple.fb.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PublishAction
extends AbstractAction {
    private OnPublishListener mOnPublishListener;
    private Publishable mPublishable;
    private String mTarget = "me";

    public PublishAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setPublishable(Publishable publishable) {
        this.mPublishable = publishable;
    }

    public void setTarget(String target) {
        this.mTarget = target;
    }

    public void setOnPublishListener(OnPublishListener onPublishListener) {
        this.mOnPublishListener = onPublishListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeImpl() {
        if (this.sessionManager.isLogin()) {
            if (this.sessionManager.hasPendingRequest()) return;
            final String neededPermission = this.mPublishable.getPermission().getValue();
            if (this.mOnPublishListener != null) {
                this.mOnPublishListener.onThinking();
            }
            if (!this.sessionManager.hasAccepted(neededPermission)) {
                this.sessionManager.getLoginCallback().loginListener = new OnLoginListener(){

                    @Override
                    public void onException(Throwable throwable) {
                        this.returnFail(throwable != null ? String.valueOf(throwable.getMessage()) : "Got exception on asking for publish permissions");
                    }

                    @Override
                    public void onFail(String reason) {
                        this.returnFail(reason);
                    }

                    @Override
                    public void onLogin(String accessToken, List<Permission> acceptedPermissions, List<Permission> declinedPermissions) {
                        if (PublishAction.this.sessionManager.hasAccepted(neededPermission)) {
                            PublishAction.this.publishImpl(PublishAction.this.mPublishable, PublishAction.this.mOnPublishListener);
                        }
                    }

                    @Override
                    public void onCancel() {
                        this.returnFail("User canceled the publish dialog");
                    }

                    private void returnFail(String reason) {
                        Logger.logError(PublishAction.class, reason, null);
                        if (PublishAction.this.mOnPublishListener != null) {
                            PublishAction.this.mOnPublishListener.onFail(reason);
                        }
                    }
                };
                Permission permission = this.mPublishable.getPermission();
                ArrayList<String> permissions = new ArrayList<String>();
                permissions.add(permission.getValue());
                this.sessionManager.requestPublishPermissions(permissions);
                return;
            } else {
                this.publishImpl(this.mPublishable, this.mOnPublishListener);
            }
            return;
        } else {
            if (this.mOnPublishListener == null) return;
            String reason = Errors.getError(Errors.ErrorMsg.LOGIN);
            Logger.logError(PublishAction.class, reason, null);
            this.mOnPublishListener.onFail(reason);
        }
    }

    private void publishImpl(Publishable publishable, final OnPublishListener onPublishListener) {
        AccessToken accessToken = this.sessionManager.getAccessToken();
        GraphRequest request = new GraphRequest(accessToken, this.mTarget + "/" + publishable.getPath(), publishable.getBundle(), HttpMethod.POST, new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                FacebookRequestError error = response.getError();
                if (error != null) {
                    Logger.logError(GetAction.class, "Failed to publish", (Throwable)error.getException());
                    if (onPublishListener != null) {
                        onPublishListener.onException((Throwable)error.getException());
                    }
                } else if (response.getRawResponse() == null) {
                    Logger.logError(GetAction.class, "The response GraphObject has null value. Response=" + response.toString(), null);
                } else if (onPublishListener != null) {
                    JSONObject jsonObject = response.getJSONObject();
                    String id = jsonObject.optString("id");
                    onPublishListener.onComplete(id);
                }
            }
        });
        GraphRequestAsyncTask task = new GraphRequestAsyncTask(new GraphRequest[]{request});
        task.execute((Object[])new Void[0]);
    }
}

