/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Album;
import com.sromku.simple.fb.entities.Image;
import com.sromku.simple.fb.entities.Place;
import com.sromku.simple.fb.entities.Privacy;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.User;
import com.sromku.simple.fb.utils.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;

public class Photo
implements Publishable {
    private static final String ID = "id";
    private static final String ALBUM = "album";
    private static final String BACKDATED_TIME = "backdated_time";
    private static final String BACKDATED_TIME_GRANULARITY = "backdate_time_granularity";
    private static final String CREATED_TIME = "created_time";
    private static final String FROM = "from";
    private static final String HEIGHT = "height";
    private static final String ICON = "icon";
    private static final String IMAGES = "images";
    private static final String LINK = "link";
    private static final String PAGE_STORY_ID = "page_story_id";
    private static final String PICTURE = "picture";
    private static final String PLACE = "place";
    private static final String SOURCE = "source";
    private static final String UPDATED_TIME = "updated_time";
    private static final String WIDTH = "width";
    private static final String NAME = "name";
    private static final String MESSAGE = "message";
    private static final String PRIVACY = "privacy";
    @SerializedName(value="id")
    private String mId;
    @SerializedName(value="album")
    private Album mAlbum;
    @SerializedName(value="backdated_time")
    private Date mBackDatetime;
    @SerializedName(value="backdate_time_granularity")
    private BackDatetimeGranularity mBackDatetimeGranularity;
    @SerializedName(value="created_time")
    private Date mCreatedTime;
    @SerializedName(value="from")
    private User mFrom;
    @SerializedName(value="height")
    private Integer mHeight;
    @SerializedName(value="icon")
    private String mIcon;
    @SerializedName(value="images")
    private List<Image> mImages;
    @SerializedName(value="link")
    private String mLink;
    @SerializedName(value="name")
    private String mName;
    @SerializedName(value="page_story_id")
    private String mPageStoryId;
    @SerializedName(value="picture")
    private String mPicture;
    @SerializedName(value="source")
    private String mSource;
    @SerializedName(value="updated_time")
    private Date mUpdatedTime;
    @SerializedName(value="width")
    private Integer mWidth;
    @SerializedName(value="place")
    private Place mPlace;
    private String mPlaceId = null;
    private Parcelable mParcelable = null;
    private byte[] mBytes = null;
    private Privacy mPrivacy = null;

    private Photo(Builder builder) {
        this.mName = builder.mName;
        this.mPlaceId = builder.mPlaceId;
        this.mParcelable = builder.mParcelable;
        this.mBytes = builder.mBytes;
        this.mPrivacy = builder.mPrivacy;
    }

    @Override
    public String getPath() {
        return "photos";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public String getId() {
        return this.mId;
    }

    public Album getAlbum() {
        return this.mAlbum;
    }

    public Date getBackDateTime() {
        return this.mBackDatetime;
    }

    public BackDatetimeGranularity getBackDatetimeGranularity() {
        return this.mBackDatetimeGranularity;
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public User getFrom() {
        return this.mFrom;
    }

    public Integer getHeight() {
        return this.mHeight;
    }

    public String getIcon() {
        return this.mIcon;
    }

    public List<Image> getImages() {
        return this.mImages;
    }

    public String getLink() {
        return this.mLink;
    }

    public String getName() {
        return this.mName;
    }

    public String getPageStoryId() {
        return this.mPageStoryId;
    }

    public String getPicture() {
        return this.mPicture;
    }

    public Place getPlace() {
        return this.mPlace;
    }

    public String getSource() {
        return this.mSource;
    }

    public Date getUpdatedTime() {
        return this.mUpdatedTime;
    }

    public Integer getWidth() {
        return this.mWidth;
    }

    public Parcelable getParcelable() {
        return this.mParcelable;
    }

    public String getPlaceId() {
        return this.mPlaceId;
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.mName != null) {
            bundle.putString(MESSAGE, this.mName);
        }
        if (this.mPlaceId != null) {
            bundle.putString(PLACE, this.mPlaceId);
        }
        if (this.mPrivacy != null) {
            bundle.putString(PRIVACY, this.mPrivacy.getJSONString());
        }
        if (this.mParcelable != null) {
            bundle.putParcelable(PICTURE, this.mParcelable);
        } else if (this.mBytes != null) {
            bundle.putByteArray(PICTURE, this.mBytes);
        }
        return bundle;
    }

    public String toString() {
        return this.mSource;
    }

    public static class Builder {
        private String mName = null;
        private String mPlaceId = null;
        private Parcelable mParcelable = null;
        private byte[] mBytes = null;
        private Privacy mPrivacy = null;

        public Builder setImage(Bitmap bitmap) {
            this.mParcelable = bitmap;
            return this;
        }

        public Builder setImage(File file) {
            try {
                this.mParcelable = ParcelFileDescriptor.open((File)file, (int)0x10000000);
            }
            catch (FileNotFoundException e) {
                Logger.logError(Photo.class, "Failed to create photo from file", e);
            }
            return this;
        }

        public Builder setImage(byte[] bytes) {
            this.mBytes = bytes;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setPlace(String placeId) {
            this.mPlaceId = placeId;
            return this;
        }

        public Builder setPrivacy(Privacy privacy) {
            this.mPrivacy = privacy;
            return this;
        }

        public Photo build() {
            return new Photo(this);
        }
    }

    public static enum BackDatetimeGranularity {
        YEAR("year"),
        MONTH("month"),
        DAY("day"),
        HOUR("hour"),
        MIN("min"),
        NONE("none");

        private String mValue;

        private BackDatetimeGranularity(String value) {
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }

        public static BackDatetimeGranularity fromValue(String value) {
            for (BackDatetimeGranularity granularityEnum : BackDatetimeGranularity.values()) {
                if (!granularityEnum.mValue.equals(value)) continue;
                return granularityEnum;
            }
            return NONE;
        }
    }
}

