/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Attachment;
import com.sromku.simple.fb.entities.Post;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.User;
import java.util.Date;
import java.util.List;

public class Comment
implements Publishable {
    private static final String ID = "id";
    private static final String CAN_COMMENT = "can_comment";
    private static final String CAN_REMOVE = "can_remove";
    private static final String COMMENT_COUNT = "comment_count";
    private static final String CREATED_TIME = "created_time";
    private static final String FROM = "from";
    private static final String LIKE_COUNT = "like_count";
    private static final String MESSAGE = "message";
    private static final String MESSAGE_TAGS = "message_tags";
    private static final String PARENT = "parent";
    private static final String USER_LIKES = "user_likes";
    private static final String ATTACHMENT = "attachment";
    private static final String ATTACHMENT_URL = "attachment_url";
    @SerializedName(value="id")
    private String mId;
    @SerializedName(value="attachment")
    private Attachment mAttachment;
    @SerializedName(value="can_comment")
    private Boolean mCanComment;
    @SerializedName(value="can_remove")
    private Boolean mCanRemove;
    @SerializedName(value="comment_count")
    private Integer mCommentCount;
    @SerializedName(value="created_time")
    private Date mCreatedTime;
    @SerializedName(value="from")
    private User mFrom;
    @SerializedName(value="like_count")
    private Integer mLikeCount;
    @SerializedName(value="message")
    private String mMessage;
    @SerializedName(value="message_tags")
    private List<Post.InlineTag> mMessageTags;
    @SerializedName(value="parent")
    private Comment mParent;
    @SerializedName(value="user_likes")
    private Boolean mUserLikes;
    @SerializedName(value="attachment_url")
    private String mAttachmentUrl;

    private Comment(Builder builder) {
        this.mMessage = builder.mMessage;
        this.mAttachmentUrl = builder.mAttachmentUrl;
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.mMessage != null) {
            bundle.putString(MESSAGE, this.mMessage);
        }
        if (this.mAttachmentUrl != null) {
            bundle.putString(ATTACHMENT_URL, this.mAttachmentUrl);
        }
        return bundle;
    }

    @Override
    public String getPath() {
        return "comments";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public String getId() {
        return this.mId;
    }

    public Attachment getAttachment() {
        return this.mAttachment;
    }

    public Boolean getCanComment() {
        return this.mCanComment;
    }

    public Boolean getCanRemove() {
        return this.mCanRemove;
    }

    public Integer getCommentCount() {
        return this.mCommentCount;
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public User getFrom() {
        return this.mFrom;
    }

    public Integer getLikeCount() {
        return this.mLikeCount;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public List<Post.InlineTag> getMessageTags() {
        return this.mMessageTags;
    }

    public Comment getParent() {
        return this.mParent;
    }

    public Boolean getUserLikes() {
        return this.mUserLikes;
    }

    public static class Builder {
        private String mMessage = null;
        private String mAttachmentUrl = null;

        public Builder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public Builder setAttachmentImageUrl(String attachmentImageUrl) {
            this.mAttachmentUrl = attachmentImageUrl;
            return this;
        }

        public Comment build() {
            return new Comment(this);
        }
    }
}

