/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import android.net.Uri;
import android.text.TextUtils;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.widget.ShareDialog;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.entities.Feed;
import com.sromku.simple.fb.listeners.OnPublishListener;

public class PublishFeedDialogAction
extends AbstractAction {
    private OnPublishListener mOnPublishListener;
    private Feed mFeed;

    public PublishFeedDialogAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setFeed(Feed feed) {
        this.mFeed = feed;
    }

    public void setOnPublishListener(OnPublishListener onPublishListener) {
        this.mOnPublishListener = onPublishListener;
    }

    @Override
    protected void executeImpl() {
        ShareLinkContent.Builder shareLinkContent = new ShareLinkContent.Builder().setContentTitle(this.mFeed.getBundle().getString("name")).setContentDescription(this.mFeed.getBundle().getString("description"));
        String link = this.mFeed.getBundle().getString("link");
        if (!TextUtils.isEmpty((CharSequence)link)) {
            shareLinkContent.setContentUrl(Uri.parse((String)link));
        }
        ShareLinkContent linkContent = shareLinkContent.build();
        ShareDialog shareDialog = new ShareDialog(this.sessionManager.getActivity());
        if (shareDialog.canShow((Object)linkContent)) {
            shareDialog.registerCallback(this.sessionManager.getCallbackManager(), (FacebookCallback)new FacebookCallback<Sharer.Result>(){

                public void onSuccess(Sharer.Result result) {
                    String postId = result.getPostId();
                    if (PublishFeedDialogAction.this.mOnPublishListener != null) {
                        PublishFeedDialogAction.this.mOnPublishListener.onComplete(postId);
                    }
                }

                public void onCancel() {
                    if (PublishFeedDialogAction.this.mOnPublishListener != null) {
                        PublishFeedDialogAction.this.mOnPublishListener.onFail("Canceled by user");
                    }
                }

                public void onError(FacebookException e) {
                    if (PublishFeedDialogAction.this.mOnPublishListener != null) {
                        PublishFeedDialogAction.this.mOnPublishListener.onFail(e.getMessage());
                    }
                }
            });
            shareDialog.show((Object)linkContent);
        }
    }
}

