/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb;

import android.app.Activity;
import android.content.Intent;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.SimpleFacebookConfiguration;
import com.sromku.simple.fb.listeners.OnLoginListener;
import com.sromku.simple.fb.listeners.OnLogoutListener;
import com.sromku.simple.fb.listeners.OnNewPermissionsListener;
import com.sromku.simple.fb.utils.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SessionManager {
    private static final Class<?> TAG = SessionManager.class;
    static SimpleFacebookConfiguration configuration;
    private WeakReference<Activity> mActivity;
    private final LoginManager mLoginManager;
    private final LoginCallback mLoginCallback = new LoginCallback();
    private final CallbackManager mCallbackManager = CallbackManager.Factory.create();

    public SessionManager(SimpleFacebookConfiguration configuration) {
        SessionManager.configuration = configuration;
        this.mLoginManager = LoginManager.getInstance();
        this.mLoginManager.registerCallback(this.mCallbackManager, (FacebookCallback)this.mLoginCallback);
        this.mLoginManager.setDefaultAudience(configuration.getDefaultAudience());
        this.mLoginManager.setLoginBehavior(configuration.getLoginBehavior());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    public void login(OnLoginListener onLoginListener) {
        if (onLoginListener == null) {
            Logger.logError(TAG, "OnLoginListener can't be null in -> 'login(OnLoginListener onLoginListener)' method.");
            return;
        }
        if (this.isLogin()) {
            Logger.logInfo(TAG, "You were already logged in before calling 'login()' method.");
            LoginResult loginResult = this.createLastLoginResult();
            onLoginListener.onLogin(loginResult.getAccessToken().getToken(), Permission.convert(this.getAcceptedPermissions()), null);
            return;
        }
        if (this.hasPendingRequest()) {
            Logger.logWarning(TAG, "You are trying to login one more time, before finishing the previous login call");
            onLoginListener.onFail("Already has pending login request");
            return;
        }
        this.loginImpl(onLoginListener);
    }

    private void loginImpl(OnLoginListener onLoginListener) {
        this.mLoginCallback.loginListener = onLoginListener;
        if (configuration.hasPublishPermissions() && configuration.isAllPermissionsAtOnce()) {
            this.mLoginCallback.askPublishPermissions = true;
            this.mLoginCallback.publishPermissions = configuration.getPublishPermissions();
        }
        this.requestReadPermissions(configuration.getReadPermissions());
    }

    public void requestReadPermissions(List<String> permissions) {
        this.mLoginManager.logInWithReadPermissions((Activity)this.mActivity.get(), permissions);
    }

    public void requestPublishPermissions(List<String> permissions) {
        this.mLoginManager.logInWithPublishPermissions((Activity)this.mActivity.get(), permissions);
    }

    private LoginResult createLastLoginResult() {
        return new LoginResult(this.getAccessToken(), this.getAccessToken().getPermissions(), this.getAccessToken().getDeclinedPermissions());
    }

    public void logout(OnLogoutListener onLogoutListener) {
        if (onLogoutListener == null) {
            Logger.logError(TAG, "OnLogoutListener can't be null in -> 'logout(OnLogoutListener onLogoutListener)' method");
            return;
        }
        this.mLoginManager.logOut();
        onLogoutListener.onLogout();
    }

    public boolean isLogin() {
        AccessToken accessToken = this.getAccessToken();
        if (accessToken == null) {
            return false;
        }
        return !accessToken.isExpired();
    }

    public AccessToken getAccessToken() {
        return AccessToken.getCurrentAccessToken();
    }

    public Set<String> getAcceptedPermissions() {
        AccessToken accessToken = this.getAccessToken();
        if (accessToken == null) {
            return new HashSet<String>();
        }
        return accessToken.getPermissions();
    }

    public Set<String> getNotAcceptedPermissions() {
        AccessToken accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        return accessToken.getDeclinedPermissions();
    }

    void setActivity(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public Activity getActivity() {
        return (Activity)this.mActivity.get();
    }

    public LoginCallback getLoginCallback() {
        return this.mLoginCallback;
    }

    public CallbackManager getCallbackManager() {
        return this.mCallbackManager;
    }

    public boolean hasAccepted(String permission) {
        return this.getAcceptedPermissions().contains(permission);
    }

    public void requestNewPermissions(Permission[] perms, final OnNewPermissionsListener onNewPermissionListener) {
        if (onNewPermissionListener == null) {
            Logger.logWarning(TAG, "Must pass listener");
            return;
        }
        List<Permission> permissions = Arrays.asList(perms);
        if (permissions == null || permissions.size() == 0) {
            onNewPermissionListener.onFail("Empty permissions in request");
            return;
        }
        int flag = configuration.getType(permissions);
        if (flag == 0) {
            onNewPermissionListener.onFail("There is no new permissions in your request");
            return;
        }
        this.mLoginCallback.loginListener = new OnLoginListener(){

            @Override
            public void onLogin(String accessToken, List<Permission> acceptedPermissions, List<Permission> declinedPermissions) {
                onNewPermissionListener.onSuccess(accessToken, acceptedPermissions, declinedPermissions);
            }

            @Override
            public void onCancel() {
                onNewPermissionListener.onCancel();
            }

            @Override
            public void onFail(String reason) {
                onNewPermissionListener.onFail(reason);
            }

            @Override
            public void onException(Throwable throwable) {
                onNewPermissionListener.onException(throwable);
            }
        };
        switch (flag) {
            case 1: {
                this.requestReadPermissions(Permission.convert(permissions));
                break;
            }
            case 3: {
                if (configuration.isAllPermissionsAtOnce()) {
                    this.mLoginCallback.askPublishPermissions = true;
                    this.mLoginCallback.publishPermissions = Permission.fetchPermissions(permissions, Permission.Type.PUBLISH);
                }
                this.requestReadPermissions(Permission.fetchPermissions(permissions, Permission.Type.READ));
                break;
            }
            case 2: {
                this.requestPublishPermissions(Permission.convert(permissions));
            }
        }
    }

    public boolean hasPendingRequest() {
        return false;
    }

    private List<String> getNotGrantedReadPermissions() {
        Set<String> grantedPermissions = this.getAcceptedPermissions();
        ArrayList<String> readPermissions = new ArrayList<String>(configuration.getReadPermissions());
        readPermissions.removeAll(grantedPermissions);
        return readPermissions;
    }

    private List<String> getNotGrantedPublishPermissions() {
        Set<String> grantedPermissions = this.getAcceptedPermissions();
        ArrayList<String> publishPermissions = new ArrayList<String>(configuration.getPublishPermissions());
        publishPermissions.removeAll(grantedPermissions);
        return publishPermissions;
    }

    public boolean isAllPermissionsGranted() {
        return this.getNotGrantedReadPermissions().size() <= 0 && this.getNotGrantedPublishPermissions().size() <= 0;
    }

    public void clean() {
        this.mActivity.clear();
    }

    public class LoginCallback
    implements FacebookCallback<LoginResult> {
        public OnLoginListener loginListener;
        boolean doOnLogin = false;
        boolean askPublishPermissions = false;
        List<String> publishPermissions;

        public void onSuccess(LoginResult loginResult) {
            if (this.loginListener != null) {
                if (this.doOnLogin) {
                    this.doOnLogin = false;
                    this.askPublishPermissions = false;
                    this.publishPermissions = null;
                    this.loginListener.onLogin(loginResult.getAccessToken().getToken(), Permission.convert(SessionManager.this.getAcceptedPermissions()), Permission.convert(loginResult.getRecentlyDeniedPermissions()));
                    return;
                }
                if (this.askPublishPermissions && this.publishPermissions != null) {
                    this.doOnLogin = true;
                    this.askPublishPermissions = false;
                    SessionManager.this.requestPublishPermissions(this.publishPermissions);
                } else {
                    this.loginListener.onLogin(loginResult.getAccessToken().getToken(), Permission.convert(SessionManager.this.getAcceptedPermissions()), Permission.convert(loginResult.getRecentlyDeniedPermissions()));
                }
            }
        }

        public void onCancel() {
            this.loginListener.onFail("User canceled the permissions dialog");
        }

        public void onError(FacebookException e) {
            this.loginListener.onException((Throwable)e);
        }
    }
}

