/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import android.app.Activity;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.widget.GameRequestDialog;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.listeners.OnInviteListener;
import com.sromku.simple.fb.utils.Errors;
import com.sromku.simple.fb.utils.Logger;
import java.util.ArrayList;

public class InviteAction
extends AbstractAction {
    private OnInviteListener mOnInviteListener;
    private String mMessage;
    private String mData;
    private String mTo;
    private String[] mSuggestions;
    private static final String PARAM_MESSAGE = "message";
    private static final String PARAM_DATA = "data";
    private static final String PARAM_TO = "to";
    private static final String PARAM_SUGGESTIONS = "suggestions";

    public InviteAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public void setData(String data) {
        this.mData = data;
    }

    public void setTo(String to) {
        this.mTo = to;
    }

    public void setSuggestions(String[] suggestions) {
        this.mSuggestions = suggestions;
    }

    public void setOnInviteListener(OnInviteListener onInviteListener) {
        this.mOnInviteListener = onInviteListener;
    }

    @Override
    protected void executeImpl() {
        if (this.sessionManager.isLogin()) {
            this.openInviteDialog(this.sessionManager.getActivity(), this.mOnInviteListener);
        } else {
            String reason = Errors.getError(Errors.ErrorMsg.LOGIN);
            Logger.logError(InviteAction.class, reason, null);
            this.mOnInviteListener.onFail(reason);
        }
    }

    private void openInviteDialog(Activity activity, OnInviteListener onInviteListener) {
        GameRequestContent gameRequestContent;
        GameRequestDialog dialog;
        GameRequestContent.Builder builder = new GameRequestContent.Builder();
        builder.setMessage(this.mMessage);
        builder.setData(this.mData);
        builder.setTo(this.mTo);
        if (this.mSuggestions != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String suggested : this.mSuggestions) {
                arrayList.add(suggested);
            }
            builder.setSuggestions(arrayList);
        }
        if ((dialog = new GameRequestDialog(activity)).canShow((Object)(gameRequestContent = builder.build()))) {
            dialog.registerCallback(this.sessionManager.getCallbackManager(), (FacebookCallback)new FacebookCallback<GameRequestDialog.Result>(){

                public void onSuccess(GameRequestDialog.Result result) {
                    String requestId = result.getRequestId();
                    if (InviteAction.this.mOnInviteListener != null) {
                        InviteAction.this.mOnInviteListener.onComplete(result.getRequestRecipients(), requestId);
                    }
                }

                public void onCancel() {
                    if (InviteAction.this.mOnInviteListener != null) {
                        InviteAction.this.mOnInviteListener.onFail("Canceled by user");
                    }
                }

                public void onError(FacebookException e) {
                    if (InviteAction.this.mOnInviteListener != null) {
                        InviteAction.this.mOnInviteListener.onFail(e.getMessage());
                    }
                }
            });
            dialog.show((Object)gameRequestContent);
        }
    }
}

