/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.listeners.OnDeleteListener;
import com.sromku.simple.fb.utils.Errors;
import com.sromku.simple.fb.utils.Logger;

public class DeleteRequestAction
extends AbstractAction {
    private OnDeleteListener mOnDeleteListener;
    private String mRequestId;

    public DeleteRequestAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setRequestId(String requestId) {
        this.mRequestId = requestId;
    }

    public void setOnDeleteListener(OnDeleteListener onDeleteRequestListener) {
        this.mOnDeleteListener = onDeleteRequestListener;
    }

    @Override
    protected void executeImpl() {
        if (this.sessionManager.isLogin()) {
            AccessToken accessToken = this.sessionManager.getAccessToken();
            GraphRequest request = new GraphRequest(accessToken, this.mRequestId, null, HttpMethod.DELETE, new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    FacebookRequestError error = response.getError();
                    if (error != null) {
                        Logger.logError(DeleteRequestAction.class, "failed to delete requests", (Throwable)error.getException());
                        if (DeleteRequestAction.this.mOnDeleteListener != null) {
                            DeleteRequestAction.this.mOnDeleteListener.onException((Throwable)error.getException());
                        }
                    } else if (DeleteRequestAction.this.mOnDeleteListener != null) {
                        DeleteRequestAction.this.mOnDeleteListener.onComplete(null);
                    }
                }
            });
            GraphRequest.executeBatchAsync((GraphRequest[])new GraphRequest[]{request});
        } else {
            String reason = Errors.getError(Errors.ErrorMsg.LOGIN);
            Logger.logError(DeleteRequestAction.class, reason, null);
            if (this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onFail(reason);
            }
        }
    }
}

