/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import com.src.webrtc.android.AudioCodec;
import com.src.webrtc.android.LocalAudioTrack;
import com.src.webrtc.android.LocalDataTrack;
import com.src.webrtc.android.LocalVideoTrack;
import com.src.webrtc.android.VideoCodec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u0011\u0010!\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\t\u00a8\u0006'"}, d2={"Lcom/src/webrtc/android/ConnectParameters;", "", "builder", "Lcom/src/webrtc/android/ConnectParameters$Builder;", "(Lcom/src/webrtc/android/ConnectParameters$Builder;)V", "audioTracks", "", "Lcom/src/webrtc/android/LocalAudioTrack;", "getAudioTracks", "()Ljava/util/List;", "dataTracks", "Lcom/src/webrtc/android/LocalDataTrack;", "getDataTracks", "iceUrls", "", "getIceUrls", "localPeerId", "getLocalPeerId", "()Ljava/lang/String;", "maxVideoBitrate", "", "getMaxVideoBitrate", "()I", "preferredAudioCodec", "Lcom/src/webrtc/android/AudioCodec;", "getPreferredAudioCodec", "()Lcom/src/webrtc/android/AudioCodec;", "preferredVideoCodec", "Lcom/src/webrtc/android/VideoCodec;", "getPreferredVideoCodec", "()Lcom/src/webrtc/android/VideoCodec;", "roomName", "getRoomName", "startAudioBitrate", "getStartAudioBitrate", "videoTracks", "Lcom/src/webrtc/android/LocalVideoTrack;", "getVideoTracks", "Builder", "library_release"})
public final class ConnectParameters {
    @NotNull
    private final String roomName;
    @NotNull
    private final String localPeerId;
    @NotNull
    private final List<String> iceUrls;
    @NotNull
    private final AudioCodec preferredAudioCodec;
    @NotNull
    private final VideoCodec preferredVideoCodec;
    private final int maxVideoBitrate;
    private final int startAudioBitrate;
    @NotNull
    private final List<LocalAudioTrack> audioTracks;
    @NotNull
    private final List<LocalVideoTrack> videoTracks;
    @NotNull
    private final List<LocalDataTrack> dataTracks;

    @NotNull
    public final String getRoomName() {
        return this.roomName;
    }

    @NotNull
    public final String getLocalPeerId() {
        return this.localPeerId;
    }

    @NotNull
    public final List<String> getIceUrls() {
        return this.iceUrls;
    }

    @NotNull
    public final AudioCodec getPreferredAudioCodec() {
        return this.preferredAudioCodec;
    }

    @NotNull
    public final VideoCodec getPreferredVideoCodec() {
        return this.preferredVideoCodec;
    }

    public final int getMaxVideoBitrate() {
        return this.maxVideoBitrate;
    }

    public final int getStartAudioBitrate() {
        return this.startAudioBitrate;
    }

    @NotNull
    public final List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    @NotNull
    public final List<LocalVideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    @NotNull
    public final List<LocalDataTrack> getDataTracks() {
        return this.dataTracks;
    }

    private ConnectParameters(Builder builder) {
        this.roomName = builder.getRoomName();
        this.localPeerId = builder.getLocalPeerId();
        this.iceUrls = builder.getIceUrls();
        this.preferredAudioCodec = builder.getPreferredAudioCodec();
        this.preferredVideoCodec = builder.getPreferredVideoCodec();
        this.maxVideoBitrate = builder.getMaxVideoBitrate();
        this.startAudioBitrate = builder.getStartAudioBitrate();
        this.audioTracks = builder.getAudioTracks();
        this.videoTracks = builder.getVideoTracks();
        this.dataTracks = builder.getDataTracks();
    }

    public /* synthetic */ ConnectParameters(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u0006\u0010%\u001a\u00020&J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0013J\u0014\u0010#\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u0006R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u001e\u0010 \u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R*\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\"0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\f\u00a8\u0006)"}, d2={"Lcom/src/webrtc/android/ConnectParameters$Builder;", "", "roomName", "", "localPeerId", "iceUrls", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "<set-?>", "Lcom/src/webrtc/android/LocalAudioTrack;", "audioTracks", "getAudioTracks", "()Ljava/util/List;", "Lcom/src/webrtc/android/LocalDataTrack;", "dataTracks", "getDataTracks", "getIceUrls", "getLocalPeerId", "()Ljava/lang/String;", "", "maxVideoBitrate", "getMaxVideoBitrate", "()I", "Lcom/src/webrtc/android/AudioCodec;", "preferredAudioCodec", "getPreferredAudioCodec", "()Lcom/src/webrtc/android/AudioCodec;", "Lcom/src/webrtc/android/VideoCodec;", "preferredVideoCodec", "getPreferredVideoCodec", "()Lcom/src/webrtc/android/VideoCodec;", "getRoomName", "startAudioBitrate", "getStartAudioBitrate", "Lcom/src/webrtc/android/LocalVideoTrack;", "videoTracks", "getVideoTracks", "build", "Lcom/src/webrtc/android/ConnectParameters;", "bitrate", "codec", "library_release"})
    public static final class Builder {
        @NotNull
        private AudioCodec preferredAudioCodec;
        @NotNull
        private VideoCodec preferredVideoCodec;
        private int maxVideoBitrate;
        private int startAudioBitrate;
        @NotNull
        private List<LocalAudioTrack> audioTracks;
        @NotNull
        private List<LocalVideoTrack> videoTracks;
        @NotNull
        private List<LocalDataTrack> dataTracks;
        @NotNull
        private final String roomName;
        @NotNull
        private final String localPeerId;
        @NotNull
        private final List<String> iceUrls;

        @NotNull
        public final AudioCodec getPreferredAudioCodec() {
            return this.preferredAudioCodec;
        }

        @NotNull
        public final VideoCodec getPreferredVideoCodec() {
            return this.preferredVideoCodec;
        }

        public final int getMaxVideoBitrate() {
            return this.maxVideoBitrate;
        }

        public final int getStartAudioBitrate() {
            return this.startAudioBitrate;
        }

        @NotNull
        public final List<LocalAudioTrack> getAudioTracks() {
            return this.audioTracks;
        }

        @NotNull
        public final List<LocalVideoTrack> getVideoTracks() {
            return this.videoTracks;
        }

        @NotNull
        public final List<LocalDataTrack> getDataTracks() {
            return this.dataTracks;
        }

        @NotNull
        public final Builder preferredAudioCodec(@NotNull AudioCodec codec) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)codec), (String)"codec");
            this.preferredAudioCodec = codec;
            return this;
        }

        @NotNull
        public final Builder preferredVideoCodec(@NotNull VideoCodec codec) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)codec), (String)"codec");
            this.preferredVideoCodec = codec;
            return this;
        }

        @NotNull
        public final Builder startAudioBitrate(int bitrate) {
            this.startAudioBitrate = bitrate;
            return this;
        }

        @NotNull
        public final Builder maxVideoBitrate(int bitrate) {
            this.maxVideoBitrate = bitrate;
            return this;
        }

        @NotNull
        public final Builder audioTracks(@NotNull List<LocalAudioTrack> audioTracks) {
            Intrinsics.checkParameterIsNotNull(audioTracks, (String)"audioTracks");
            this.audioTracks = audioTracks;
            return this;
        }

        @NotNull
        public final Builder videoTracks(@NotNull List<LocalVideoTrack> videoTracks) {
            Intrinsics.checkParameterIsNotNull(videoTracks, (String)"videoTracks");
            this.videoTracks = videoTracks;
            return this;
        }

        @NotNull
        public final Builder dataTracks(@NotNull List<LocalDataTrack> dataTracks) {
            Intrinsics.checkParameterIsNotNull(dataTracks, (String)"dataTracks");
            this.dataTracks = dataTracks;
            return this;
        }

        @NotNull
        public final ConnectParameters build() {
            Object object = this.roomName;
            boolean bl = false;
            if (object.length() == 0) {
                throw (Throwable)new IllegalArgumentException("Room name must not be null or empty.");
            }
            object = this.localPeerId;
            bl = false;
            if (object.length() == 0) {
                throw (Throwable)new IllegalArgumentException("The id of local peer is invalid.");
            }
            object = this.iceUrls;
            bl = false;
            boolean bl2 = false;
            if (object == null || object.isEmpty()) {
                throw (Throwable)new IllegalArgumentException("Ice must not be empty.");
            }
            return new ConnectParameters(this, null);
        }

        @NotNull
        public final String getRoomName() {
            return this.roomName;
        }

        @NotNull
        public final String getLocalPeerId() {
            return this.localPeerId;
        }

        @NotNull
        public final List<String> getIceUrls() {
            return this.iceUrls;
        }

        public Builder(@NotNull String roomName, @NotNull String localPeerId, @NotNull List<String> iceUrls) {
            Intrinsics.checkParameterIsNotNull((Object)roomName, (String)"roomName");
            Intrinsics.checkParameterIsNotNull((Object)localPeerId, (String)"localPeerId");
            Intrinsics.checkParameterIsNotNull(iceUrls, (String)"iceUrls");
            this.roomName = roomName;
            this.localPeerId = localPeerId;
            this.iceUrls = iceUrls;
            this.preferredAudioCodec = AudioCodec.OPUS;
            this.preferredVideoCodec = VideoCodec.VP8;
            this.audioTracks = CollectionsKt.emptyList();
            this.videoTracks = CollectionsKt.emptyList();
            this.dataTracks = CollectionsKt.emptyList();
        }
    }
}

