/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.testing;

import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001aC\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0012\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"add", "", "Ljava/nio/file/FileSystem;", "pathString", "", "contents", "charset", "Ljava/nio/charset/Charset;", "bom", "Lokio/ByteString;", "addZip", "", "Lkotlin/Pair;", "(Ljava/nio/file/FileSystem;Ljava/lang/String;[Lkotlin/Pair;)V", "exists", "", "find", "", "path", "get", "symlink", "linkPathString", "targetPathString", "wire-test-utils"})
public final class FilesKt {
    public static final void add(@NotNull FileSystem $this$add, @NotNull String pathString, @NotNull String contents, @NotNull Charset charset, @NotNull ByteString bom) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)bom, (String)"bom");
        Path path2 = path = $this$add.getPath(pathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (path2.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        byte[] byArray = bom.toByteArray();
        String string = contents;
        boolean bl = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path, ArraysKt.plus((byte[])byArray, (byte[])byArray2), new OpenOption[0]);
    }

    public static /* synthetic */ void add$default(FileSystem fileSystem, String string, String string2, Charset charset, ByteString byteString, int n, Object object) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 8) != 0) {
            byteString = ByteString.EMPTY;
        }
        FilesKt.add(fileSystem, string, string2, charset, byteString);
    }

    public static final void symlink(@NotNull FileSystem $this$symlink, @NotNull String linkPathString, @NotNull String targetPathString) {
        Path linkPath;
        Intrinsics.checkNotNullParameter((Object)$this$symlink, (String)"$this$symlink");
        Intrinsics.checkNotNullParameter((Object)linkPathString, (String)"linkPathString");
        Intrinsics.checkNotNullParameter((Object)targetPathString, (String)"targetPathString");
        Path path = linkPath = $this$symlink.getPath(linkPathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"linkPath");
        if (path.getParent() != null) {
            Files.createDirectories(linkPath.getParent(), new FileAttribute[0]);
        }
        Path targetPath = $this$symlink.getPath(targetPathString, new String[0]);
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public static final String get(@NotNull FileSystem $this$get, @NotNull String pathString) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Path path = $this$get.getPath(pathString, new String[0]);
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(path)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        return new String(byArray2, charset);
    }

    public static final boolean exists(@NotNull FileSystem $this$exists, @NotNull String pathString) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"$this$exists");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Path path = $this$exists.getPath(pathString, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    @NotNull
    public static final Set<String> find(@NotNull FileSystem $this$find, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl = false;
        Set result = new LinkedHashSet();
        Files.walkFileTree($this$find.getPath(path, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result){
            final /* synthetic */ Set $result;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this.$result.add(((Object)path).toString());
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void addZip(@NotNull FileSystem $this$addZip, @NotNull String pathString, Pair<String, String> ... contents) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$addZip, (String)"$this$addZip");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Path path2 = path = $this$addZip.getPath(pathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (path2.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Closeable closeable = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipOutputStream zipOut = (ZipOutputStream)closeable;
            boolean bl3 = false;
            BufferedSink zipSink = Okio.buffer((Sink)Okio.sink((OutputStream)zipOut));
            for (Pair<String, String> pair : contents) {
                void elementPath;
                String string = (String)pair.component1();
                String elementContents = (String)pair.component2();
                zipOut.putNextEntry(new ZipEntry((String)elementPath));
                zipSink.writeUtf8(elementContents);
                zipSink.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

