/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.kotlin.RpcCallStyle;
import com.squareup.wire.kotlin.RpcRole;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.NewSchemaLoader;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0007J.\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/squareup/wire/schema/RepoBuilder;", "", "()V", "fs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "root", "Ljava/nio/file/Path;", "schema", "Lcom/squareup/wire/schema/Schema;", "schemaLoader", "Lcom/squareup/wire/schema/NewSchemaLoader;", "add", "path", "", "name", "protoFile", "generateCode", "typeName", "profile", "generateGrpcKotlin", "serviceName", "rpcName", "rpcCallStyle", "Lcom/squareup/wire/kotlin/RpcCallStyle;", "rpcRole", "Lcom/squareup/wire/kotlin/RpcRole;", "generateKotlin", "Lcom/squareup/wire/java/Profile;", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "messageTypeName", "wire-test-utils"})
public final class RepoBuilder {
    private final FileSystem fs = Jimfs.newFileSystem((Configuration)Configuration.unix());
    private final Path root = this.fs.getPath("/source", new String[0]);
    private final NewSchemaLoader schemaLoader;
    private Schema schema;

    @NotNull
    public final RepoBuilder add(@NotNull String name, @NotNull String protoFile) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)protoFile, (String)"protoFile");
        boolean bl = StringsKt.endsWith$default((String)name, (String)".proto", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".wire", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "unexpected file extension: " + name;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path relativePath = this.fs.getPath(name, new String[0]);
        try {
            Path resolvedPath;
            Path path = resolvedPath = this.root.resolve(relativePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"resolvedPath");
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            String string = protoFile;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            Path path2 = resolvedPath;
            boolean bl5 = false;
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            Files.write(path2, byArray2, new OpenOption[0]);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RepoBuilder add(@NotNull String path) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = new File("../wire-tests/src/commonTest/proto/java/" + path);
        Closeable closeable = (Closeable)Okio.source((File)file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Source source = (Source)closeable;
            boolean bl2 = false;
            String protoFile = Okio.buffer((Source)source).readUtf8();
            RepoBuilder repoBuilder = this.add(path, protoFile);
            return repoBuilder;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Schema schema() throws IOException {
        Schema result = this.schema;
        if (result == null) {
            NewSchemaLoader.initRoots$default((NewSchemaLoader)this.schemaLoader, (List)CollectionsKt.listOf((Object)Location.Companion.get("/source")), null, (int)2, null);
            this.schema = result = this.schemaLoader.loadSchema();
        }
        return result;
    }

    @NotNull
    public final Profile profile(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.schemaLoader.loadProfile(name, this.schema());
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String messageTypeName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)messageTypeName, (String)"messageTypeName");
        return this.schema().protoAdapter(messageTypeName, true);
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName, @Nullable String profile) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema);
        if (profile != null) {
            javaGenerator = javaGenerator.withProfile(this.profile(profile));
        }
        Type type = schema.getType(typeName);
        TypeSpec typeSpec = javaGenerator.generateType(type);
        String packageName = javaGenerator.generatedTypeName(type).packageName();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        String string = javaFile.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaFile.toString()");
        return string;
    }

    public static /* synthetic */ String generateCode$default(RepoBuilder repoBuilder, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return repoBuilder.generateCode(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName) throws IOException {
        return RepoBuilder.generateCode$default(this, typeName, null, 2, null);
    }

    @NotNull
    public final String generateKotlin(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        KotlinGenerator kotlinGenerator = KotlinGenerator.Companion.get$default((KotlinGenerator.Companion)KotlinGenerator.Companion, (Schema)schema, (boolean)false, (boolean)false, null, null, (int)30, null);
        Type type = schema.getType(typeName);
        if (type == null) {
            Intrinsics.throwNpe();
        }
        Type type2 = type;
        com.squareup.kotlinpoet.TypeSpec typeSpec = kotlinGenerator.generateType(type2);
        String packageName = kotlinGenerator.generatedTypeName(type2).getPackageName();
        FileSpec fileSpec = FileSpec.Companion.builder(packageName, "_").addType(typeSpec).addImport("com.squareup.wire.kotlin", new String[]{"decodeMessage"}).build();
        return fileSpec.toString();
    }

    @NotNull
    public final String generateGrpcKotlin(@NotNull String serviceName, @Nullable String rpcName, @NotNull RpcCallStyle rpcCallStyle, @NotNull RpcRole rpcRole) {
        Rpc rpc;
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        Intrinsics.checkParameterIsNotNull((Object)rpcCallStyle, (String)"rpcCallStyle");
        Intrinsics.checkParameterIsNotNull((Object)rpcRole, (String)"rpcRole");
        Schema schema = this.schema();
        KotlinGenerator grpcGenerator = KotlinGenerator.Companion.get(schema, false, false, rpcCallStyle, rpcRole);
        Service service = schema.getService(serviceName);
        if (service == null) {
            Intrinsics.throwNpe();
        }
        Service service2 = service;
        String string = rpcName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            rpc = service2.rpc(rpcName);
            if (rpc == null) {
                Intrinsics.throwNpe();
            }
        } else {
            rpc = null;
        }
        Rpc rpc2 = rpc;
        com.squareup.kotlinpoet.TypeSpec typeSpec = grpcGenerator.generateService(service2, rpc2);
        String packageName = KotlinGenerator.generatedServiceName$default((KotlinGenerator)grpcGenerator, (Service)service2, null, (int)2, null).getPackageName();
        FileSpec fileSpec = FileSpec.Companion.builder(packageName, "_").addType(typeSpec).build();
        return fileSpec.toString();
    }

    public static /* synthetic */ String generateGrpcKotlin$default(RepoBuilder repoBuilder, String string, String string2, RpcCallStyle rpcCallStyle, RpcRole rpcRole, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            rpcCallStyle = RpcCallStyle.SUSPENDING;
        }
        if ((n & 8) != 0) {
            rpcRole = RpcRole.CLIENT;
        }
        return repoBuilder.generateGrpcKotlin(string, string2, rpcCallStyle, rpcRole);
    }

    public RepoBuilder() {
        FileSystem fileSystem = this.fs;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"fs");
        this.schemaLoader = new NewSchemaLoader(fileSystem);
    }
}

