/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000e\u001a\u00020\tH\u0086\u0002R \u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/schema/SchemaProtoAdapterFactory;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "includeUnknown", "", "(Lcom/squareup/wire/schema/Schema;Z)V", "adapterMap", "", "Lcom/squareup/wire/schema/ProtoType;", "Lcom/squareup/wire/ProtoAdapter;", "getSchema", "()Lcom/squareup/wire/schema/Schema;", "get", "protoType", "EnumAdapter", "Field", "MessageAdapter", "wire-schema"})
public final class SchemaProtoAdapterFactory {
    private final Map<ProtoType, ProtoAdapter<?>> adapterMap;
    @NotNull
    private final Schema schema;
    private final boolean includeUnknown;

    @NotNull
    public final ProtoAdapter<Object> get(@NotNull ProtoType protoType) {
        Intrinsics.checkParameterIsNotNull((Object)protoType, (String)"protoType");
        if (protoType.isMap()) {
            throw (Throwable)new UnsupportedOperationException("map types not supported");
        }
        ProtoAdapter<?> result = this.adapterMap.get(protoType);
        if (result != null) {
            return result;
        }
        Type type = this.schema.getType(protoType);
        boolean bl = false;
        boolean bl2 = false;
        if (type == null) {
            boolean bl3 = false;
            String string = "unknown type: " + protoType;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Type type2 = type;
        if (type2 instanceof EnumType) {
            EnumAdapter enumAdapter = new EnumAdapter((EnumType)type2);
            this.adapterMap.put(protoType, enumAdapter);
            return enumAdapter;
        }
        if (type2 instanceof MessageType) {
            MessageAdapter messageAdapter = new MessageAdapter(this.includeUnknown);
            this.adapterMap.put(protoType, messageAdapter);
            for (com.squareup.wire.schema.Field field : ((MessageType)type2).fields()) {
                String string = field.getName();
                int n = field.getTag();
                boolean bl4 = field.isRepeated();
                ProtoType protoType2 = field.getType();
                if (protoType2 == null) {
                    Intrinsics.throwNpe();
                }
                Field fieldAdapter = new Field(string, n, bl4, this.get(protoType2));
                messageAdapter.fieldsByName.put(field.getName(), fieldAdapter);
                messageAdapter.fieldsByTag.put(field.getTag(), fieldAdapter);
            }
            return messageAdapter;
        }
        throw (Throwable)new IllegalArgumentException("unexpected type: " + protoType);
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    public SchemaProtoAdapterFactory(@NotNull Schema schema, boolean includeUnknown) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.schema = schema;
        this.includeUnknown = includeUnknown;
        this.adapterMap = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)ProtoType.BOOL, (Object)ProtoAdapter.BOOL), TuplesKt.to((Object)ProtoType.BYTES, (Object)ProtoAdapter.BYTES), TuplesKt.to((Object)ProtoType.DOUBLE, (Object)ProtoAdapter.DOUBLE), TuplesKt.to((Object)ProtoType.FLOAT, (Object)ProtoAdapter.FLOAT), TuplesKt.to((Object)ProtoType.FIXED32, (Object)ProtoAdapter.FIXED32), TuplesKt.to((Object)ProtoType.FIXED64, (Object)ProtoAdapter.FIXED64), TuplesKt.to((Object)ProtoType.INT32, (Object)ProtoAdapter.INT32), TuplesKt.to((Object)ProtoType.INT64, (Object)ProtoAdapter.INT64), TuplesKt.to((Object)ProtoType.SFIXED32, (Object)ProtoAdapter.SFIXED32), TuplesKt.to((Object)ProtoType.SFIXED64, (Object)ProtoAdapter.SFIXED64), TuplesKt.to((Object)ProtoType.SINT32, (Object)ProtoAdapter.SINT32), TuplesKt.to((Object)ProtoType.SINT64, (Object)ProtoAdapter.SINT64), TuplesKt.to((Object)ProtoType.STRING, (Object)ProtoAdapter.STRING), TuplesKt.to((Object)ProtoType.UINT32, (Object)ProtoAdapter.UINT32), TuplesKt.to((Object)ProtoType.UINT64, (Object)ProtoAdapter.UINT64)});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/schema/SchemaProtoAdapterFactory$EnumAdapter;", "Lcom/squareup/wire/ProtoAdapter;", "", "enumType", "Lcom/squareup/wire/schema/EnumType;", "(Lcom/squareup/wire/schema/EnumType;)V", "decode", "reader", "Lcom/squareup/wire/ProtoReader;", "encode", "", "writer", "Lcom/squareup/wire/ProtoWriter;", "value", "encodedSize", "", "redact", "wire-schema"})
    public static final class EnumAdapter
    extends ProtoAdapter<Object> {
        private final EnumType enumType;

        public int encodedSize(@NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException();
        }

        public void encode(@NotNull ProtoWriter writer, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (value instanceof String) {
                EnumConstant constant;
                EnumConstant enumConstant = constant = this.enumType.constant((String)value);
                if (enumConstant == null) {
                    Intrinsics.throwNpe();
                }
                writer.writeVarint32(enumConstant.getTag());
            } else if (value instanceof Integer) {
                writer.writeVarint32(((Number)value).intValue());
            } else {
                throw (Throwable)new IllegalArgumentException("unexpected " + this.enumType.getType() + ": " + value);
            }
        }

        @NotNull
        public Object decode(@NotNull ProtoReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            int value = ((Number)ProtoAdapter.UINT32.decode(reader)).intValue();
            EnumConstant constant = this.enumType.constant(value);
            Object object = constant;
            if (object == null || (object = ((EnumConstant)object).getName()) == null) {
                object = value;
            }
            return object;
        }

        @NotNull
        public Object redact(@NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException();
        }

        public EnumAdapter(@NotNull EnumType enumType) {
            Intrinsics.checkParameterIsNotNull((Object)enumType, (String)"enumType");
            super(FieldEncoding.VARINT, Reflection.getOrCreateKotlinClass(Object.class));
            this.enumType = enumType;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016J\u001c\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016J(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016J\u001c\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016R\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/squareup/wire/schema/SchemaProtoAdapterFactory$MessageAdapter;", "Lcom/squareup/wire/ProtoAdapter;", "", "", "", "includeUnknown", "", "(Z)V", "fieldsByName", "", "Lcom/squareup/wire/schema/SchemaProtoAdapterFactory$Field;", "fieldsByTag", "", "decode", "reader", "Lcom/squareup/wire/ProtoReader;", "encode", "", "writer", "Lcom/squareup/wire/ProtoWriter;", "value", "encodedSize", "redact", "toString", "wire-schema"})
    public static final class MessageAdapter
    extends ProtoAdapter<Map<String, ? extends Object>> {
        @JvmField
        @NotNull
        public final Map<Integer, Field> fieldsByTag;
        @JvmField
        @NotNull
        public final Map<String, Field> fieldsByName;
        private final boolean includeUnknown;

        @NotNull
        public Map<String, Object> redact(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            throw (Throwable)new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        public int encodedSize(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            int size = 0;
            Object object = value;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                ProtoAdapter<?> protoAdapter;
                Field field;
                void key;
                Map.Entry<String, ? extends Object> entry;
                Map.Entry<String, ? extends Object> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Object value1 = entry2.getValue();
                if (this.fieldsByName.get(key) == null) {
                    continue;
                }
                if (field.getProtoAdapter() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.squareup.wire.ProtoAdapter<kotlin.Any>");
                }
                if (field.getRepeated()) {
                    Object object2 = value1;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                    }
                    for (Object o : (List)object2) {
                        size += protoAdapter.encodedSizeWithTag(field.getTag(), o);
                    }
                    continue;
                }
                size += protoAdapter.encodedSizeWithTag(field.getTag(), value1);
            }
            return size;
        }

        /*
         * WARNING - void declaration
         */
        public void encode(@NotNull ProtoWriter writer, @NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Object object = value;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                ProtoAdapter<?> protoAdapter;
                Field field;
                void key;
                Map.Entry<String, ? extends Object> entry;
                Map.Entry<String, ? extends Object> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Object value1 = entry2.getValue();
                if (this.fieldsByName.get(key) == null) {
                    continue;
                }
                if (field.getProtoAdapter() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.squareup.wire.ProtoAdapter<kotlin.Any>");
                }
                if (field.getRepeated()) {
                    Object object2 = value1;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                    }
                    for (Object o : (List)object2) {
                        protoAdapter.encodeWithTag(writer, field.getTag(), o);
                    }
                    continue;
                }
                protoAdapter.encodeWithTag(writer, field.getTag(), value1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Map<String, Object> decode(@NotNull ProtoReader reader) {
            int tag;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            boolean bl = false;
            Map result = new LinkedHashMap();
            long token = reader.beginMessage();
            while ((tag = reader.nextTag()) != -1) {
                Object value;
                Field field = this.fieldsByTag.get(tag);
                if (field == null) {
                    FieldEncoding fieldEncoding;
                    String name;
                    if (this.includeUnknown) {
                        name = String.valueOf(tag);
                        fieldEncoding = reader.peekFieldEncoding();
                        if (fieldEncoding == null) {
                            Intrinsics.throwNpe();
                        }
                    } else {
                        reader.skip();
                        continue;
                    }
                    field = new Field(name, tag, true, fieldEncoding.rawProtoAdapter());
                }
                if (field.getProtoAdapter().decode(reader) == null) {
                    Intrinsics.throwNpe();
                }
                if (field.getRepeated()) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map = result;
                    String key$iv = field.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    List values = TypeIntrinsics.asMutableList(object);
                    values.add(value);
                    continue;
                }
                result.put(field.getName(), value);
            }
            reader.endMessageAndGetUnknownFields(token);
            return result;
        }

        @NotNull
        public String toString(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            throw (Throwable)new UnsupportedOperationException();
        }

        public MessageAdapter(boolean includeUnknown) {
            super(FieldEncoding.LENGTH_DELIMITED, Reflection.getOrCreateKotlinClass(Map.class));
            Map map;
            this.includeUnknown = includeUnknown;
            MessageAdapter messageAdapter = this;
            boolean bl = false;
            messageAdapter.fieldsByTag = map = (Map)new LinkedHashMap();
            messageAdapter = this;
            bl = false;
            messageAdapter.fieldsByName = map = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/schema/SchemaProtoAdapterFactory$Field;", "", "name", "", "tag", "", "repeated", "", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "(Ljava/lang/String;IZLcom/squareup/wire/ProtoAdapter;)V", "getName", "()Ljava/lang/String;", "getProtoAdapter", "()Lcom/squareup/wire/ProtoAdapter;", "getRepeated", "()Z", "getTag", "()I", "wire-schema"})
    public static final class Field {
        @NotNull
        private final String name;
        private final int tag;
        private final boolean repeated;
        @NotNull
        private final ProtoAdapter<?> protoAdapter;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getTag() {
            return this.tag;
        }

        public final boolean getRepeated() {
            return this.repeated;
        }

        @NotNull
        public final ProtoAdapter<?> getProtoAdapter() {
            return this.protoAdapter;
        }

        public Field(@NotNull String name, int tag, boolean repeated, @NotNull ProtoAdapter<?> protoAdapter) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(protoAdapter, (String)"protoAdapter");
            this.name = name;
            this.tag = tag;
            this.repeated = repeated;
            this.protoAdapter = protoAdapter;
        }
    }
}

