/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0006\u0010\u001c\u001a\u00020\u0015J\u0016\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u0015J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/squareup/wire/schema/FileLinker;", "", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "linker", "Lcom/squareup/wire/schema/Linker;", "(Lcom/squareup/wire/schema/ProtoFile;Lcom/squareup/wire/schema/Linker;)V", "effectiveImports", "", "", "extensionsLinked", "", "fileOptionsLinked", "importedExtensionsRegistered", "getProtoFile", "()Lcom/squareup/wire/schema/ProtoFile;", "typesRegistered", "typesWithMembersLinked", "", "Lcom/squareup/wire/schema/ProtoType;", "addImportsRecursive", "", "sink", "paths", "", "addTypes", "type", "Lcom/squareup/wire/schema/Type;", "linkMembers", "linkMembersRecursive", "types", "", "linkOptions", "requireExtensionsLinked", "requireFileOptionsLinked", "requireImportedExtensionsRegistered", "requireMembersLinked", "requireTypesRegistered", "validate", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "wire-schema"})
public final class FileLinker {
    private Set<String> effectiveImports;
    private boolean typesRegistered;
    private boolean extensionsLinked;
    private boolean importedExtensionsRegistered;
    private boolean fileOptionsLinked;
    private final Set<ProtoType> typesWithMembersLinked;
    @NotNull
    private final ProtoFile protoFile;
    private final Linker linker;

    @NotNull
    public final Set<String> effectiveImports() {
        if (this.effectiveImports == null) {
            Set sink = new LinkedHashSet();
            this.addImportsRecursive(sink, (Collection<String>)this.protoFile.getImports());
            this.addImportsRecursive(sink, (Collection<String>)this.protoFile.getPublicImports());
            this.effectiveImports = new LinkedHashSet(sink);
        }
        Set<String> set = this.effectiveImports;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        return set;
    }

    private final void addImportsRecursive(Set<String> sink, Collection<String> paths) {
        for (String path : paths) {
            if (!sink.add(path)) continue;
            FileLinker fileLinker = this.linker.getFileLinker$wire_schema(path);
            this.addImportsRecursive(sink, (Collection<String>)fileLinker.protoFile.getPublicImports());
        }
    }

    public final void requireTypesRegistered() {
        if (this.typesRegistered) {
            return;
        }
        this.typesRegistered = true;
        for (Type type : this.protoFile.getTypes()) {
            this.addTypes(type);
        }
    }

    private final void addTypes(Type type) {
        this.linker.addType(type.getType(), type);
        for (Type nestedType : type.getNestedTypes()) {
            this.addTypes(nestedType);
        }
    }

    public final void requireExtensionsLinked() {
        if (this.extensionsLinked) {
            return;
        }
        this.extensionsLinked = true;
        this.requireTypesRegistered();
        for (Extend extend : this.protoFile.getExtendList()) {
            extend.link(this.linker);
        }
    }

    public final void requireImportedExtensionsRegistered() {
        if (this.importedExtensionsRegistered) {
            return;
        }
        this.importedExtensionsRegistered = true;
        for (FileLinker importedFileLinker : this.linker.contextImportedTypes$wire_schema()) {
            importedFileLinker.requireExtensionsLinked();
        }
    }

    public final void linkMembers() {
        this.linkMembersRecursive(this.protoFile.getTypes());
        for (Service service : this.protoFile.getServices()) {
            service.link(this.linker);
        }
    }

    private final void linkMembersRecursive(List<? extends Type> types) {
        for (Type type : types) {
            this.requireMembersLinked(type);
            this.linkMembersRecursive(type.getNestedTypes());
        }
    }

    public final void requireMembersLinked(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (this.typesWithMembersLinked.add(type.getType())) {
            type.linkMembers(this.linker);
        }
    }

    public final void linkOptions() {
        this.requireFileOptionsLinked();
        for (Type type : this.protoFile.getTypes()) {
            type.linkOptions(this.linker);
        }
        for (Service service : this.protoFile.getServices()) {
            service.linkOptions(this.linker);
        }
    }

    public final void requireFileOptionsLinked() {
        if (this.fileOptionsLinked) {
            return;
        }
        this.fileOptionsLinked = true;
        this.protoFile.linkOptions(this.linker);
    }

    public final void validate(@NotNull SyntaxRules syntaxRules) {
        Intrinsics.checkParameterIsNotNull((Object)syntaxRules, (String)"syntaxRules");
        this.protoFile.validate(this.linker);
        for (Type type : this.protoFile.getTypes()) {
            type.validate(this.linker, syntaxRules);
        }
        for (Service service : this.protoFile.getServices()) {
            service.validate(this.linker);
        }
        for (Extend extend : this.protoFile.getExtendList()) {
            extend.validate(this.linker, syntaxRules);
        }
    }

    @NotNull
    public final ProtoFile getProtoFile() {
        return this.protoFile;
    }

    public FileLinker(@NotNull ProtoFile protoFile, @NotNull Linker linker) {
        Intrinsics.checkParameterIsNotNull((Object)protoFile, (String)"protoFile");
        Intrinsics.checkParameterIsNotNull((Object)linker, (String)"linker");
        this.protoFile = protoFile;
        this.linker = linker;
        this.typesWithMembersLinked = new LinkedHashSet();
    }
}

