/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.squareup.wire.schema.Location;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0086\bJ\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u0012J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020\u0012J\u0006\u0010$\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\fH\u0002J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0012J\u001e\u0010+\u001a\u00060,j\u0002`-2\u0006\u0010\u0010\u001a\u00020\u00122\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "", "data", "", "location", "Lcom/squareup/wire/schema/Location;", "([CLcom/squareup/wire/schema/Location;)V", "line", "", "lineStart", "pos", "exhausted", "", "expect", "", "condition", "message", "Lkotlin/Function0;", "", "hexDigit", "c", "", "newline", "peekChar", "pushBack", "readChar", "readComment", "readDataType", "name", "readDocumentation", "readInt", "readName", "readNumericEscape", "radix", "len", "readQuotedString", "readString", "readWord", "require", "skipWhitespace", "skipComments", "tryAppendTrailingDocumentation", "documentation", "unexpected", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "wire-schema"})
public final class SyntaxReader {
    private int pos;
    private int line;
    private int lineStart;
    private final char[] data;
    private final Location location;

    public final boolean exhausted() {
        return this.pos == this.data.length;
    }

    public final char readChar() {
        char c = this.peekChar();
        boolean bl = false;
        boolean bl2 = false;
        char it = c;
        boolean bl3 = false;
        int n = this.pos;
        this.pos = n + 1;
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public final void require(char c) {
        void this_$iv;
        SyntaxReader syntaxReader = this;
        boolean condition$iv = this.readChar() == c;
        Location location$iv = this_$iv.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            void var8_6 = this_$iv;
            boolean bl = false;
            String string = "expected '" + c + '\'';
            throw (Throwable)var8_6.unexpected(string, location$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final char peekChar() {
        void this_$iv;
        this.skipWhitespace(true);
        SyntaxReader syntaxReader = this;
        boolean condition$iv = this.pos < this.data.length;
        Location location$iv = this_$iv.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            void var6_5 = this_$iv;
            boolean bl = false;
            String string = "unexpected end of file";
            throw (Throwable)var6_5.unexpected(string, location$iv);
        }
        return this.data[this.pos];
    }

    public final boolean peekChar(char c) {
        boolean bl;
        char c2 = this.peekChar();
        if (c2 == c) {
            int n = this.pos;
            this.pos = n + 1;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void pushBack(char c) {
        int n = this.data[this.pos - 1] == c ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.pos;
        this.pos = n + -1;
    }

    @NotNull
    public final String readString() {
        String string;
        this.skipWhitespace(true);
        switch (this.peekChar()) {
            case '\"': 
            case '\'': {
                string = this.readQuotedString();
                break;
            }
            default: {
                string = this.readWord();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readQuotedString() {
        char startQuote = this.readChar();
        boolean bl = startQuote == '\"' || startQuote == '\'';
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            n = this.pos;
            this.pos = n + 1;
            char c = this.data[n];
            if (c == startQuote) {
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    startQuote = this.readChar();
                    continue;
                }
                String string = result.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
                return string;
            }
            if (c == '\\') {
                void this_$iv;
                SyntaxReader syntaxReader = this;
                boolean condition$iv = this.pos < this.data.length;
                Location location$iv = this_$iv.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    void var9_12 = this_$iv;
                    boolean bl4 = false;
                    String string = "unexpected end of file";
                    throw (Throwable)var9_12.unexpected(string, location$iv);
                }
                n = this.pos;
                this.pos = n + 1;
                c = this.data[n];
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        SyntaxReader syntaxReader2 = this;
                        syntaxReader2.pos += -1;
                        int cfr_ignored_0 = syntaxReader2.pos;
                        c = this.readNumericEscape(8, 3);
                    }
                }
            }
            result.append(c);
            if (c != '\n') continue;
            this.newline();
        }
        throw (Throwable)SyntaxReader.unexpected$default(this, "unterminated string", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final char readNumericEscape(int radix, int len) {
        void this_$iv;
        int digit22;
        int value = -1;
        int n = this.pos + len;
        int n2 = this.data.length;
        boolean bl = false;
        int endPos = Math.min(n, n2);
        while (this.pos < endPos && (digit22 = this.hexDigit(this.data[this.pos])) != -1 && digit22 < radix) {
            value = value < 0 ? digit22 : value * radix + digit22;
            n2 = this.pos;
            this.pos = n2 + 1;
        }
        SyntaxReader digit22 = this;
        boolean condition$iv = value >= 0;
        Location location$iv = this_$iv.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            void var10_11 = this_$iv;
            boolean bl2 = false;
            String string = "expected a digit after \\x or \\X";
            throw (Throwable)var10_11.unexpected(string, location$iv);
        }
        return (char)value;
    }

    private final int hexDigit(char c) {
        char c2 = c;
        char c3 = c2;
        return '0' <= c3 && '9' >= c3 ? c - 48 : ('a' <= (c3 = c2) && 'f' >= c3 ? c - 97 + 10 : ('A' <= (c3 = c2) && 'F' >= c3 ? c - 65 + 10 : -1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readName() {
        String string;
        switch (this.peekChar()) {
            case '(': {
                void this_$iv;
                int n = this.pos;
                this.pos = n + 1;
                String string2 = this.readWord();
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                SyntaxReader syntaxReader = this;
                boolean condition$iv = this.readChar() == ')';
                Location location$iv = this_$iv.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    void var10_21 = this_$iv;
                    boolean bl4 = false;
                    String string3 = "expected ')'";
                    throw (Throwable)var10_21.unexpected(string3, location$iv);
                }
                string = string2;
                break;
            }
            case '[': {
                int n = this.pos;
                this.pos = n + 1;
                String string4 = this.readWord();
                boolean bl = false;
                boolean bl5 = false;
                String it = string4;
                boolean bl6 = false;
                SyntaxReader this_$iv = this;
                boolean condition$iv = this.readChar() == ']';
                Location location$iv = this_$iv.location();
                boolean $i$f$expect = false;
                if (!condition$iv) {
                    SyntaxReader syntaxReader = this_$iv;
                    boolean bl7 = false;
                    String string5 = "expected ']'";
                    throw (Throwable)syntaxReader.unexpected(string5, location$iv);
                }
                string = string4;
                break;
            }
            default: {
                string = this.readWord();
            }
        }
        return string;
    }

    @NotNull
    public final String readDataType() {
        String name = this.readWord();
        return this.readDataType(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readDataType(@NotNull String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string2 = name;
        switch (string2.hashCode()) {
            case 107868: {
                if (string2.equals("map")) {
                    void this_$iv;
                    void this_$iv2;
                    void this_$iv3;
                    SyntaxReader syntaxReader = this;
                    boolean condition$iv22 = this.readChar() == '<';
                    Location location$iv = this_$iv3.location();
                    boolean $i$f$expect = false;
                    if (!condition$iv22) {
                        void var10_13 = this_$iv3;
                        boolean bl = false;
                        String string3 = "expected '<'";
                        throw (Throwable)var10_13.unexpected(string3, location$iv);
                    }
                    String keyType = this.readDataType();
                    SyntaxReader condition$iv22 = this;
                    boolean condition$iv32 = this.readChar() == ',';
                    Location location$iv2 = this_$iv2.location();
                    boolean $i$f$expect2 = false;
                    if (!condition$iv32) {
                        void var10_14 = this_$iv2;
                        boolean bl = false;
                        String string4 = "expected ','";
                        throw (Throwable)var10_14.unexpected(string4, location$iv2);
                    }
                    String valueType = this.readDataType();
                    SyntaxReader condition$iv32 = this;
                    boolean condition$iv = this.readChar() == '>';
                    Location location$iv3 = this_$iv.location();
                    boolean $i$f$expect3 = false;
                    if (!condition$iv) {
                        void var10_15 = this_$iv;
                        boolean bl = false;
                        String string5 = "expected '>'";
                        throw (Throwable)var10_15.unexpected(string5, location$iv3);
                    }
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string6 = "map<%s, %s>";
                    Object[] objectArray = new Object[]{keyType, valueType};
                    boolean bl = false;
                    String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                    string = string7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
                    break;
                }
            }
            default: {
                string = name;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readWord() {
        void this_$iv;
        int n;
        int n2;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && (97 <= (n2 = (n = this.data[this.pos])) && 122 >= n2 || 65 <= (n2 = n) && 90 >= n2 || 48 <= (n2 = n) && 57 >= n2 || n == 95 || n == 45 || n == 46)) {
            n2 = this.pos;
            this.pos = n2 + 1;
        }
        Object object = this;
        boolean condition$iv = start < this.pos;
        Location location$iv = this_$iv.location();
        boolean $i$f$expect = false;
        if (!condition$iv) {
            void var7_8 = this_$iv;
            boolean bl = false;
            String string = "expected a word";
            throw (Throwable)var7_8.unexpected(string, location$iv);
        }
        object = this.data;
        n2 = this.pos - start;
        boolean bl = false;
        return new String((char[])object, start, n2);
    }

    public final int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (StringsKt.startsWith$default((String)tag, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"0X", (boolean)false, (int)2, null)) {
                String string = tag;
                int n = "0x".length();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                tag = string3;
                radix = 16;
            }
            Integer n = Integer.valueOf(tag, radix);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.valueOf(tag, radix)");
            return n;
        }
        catch (Exception _) {
            throw (Throwable)SyntaxReader.unexpected$default(this, "expected an integer but was " + tag, null, 2, null);
        }
    }

    @NotNull
    public final String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                String string = result;
                if (string == null) {
                    string = "";
                }
                return string;
            }
            String comment = this.readComment();
            String string = result;
            result = string == null ? comment : result + '\n' + comment;
        }
    }

    private final String readComment() {
        int n;
        int n2 = this.pos != this.data.length && this.data[this.pos] == '/' ? 1 : 0;
        int n3 = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n2 == 0) {
            boolean bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n2 = this.pos;
        this.pos = n2 + 1;
        if (this.pos < this.data.length) {
            n3 = this.pos;
            this.pos = n3 + 1;
            n = this.data[n3];
        } else {
            n = -1;
        }
        int commentType = n;
        switch (commentType) {
            case 42: {
                StringBuilder result = new StringBuilder();
                boolean startOfLine = true;
                while (this.pos + 1 < this.data.length) {
                    char c = this.data[this.pos];
                    if (c == '*' && this.data[this.pos + 1] == '/') {
                        this.pos += 2;
                        String string = result.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
                        String string2 = string;
                        boolean bl3 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    }
                    if (c == '\n') {
                        result.append('\n');
                        this.newline();
                        startOfLine = true;
                    } else if (!startOfLine) {
                        result.append(c);
                    } else if (c == '*') {
                        if (this.data[this.pos + 1] == ' ') {
                            // empty if block
                        }
                        startOfLine = false;
                    } else if (!Character.isWhitespace(c)) {
                        result.append(c);
                        startOfLine = false;
                    }
                    int n4 = ++this.pos;
                    this.pos = n4 + 1;
                }
                throw (Throwable)SyntaxReader.unexpected$default(this, "unterminated comment", null, 2, null);
            }
            case 47: {
                int n5;
                if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                    int result = this.pos;
                    this.pos = result + 1;
                }
                int start = this.pos;
                while (this.pos < this.data.length) {
                    n5 = this.pos;
                    this.pos = n5 + 1;
                    char c = this.data[n5];
                    if (c != '\n') continue;
                    this.newline();
                    break;
                }
                char[] cArray = this.data;
                n5 = this.pos - 1 - start;
                boolean bl4 = false;
                return new String(cArray, start, n5);
            }
        }
        throw (Throwable)SyntaxReader.unexpected$default(this, "unexpected '/'", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String tryAppendTrailingDocumentation(@NotNull String documentation) {
        int end;
        int start;
        block19: {
            void this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)documentation, (String)"documentation");
            block4: while (this.pos < this.data.length) {
                switch (this.data[this.pos]) {
                    case '\t': 
                    case ' ': {
                        int n = this.pos;
                        this.pos = n + 1;
                        break;
                    }
                    case '/': {
                        int n = this.pos;
                        this.pos = n + 1;
                        break block4;
                    }
                    default: {
                        return documentation;
                    }
                }
            }
            SyntaxReader syntaxReader = this;
            int condition$iv = this.pos < this.data.length && (this.data[this.pos] == '/' || this.data[this.pos] == '*') ? 1 : 0;
            Location location$iv = this_$iv.location();
            boolean $i$f$expect2 = false;
            if (condition$iv == 0) {
                void var11_12 = this_$iv;
                boolean bl = false;
                int n = this.pos;
                this.pos = n + -1;
                String string = "expected '//' or '/*'";
                throw (Throwable)var11_12.unexpected(string, location$iv);
            }
            boolean isStar = this.data[this.pos] == '*';
            condition$iv = this.pos;
            this.pos = condition$iv + 1;
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                condition$iv = this.pos;
                this.pos = condition$iv + 1;
            }
            start = this.pos;
            end = 0;
            if (isStar) {
                int condition$iv22;
                while (true) {
                    void this_$iv22;
                    SyntaxReader $i$f$expect2 = this;
                    condition$iv22 = this.pos < this.data.length ? 1 : 0;
                    Location location$iv2 = this_$iv22.location();
                    boolean $i$f$expect3 = false;
                    if (condition$iv22 == 0) {
                        void var11_13 = this_$iv22;
                        boolean bl = false;
                        String string = "trailing comment must be closed";
                        throw (Throwable)var11_13.unexpected(string, location$iv2);
                    }
                    if (this.data[this.pos] == '*' && this.pos + 1 < this.data.length && this.data[this.pos + 1] == '/') {
                        end = this.pos - 1;
                        this.pos += 2;
                        break;
                    }
                    int this_$iv22 = this.pos;
                    this.pos = this_$iv22 + 1;
                }
                while (this.pos < this.data.length) {
                    void this_$iv2;
                    condition$iv22 = this.pos;
                    this.pos = condition$iv22 + 1;
                    char c = this.data[condition$iv22];
                    if (c == '\n') {
                        this.newline();
                        break;
                    }
                    SyntaxReader condition$iv22 = this;
                    boolean condition$iv3 = c == ' ' || c == '\t';
                    Location location$iv3 = this_$iv2.location();
                    boolean $i$f$expect4 = false;
                    if (condition$iv3) continue;
                    void var11_14 = this_$iv2;
                    boolean bl = false;
                    String string = "no syntax may follow trailing comment";
                    throw (Throwable)var11_14.unexpected(string, location$iv3);
                }
            } else {
                int n;
                char c;
                do {
                    if (this.pos == this.data.length) {
                        end = this.pos - 1;
                        break block19;
                    }
                    n = this.pos;
                    this.pos = n + 1;
                } while ((c = this.data[n]) != '\n');
                this.newline();
                end = this.pos - 2;
            }
        }
        while (end > start && (this.data[end] == ' ' || this.data[end] == '\t')) {
            --end;
        }
        if (end == start) {
            return documentation;
        }
        Object object = this.data;
        int n = end - start + 1;
        boolean bl = false;
        String trailingDocumentation = new String((char[])object, start, n);
        object = documentation;
        n = 0;
        if (object.length() == 0) {
            return trailingDocumentation;
        }
        return documentation + '\n' + trailingDocumentation;
    }

    private final void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                int n = this.pos;
                this.pos = n + 1;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (skipComments && c == '/') {
                this.readComment();
                continue;
            }
            return;
        }
    }

    private final void newline() {
        int n = this.line;
        this.line = n + 1;
        this.lineStart = this.pos;
    }

    @NotNull
    public final Location location() {
        return this.location.at(this.line + 1, this.pos - this.lineStart + 1);
    }

    public final void expect(boolean condition, @NotNull Location location, @NotNull Function0<String> message) {
        int $i$f$expect = 0;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (!condition) {
            throw (Throwable)this.unexpected((String)message.invoke(), location);
        }
    }

    public static /* synthetic */ void expect$default(SyntaxReader this_, boolean condition, Location location, Function0 message, int n, Object object) {
        if ((n & 2) != 0) {
            location = this_.location();
        }
        boolean $i$f$expect = false;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (!condition) {
            throw (Throwable)this_.unexpected((String)message.invoke(), location);
        }
    }

    @NotNull
    public final RuntimeException unexpected(@NotNull String message, @Nullable Location location) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        throw (Throwable)new IllegalStateException("Syntax error in " + location + ": " + message);
    }

    public static /* synthetic */ RuntimeException unexpected$default(SyntaxReader syntaxReader, String string, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            location = syntaxReader.location();
        }
        return syntaxReader.unexpected(string, location);
    }

    public SyntaxReader(@NotNull char[] data, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.data = data;
        this.location = location;
    }
}

