

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GroupElement extends GroupElement {

  private final Field.Label label;

  private final Location location;

  private final String name;

  private final int tag;

  private final String documentation;

  private final ImmutableList<FieldElement> fields;

  private AutoValue_GroupElement(
      @Nullable Field.Label label,
      Location location,
      String name,
      int tag,
      String documentation,
      ImmutableList<FieldElement> fields) {
    this.label = label;
    this.location = location;
    this.name = name;
    this.tag = tag;
    this.documentation = documentation;
    this.fields = fields;
  }

  @Nullable
  @Override
  public Field.Label label() {
    return label;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public int tag() {
    return tag;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<FieldElement> fields() {
    return fields;
  }

  @Override
  public String toString() {
    return "GroupElement{"
         + "label=" + label + ", "
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "tag=" + tag + ", "
         + "documentation=" + documentation + ", "
         + "fields=" + fields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GroupElement) {
      GroupElement that = (GroupElement) o;
      return ((this.label == null) ? (that.label() == null) : this.label.equals(that.label()))
           && (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.tag == that.tag())
           && (this.documentation.equals(that.documentation()))
           && (this.fields.equals(that.fields()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (label == null) ? 0 : label.hashCode();
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= tag;
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    return h$;
  }

  static final class Builder implements GroupElement.Builder {
    private Field.Label label;
    private Location location;
    private String name;
    private Integer tag;
    private String documentation;
    private ImmutableList<FieldElement> fields;
    Builder() {
    }
    @Override
    public GroupElement.Builder label(Field.Label label) {
      this.label = label;
      return this;
    }
    @Override
    public GroupElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public GroupElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public GroupElement.Builder tag(int tag) {
      this.tag = tag;
      return this;
    }
    @Override
    public GroupElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public GroupElement.Builder fields(ImmutableList<FieldElement> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public GroupElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.tag == null) {
        missing += " tag";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GroupElement(
          this.label,
          this.location,
          this.name,
          this.tag,
          this.documentation,
          this.fields);
    }
  }

}
