

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FieldElement extends FieldElement {

  private final Location location;

  private final Field.Label label;

  private final String type;

  private final String name;

  private final String defaultValue;

  private final int tag;

  private final String documentation;

  private final ImmutableList<OptionElement> options;

  private AutoValue_FieldElement(
      Location location,
      @Nullable Field.Label label,
      String type,
      String name,
      @Nullable String defaultValue,
      int tag,
      String documentation,
      ImmutableList<OptionElement> options) {
    this.location = location;
    this.label = label;
    this.type = type;
    this.name = name;
    this.defaultValue = defaultValue;
    this.tag = tag;
    this.documentation = documentation;
    this.options = options;
  }

  @Override
  public Location location() {
    return location;
  }

  @Nullable
  @Override
  public Field.Label label() {
    return label;
  }

  @Override
  public String type() {
    return type;
  }

  @Override
  public String name() {
    return name;
  }

  @Nullable
  @Override
  public String defaultValue() {
    return defaultValue;
  }

  @Override
  public int tag() {
    return tag;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public String toString() {
    return "FieldElement{"
         + "location=" + location + ", "
         + "label=" + label + ", "
         + "type=" + type + ", "
         + "name=" + name + ", "
         + "defaultValue=" + defaultValue + ", "
         + "tag=" + tag + ", "
         + "documentation=" + documentation + ", "
         + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FieldElement) {
      FieldElement that = (FieldElement) o;
      return (this.location.equals(that.location()))
           && ((this.label == null) ? (that.label() == null) : this.label.equals(that.label()))
           && (this.type.equals(that.type()))
           && (this.name.equals(that.name()))
           && ((this.defaultValue == null) ? (that.defaultValue() == null) : this.defaultValue.equals(that.defaultValue()))
           && (this.tag == that.tag())
           && (this.documentation.equals(that.documentation()))
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= (label == null) ? 0 : label.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
    h$ *= 1000003;
    h$ ^= tag;
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements FieldElement.Builder {
    private Location location;
    private Field.Label label;
    private String type;
    private String name;
    private String defaultValue;
    private Integer tag;
    private String documentation;
    private ImmutableList<OptionElement> options;
    Builder() {
    }
    @Override
    public FieldElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public FieldElement.Builder label(@Nullable Field.Label label) {
      this.label = label;
      return this;
    }
    @Override
    public FieldElement.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public FieldElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public FieldElement.Builder defaultValue(@Nullable String defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }
    @Override
    public FieldElement.Builder tag(int tag) {
      this.tag = tag;
      return this;
    }
    @Override
    public FieldElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public FieldElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public FieldElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.tag == null) {
        missing += " tag";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FieldElement(
          this.location,
          this.label,
          this.type,
          this.name,
          this.defaultValue,
          this.tag,
          this.documentation,
          this.options);
    }
  }

}
