/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_OneOfElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;

public abstract class OneOfElement {
    public static Builder builder() {
        return new AutoValue_OneOfElement.Builder().documentation("").fields((ImmutableList<FieldElement>)ImmutableList.of()).groups((ImmutableList<GroupElement>)ImmutableList.of());
    }

    public abstract String name();

    public abstract String documentation();

    public abstract ImmutableList<FieldElement> fields();

    public abstract ImmutableList<GroupElement> groups();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("oneof ").append(this.name()).append(" {");
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Util.appendIndented(builder, field.toSchema());
            }
        }
        if (!this.groups().isEmpty()) {
            builder.append('\n');
            for (GroupElement group : this.groups()) {
                Util.appendIndented(builder, group.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder fields(ImmutableList<FieldElement> var1);

        public Builder groups(ImmutableList<GroupElement> var1);

        public OneOfElement build();
    }
}

