/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import java.util.List;

public final class Service {
    private final ProtoType protoType;
    private final Location location;
    private final String name;
    private final String documentation;
    private final ImmutableList<Rpc> rpcs;
    private final Options options;

    private Service(ProtoType protoType, Location location, String documentation, String name, ImmutableList<Rpc> rpcs, Options options) {
        this.protoType = protoType;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.rpcs = rpcs;
        this.options = options;
    }

    static Service fromElement(ProtoType protoType, ServiceElement element) {
        ImmutableList<Rpc> rpcs = Rpc.fromElements(element.rpcs());
        Options options = new Options(Options.SERVICE_OPTIONS, (List<OptionElement>)element.options());
        return new Service(protoType, element.location(), element.documentation(), element.name(), rpcs, options);
    }

    public Location location() {
        return this.location;
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.documentation;
    }

    public String name() {
        return this.name;
    }

    public ImmutableList<Rpc> rpcs() {
        return this.rpcs;
    }

    public Rpc rpc(String name) {
        for (Rpc rpc : this.rpcs) {
            if (!rpc.name().equals(name)) continue;
            return rpc;
        }
        return null;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.linkOptions(linker);
        }
        this.options.link(linker);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.validate(linker);
        }
    }

    Service retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.protoType)) {
            return null;
        }
        ImmutableList.Builder retainedRpcs = ImmutableList.builder();
        for (Rpc rpc : this.rpcs) {
            Rpc retainedRpc = rpc.retainAll(schema, markSet);
            if (retainedRpc == null || !markSet.contains(ProtoMember.get(this.protoType, rpc.name()))) continue;
            retainedRpcs.add((Object)retainedRpc);
        }
        return new Service(this.protoType, this.location, this.documentation, this.name, (ImmutableList<Rpc>)retainedRpcs.build(), this.options.retainAll(schema, markSet));
    }

    static ImmutableList<Service> fromElements(String packageName, ImmutableList<ServiceElement> elements) {
        ImmutableList.Builder services = ImmutableList.builder();
        for (ServiceElement service : elements) {
            ProtoType protoType = ProtoType.get(packageName, service.name());
            services.add((Object)Service.fromElement(protoType, service));
        }
        return services.build();
    }

    static ImmutableList<ServiceElement> toElements(ImmutableList<Service> services) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Service service : services) {
            elements.add((Object)ServiceElement.builder(service.location).documentation(service.documentation).name(service.name).rpcs(Rpc.toElements(service.rpcs)).options(service.options.toElements()).build());
        }
        return elements.build();
    }
}

