/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MessageType
extends Type {
    private final ProtoType protoType;
    private final Location location;
    private final String documentation;
    private final String name;
    private final ImmutableList<Field> declaredFields;
    private final List<Field> extensionFields;
    private final ImmutableList<OneOf> oneOfs;
    private final ImmutableList<Type> nestedTypes;
    private final ImmutableList<Extensions> extensionsList;
    private final ImmutableList<Reserved> reserveds;
    private final Options options;

    private MessageType(ProtoType protoType, Location location, String documentation, String name, ImmutableList<Field> declaredFields, List<Field> extensionFields, ImmutableList<OneOf> oneOfs, ImmutableList<Type> nestedTypes, ImmutableList<Extensions> extensionsList, ImmutableList<Reserved> reserveds, Options options) {
        this.protoType = protoType;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.declaredFields = declaredFields;
        this.extensionFields = extensionFields;
        this.oneOfs = oneOfs;
        this.nestedTypes = nestedTypes;
        this.extensionsList = extensionsList;
        this.reserveds = reserveds;
        this.options = (Options)Preconditions.checkNotNull((Object)options);
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public ProtoType type() {
        return this.protoType;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public Options options() {
        return this.options;
    }

    public ImmutableList<Field> fields() {
        return ImmutableList.builder().addAll(this.declaredFields).addAll(this.extensionFields).build();
    }

    public ImmutableList<Field> extensionFields() {
        return ImmutableList.copyOf(this.extensionFields);
    }

    public ImmutableList<Field> getRequiredFields() {
        ImmutableList.Builder required = ImmutableList.builder();
        for (Field field : this.fieldsAndOneOfFields()) {
            if (!field.isRequired()) continue;
            required.add((Object)field);
        }
        return required.build();
    }

    public ImmutableList<Field> fieldsAndOneOfFields() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.declaredFields);
        result.addAll(this.extensionFields);
        for (OneOf oneOf : this.oneOfs) {
            result.addAll(oneOf.fields());
        }
        return result.build();
    }

    public Field field(String name) {
        for (Field field : this.declaredFields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        for (OneOf oneOf : this.oneOfs) {
            for (Field field : oneOf.fields()) {
                if (!field.name().equals(name)) continue;
                return field;
            }
        }
        return null;
    }

    public Field extensionField(String qualifiedName) {
        for (Field field : this.extensionFields) {
            if (!field.qualifiedName().equals(qualifiedName)) continue;
            return field;
        }
        return null;
    }

    public Field field(int tag) {
        for (Field field : this.declaredFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        for (Field field : this.extensionFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        return null;
    }

    public ImmutableList<OneOf> oneOfs() {
        return this.oneOfs;
    }

    public ImmutableList<Extensions> extensions() {
        return this.extensionsList;
    }

    Map<String, Field> extensionFieldsMap() {
        LinkedHashMap<String, Field> extensionsForType = new LinkedHashMap<String, Field>();
        for (Field field : this.extensionFields) {
            extensionsForType.put(field.qualifiedName(), field);
        }
        return extensionsForType;
    }

    void addExtensionFields(ImmutableList<Field> fields) {
        this.extensionFields.addAll((Collection<Field>)fields);
    }

    @Override
    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Field field : this.declaredFields) {
            field.link(linker);
        }
        for (Field field : this.extensionFields) {
            field.link(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.link(linker);
        }
        for (Type type : this.nestedTypes) {
            type.link(linker);
        }
    }

    @Override
    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Type type : this.nestedTypes) {
            type.linkOptions(linker);
        }
        for (Field field : this.declaredFields) {
            field.linkOptions(linker);
        }
        for (Field field : this.extensionFields) {
            field.linkOptions(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.linkOptions(linker);
        }
        this.options.link(linker);
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateFields((Iterable<Field>)this.fieldsAndOneOfFields(), this.reserveds);
        linker.validateEnumConstantNameUniqueness((Iterable<Type>)this.nestedTypes);
        for (Field field : this.fieldsAndOneOfFields()) {
            field.validate(linker);
        }
        for (Type type : this.nestedTypes) {
            type.validate(linker);
        }
        for (Extensions extensions : this.extensionsList) {
            extensions.validate(linker);
        }
    }

    @Override
    Type retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedNestedTypesBuilder = ImmutableList.builder();
        for (Type nestedType : this.nestedTypes) {
            Type retainedNestedType = nestedType.retainAll(schema, markSet);
            if (retainedNestedType == null) continue;
            retainedNestedTypesBuilder.add((Object)retainedNestedType);
        }
        ImmutableList retainedNestedTypes = retainedNestedTypesBuilder.build();
        if (!markSet.contains(this.protoType)) {
            if (retainedNestedTypes.isEmpty()) {
                return null;
            }
            return new EnclosingType(this.location, this.protoType, this.documentation, (ImmutableList<Type>)retainedNestedTypes);
        }
        ImmutableList.Builder retainedOneOfsBuilder = ImmutableList.builder();
        for (OneOf oneOf : this.oneOfs) {
            OneOf retainedOneOf = oneOf.retainAll(schema, markSet, this.protoType);
            if (retainedOneOf == null) continue;
            retainedOneOfsBuilder.add((Object)retainedOneOf);
        }
        ImmutableList retainedOneOfs = retainedOneOfsBuilder.build();
        return new MessageType(this.protoType, this.location, this.documentation, this.name, Field.retainAll(schema, markSet, this.protoType, this.declaredFields), (List<Field>)Field.retainAll(schema, markSet, this.protoType, this.extensionFields), (ImmutableList<OneOf>)retainedOneOfs, (ImmutableList<Type>)retainedNestedTypes, this.extensionsList, this.reserveds, this.options.retainAll(schema, markSet));
    }

    static MessageType fromElement(String packageName, ProtoType protoType, MessageElement messageElement) {
        if (!messageElement.groups().isEmpty()) {
            throw new IllegalStateException("'group' is not supported");
        }
        ImmutableList<Field> declaredFields = Field.fromElements(packageName, messageElement.fields(), false);
        ArrayList<Field> extensionFields = new ArrayList<Field>();
        ImmutableList<OneOf> oneOfs = OneOf.fromElements(packageName, messageElement.oneOfs(), false);
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        for (TypeElement nestedType : messageElement.nestedTypes()) {
            nestedTypes.add((Object)Type.get(packageName, protoType.nestedType(nestedType.name()), nestedType));
        }
        ImmutableList<Extensions> extensionsList = Extensions.fromElements(messageElement.extensions());
        ImmutableList<Reserved> reserveds = Reserved.fromElements(messageElement.reserveds());
        Options options = new Options(Options.MESSAGE_OPTIONS, (List<OptionElement>)messageElement.options());
        return new MessageType(protoType, messageElement.location(), messageElement.documentation(), messageElement.name(), declaredFields, extensionFields, oneOfs, (ImmutableList<Type>)nestedTypes.build(), extensionsList, reserveds, options);
    }

    MessageElement toElement() {
        return MessageElement.builder(this.location).documentation(this.documentation).name(this.name).options(this.options.toElements()).fields(Field.toElements(this.declaredFields)).nestedTypes(Type.toElements(this.nestedTypes)).oneOfs(OneOf.toElements(this.oneOfs)).extensions(Extensions.toElements(this.extensionsList)).reserveds(Reserved.toElements(this.reserveds)).build();
    }
}

