/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;

final class Extensions {
    private final Location location;
    private final String documentation;
    private final int start;
    private final int end;

    private Extensions(Location location, String documentation, int start, int end) {
        this.location = location;
        this.documentation = documentation;
        this.start = start;
        this.end = end;
    }

    public Location location() {
        return this.location;
    }

    public String documentation() {
        return this.documentation;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    static ImmutableList<Extensions> fromElements(ImmutableList<ExtensionsElement> elements) {
        ImmutableList.Builder extensions = ImmutableList.builder();
        for (ExtensionsElement element : elements) {
            extensions.add((Object)new Extensions(element.location(), element.documentation(), element.start(), element.end()));
        }
        return extensions.build();
    }

    static ImmutableList<ExtensionsElement> toElements(ImmutableList<Extensions> extensions) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Extensions extension : extensions) {
            elements.add((Object)ExtensionsElement.create(extension.location, extension.start, extension.end, extension.documentation));
        }
        return elements.build();
    }

    void validate(Linker linker) {
        if (!Util.isValidTag(this.start()) || !Util.isValidTag(this.end())) {
            linker.withContext(this).addError("tags are out of range: %s to %s", this.start(), this.end());
        }
    }
}

