/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class EnumType
extends Type {
    static final ProtoMember ALLOW_ALIAS = ProtoMember.get(Options.ENUM_OPTIONS, "allow_alias");
    private final ProtoType protoType;
    private final Location location;
    private final String documentation;
    private final String name;
    private final ImmutableList<EnumConstant> constants;
    private final Options options;
    private Object allowAlias;

    private EnumType(ProtoType protoType, Location location, String documentation, String name, ImmutableList<EnumConstant> constants, Options options) {
        this.protoType = protoType;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.constants = constants;
        this.options = options;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public ProtoType type() {
        return this.protoType;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return ImmutableList.of();
    }

    public boolean allowAlias() {
        return "true".equals(this.allowAlias);
    }

    public EnumConstant constant(String name) {
        for (EnumConstant constant : this.constants()) {
            if (!constant.name().equals(name)) continue;
            return constant;
        }
        return null;
    }

    public EnumConstant constant(int tag) {
        for (EnumConstant constant : this.constants()) {
            if (constant.tag() != tag) continue;
            return constant;
        }
        return null;
    }

    public ImmutableList<EnumConstant> constants() {
        return this.constants;
    }

    @Override
    void link(Linker linker) {
    }

    @Override
    void linkOptions(Linker linker) {
        this.options.link(linker);
        for (EnumConstant constant : this.constants) {
            constant.linkOptions(linker);
        }
        this.allowAlias = this.options.get(ALLOW_ALIAS);
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        if (!"true".equals(this.allowAlias)) {
            this.validateTagUniqueness(linker);
        }
    }

    private void validateTagUniqueness(Linker linker) {
        LinkedHashMultimap tagToConstant = LinkedHashMultimap.create();
        for (EnumConstant constant : this.constants) {
            tagToConstant.put((Object)constant.tag(), (Object)constant);
        }
        for (Map.Entry entry : tagToConstant.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            error.append(String.format("multiple enum constants share tag %s:", entry.getKey()));
            int index = 1;
            for (EnumConstant constant : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s (%s)", index++, constant.name(), constant.location()));
            }
            linker.addError("%s", error);
        }
    }

    @Override
    Type retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.protoType)) {
            return null;
        }
        ImmutableList.Builder retainedConstants = ImmutableList.builder();
        for (EnumConstant constant : this.constants) {
            if (!markSet.contains(ProtoMember.get(this.protoType, constant.name()))) continue;
            retainedConstants.add((Object)constant.retainAll(schema, markSet));
        }
        EnumType result = new EnumType(this.protoType, this.location, this.documentation, this.name, (ImmutableList<EnumConstant>)retainedConstants.build(), this.options.retainAll(schema, markSet));
        result.allowAlias = this.allowAlias;
        return result;
    }

    static EnumType fromElement(ProtoType protoType, EnumElement enumElement) {
        ImmutableList<EnumConstant> constants = EnumConstant.fromElements(enumElement.constants());
        Options options = new Options(Options.ENUM_OPTIONS, (List<OptionElement>)enumElement.options());
        return new EnumType(protoType, enumElement.location(), enumElement.documentation(), enumElement.name(), constants, options);
    }

    EnumElement toElement() {
        return EnumElement.builder(this.location).name(this.name).documentation(this.documentation).constants(EnumConstant.toElements(this.constants)).options(this.options.toElements()).build();
    }
}

