/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.List;

public final class EnumConstant {
    private final Location location;
    private final String name;
    private final int tag;
    private final String documentation;
    private final Options options;

    private EnumConstant(Location location, String name, int tag, String documentation, Options options) {
        this.location = location;
        this.name = name;
        this.tag = tag;
        this.documentation = documentation;
        this.options = options;
    }

    public Location location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    public int tag() {
        return this.tag;
    }

    public String documentation() {
        return this.documentation;
    }

    public Options options() {
        return this.options;
    }

    static EnumConstant fromElement(EnumConstantElement element) {
        return new EnumConstant(element.location(), element.name(), element.tag(), element.documentation(), new Options(Options.ENUM_VALUE_OPTIONS, (List<OptionElement>)element.options()));
    }

    EnumConstantElement toElement() {
        return EnumConstantElement.builder(this.location).documentation(this.documentation).name(this.name).tag(this.tag).options(this.options.toElements()).build();
    }

    void linkOptions(Linker linker) {
        this.options.link(linker);
    }

    EnumConstant retainAll(Schema schema, MarkSet markSet) {
        return new EnumConstant(this.location, this.name, this.tag, this.documentation, this.options.retainAll(schema, markSet));
    }

    static ImmutableList<EnumConstant> fromElements(ImmutableList<EnumConstantElement> elements) {
        ImmutableList.Builder constants = ImmutableList.builder();
        for (EnumConstantElement element : elements) {
            constants.add((Object)EnumConstant.fromElement(element));
        }
        return constants.build();
    }

    static ImmutableList<EnumConstantElement> toElements(ImmutableList<EnumConstant> constants) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (EnumConstant constant : constants) {
            elements.add((Object)constant.toElement());
        }
        return elements.build();
    }
}

