/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;

public final class EnclosingType
extends Type {
    private final Location location;
    private final ProtoType type;
    private final String documentation;
    private final ImmutableList<Type> nestedTypes;

    EnclosingType(Location location, ProtoType type, String documentation, ImmutableList<Type> nestedTypes) {
        this.location = location;
        this.type = type;
        this.documentation = documentation;
        this.nestedTypes = nestedTypes;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public ProtoType type() {
        return this.type;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public Options options() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return this.nestedTypes;
    }

    @Override
    void link(Linker linker) {
        for (Type nestedType : this.nestedTypes) {
            nestedType.link(linker);
        }
    }

    @Override
    void linkOptions(Linker linker) {
        for (Type nestedType : this.nestedTypes) {
            nestedType.linkOptions(linker);
        }
    }

    @Override
    void validate(Linker linker) {
        for (Type nestedType : this.nestedTypes) {
            nestedType.validate(linker);
        }
    }

    @Override
    Type retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedNestedTypesBuilder = ImmutableList.builder();
        for (Type nestedType : this.nestedTypes) {
            Type retainedNestedType = nestedType.retainAll(schema, markSet);
            if (retainedNestedType == null) continue;
            retainedNestedTypesBuilder.add((Object)retainedNestedType);
        }
        ImmutableList retainedNestedTypes = retainedNestedTypesBuilder.build();
        if (retainedNestedTypes.isEmpty()) {
            return null;
        }
        return new EnclosingType(this.location, this.type, this.documentation, (ImmutableList<Type>)retainedNestedTypes);
    }
}

