/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.OptionElement;

final class AutoValue_EnumElement
extends EnumElement {
    private final Location location;
    private final String name;
    private final String documentation;
    private final ImmutableList<OptionElement> options;
    private final ImmutableList<EnumConstantElement> constants;

    private AutoValue_EnumElement(Location location, String name, String documentation, ImmutableList<OptionElement> options, ImmutableList<EnumConstantElement> constants) {
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        this.location = location;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        if (documentation == null) {
            throw new NullPointerException("Null documentation");
        }
        this.documentation = documentation;
        if (options == null) {
            throw new NullPointerException("Null options");
        }
        this.options = options;
        if (constants == null) {
            throw new NullPointerException("Null constants");
        }
        this.constants = constants;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public ImmutableList<OptionElement> options() {
        return this.options;
    }

    @Override
    public ImmutableList<EnumConstantElement> constants() {
        return this.constants;
    }

    public String toString() {
        return "EnumElement{location=" + this.location + ", name=" + this.name + ", documentation=" + this.documentation + ", options=" + this.options + ", constants=" + this.constants + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnumElement) {
            EnumElement that = (EnumElement)o;
            return this.location.equals(that.location()) && this.name.equals(that.name()) && this.documentation.equals(that.documentation()) && this.options.equals(that.options()) && this.constants.equals(that.constants());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.documentation.hashCode();
        h *= 1000003;
        h ^= this.options.hashCode();
        h *= 1000003;
        return h ^= this.constants.hashCode();
    }

    static final class Builder
    implements EnumElement.Builder {
        private Location location;
        private String name;
        private String documentation;
        private ImmutableList<OptionElement> options;
        private ImmutableList<EnumConstantElement> constants;

        Builder() {
        }

        Builder(EnumElement source) {
            this.location = source.location();
            this.name = source.name();
            this.documentation = source.documentation();
            this.options = source.options();
            this.constants = source.constants();
        }

        @Override
        public EnumElement.Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public EnumElement.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public EnumElement.Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public EnumElement.Builder options(ImmutableList<OptionElement> options) {
            this.options = options;
            return this;
        }

        @Override
        public EnumElement.Builder constants(ImmutableList<EnumConstantElement> constants) {
            this.constants = constants;
            return this;
        }

        @Override
        public EnumElement build() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.documentation == null) {
                missing = missing + " documentation";
            }
            if (this.options == null) {
                missing = missing + " options";
            }
            if (this.constants == null) {
                missing = missing + " constants";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EnumElement(this.location, this.name, this.documentation, this.options, this.constants);
        }
    }
}

