/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_ServiceElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.internal.protoparser.RpcElement;
import com.squareup.wire.schema.Location;

public abstract class ServiceElement {
    public static Builder builder(Location location) {
        return new AutoValue_ServiceElement.Builder().location(location).documentation("").rpcs((ImmutableList<RpcElement>)ImmutableList.of()).options((ImmutableList<OptionElement>)ImmutableList.of());
    }

    public abstract Location location();

    public abstract String name();

    public abstract String documentation();

    public abstract ImmutableList<RpcElement> rpcs();

    public abstract ImmutableList<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("service ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Util.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.rpcs().isEmpty()) {
            builder.append('\n');
            for (RpcElement rpc : this.rpcs()) {
                Util.appendIndented(builder, rpc.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder rpcs(ImmutableList<RpcElement> var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public ServiceElement build();
    }
}

