/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.TypeAdapter;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

final class SchemaTypeAdapterFactory {
    final Schema schema;
    final Map<Type.Name, TypeAdapter<?>> adapterMap = new LinkedHashMap();

    public SchemaTypeAdapterFactory(Schema schema) {
        this.schema = schema;
        this.adapterMap.put(Type.Name.BOOL, TypeAdapter.BOOL);
        this.adapterMap.put(Type.Name.BYTES, TypeAdapter.BYTES);
        this.adapterMap.put(Type.Name.DOUBLE, TypeAdapter.DOUBLE);
        this.adapterMap.put(Type.Name.FLOAT, TypeAdapter.FLOAT);
        this.adapterMap.put(Type.Name.FIXED32, TypeAdapter.FIXED32);
        this.adapterMap.put(Type.Name.FIXED64, TypeAdapter.FIXED64);
        this.adapterMap.put(Type.Name.INT32, TypeAdapter.INT32);
        this.adapterMap.put(Type.Name.INT64, TypeAdapter.INT64);
        this.adapterMap.put(Type.Name.SFIXED32, TypeAdapter.SFIXED32);
        this.adapterMap.put(Type.Name.SFIXED64, TypeAdapter.SFIXED64);
        this.adapterMap.put(Type.Name.SINT32, TypeAdapter.SINT32);
        this.adapterMap.put(Type.Name.SINT64, TypeAdapter.SINT64);
        this.adapterMap.put(Type.Name.STRING, TypeAdapter.STRING);
        this.adapterMap.put(Type.Name.UINT32, TypeAdapter.UINT32);
        this.adapterMap.put(Type.Name.UINT64, TypeAdapter.UINT64);
    }

    public TypeAdapter<Map<String, Object>> get(Type.Name typeName) {
        MessageType type = (MessageType)this.schema.getType(typeName);
        SchemaMessageAdapter messageAdapter = new SchemaMessageAdapter();
        for (Field field : type.fields()) {
            messageAdapter.fieldAdapters.put(field.tag(), new FieldAdapter(field.name(), field.isRepeated(), this.getTypeAdapter(field.type())));
        }
        return messageAdapter;
    }

    private synchronized TypeAdapter<?> getTypeAdapter(Type.Name typeName) {
        TypeAdapter<Map<String, Object>> result = this.adapterMap.get(typeName);
        if (result == null) {
            Type type = this.schema.getType(typeName);
            if (type instanceof EnumType) {
                result = new TypeAdapter<Map<String, Object>>((EnumType)type);
            } else if (type instanceof MessageType) {
                result = this.get(typeName);
            } else {
                throw new IllegalArgumentException("unexpected type: " + typeName);
            }
            this.adapterMap.put(typeName, result);
        }
        return result;
    }

    static class FieldAdapter {
        final String name;
        final boolean repeated;
        final TypeAdapter<?> typeAdapter;

        public FieldAdapter(String name, boolean repeated, TypeAdapter<?> typeAdapter) {
            this.name = name;
            this.repeated = repeated;
            this.typeAdapter = typeAdapter;
        }
    }

    static final class SchemaMessageAdapter
    extends TypeAdapter<Map<String, Object>> {
        final Map<Integer, FieldAdapter> fieldAdapters = new LinkedHashMap<Integer, FieldAdapter>();

        public SchemaMessageAdapter() {
            super(FieldEncoding.LENGTH_DELIMITED, Map.class);
        }

        public Map<String, Object> redact(Map<String, Object> message) {
            throw new UnsupportedOperationException();
        }

        public int encodedSize(Map<String, Object> value) {
            throw new UnsupportedOperationException();
        }

        public void write(ProtoWriter writer, Map<String, Object> value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> read(ProtoReader reader) throws IOException {
            int tag;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            long token = reader.beginMessage();
            while ((tag = reader.nextTag()) != -1) {
                FieldAdapter fieldAdapter = this.fieldAdapters.get(tag);
                if (fieldAdapter == null) {
                    fieldAdapter = new FieldAdapter(Integer.toString(tag), true, reader.peekFieldEncoding().rawTypeAdapter());
                }
                Object value = fieldAdapter.typeAdapter.read(reader);
                if (fieldAdapter.repeated) {
                    ArrayList<Object> values = (ArrayList<Object>)result.get(fieldAdapter.name);
                    if (values == null) {
                        values = new ArrayList<Object>();
                        result.put(fieldAdapter.name, values);
                    }
                    values.add(value);
                    continue;
                }
                result.put(fieldAdapter.name, value);
            }
            reader.endMessage(token);
            return result;
        }

        public String toString(Map<String, Object> value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class SchemaEnumAdapter
    extends TypeAdapter<Object> {
        final EnumType enumType;

        public SchemaEnumAdapter(EnumType enumType) {
            super(FieldEncoding.VARINT, Object.class);
            this.enumType = enumType;
        }

        public int encodedSize(Object value) {
            throw new UnsupportedOperationException();
        }

        public void write(ProtoWriter writer, Object value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object read(ProtoReader reader) throws IOException {
            Integer value = (Integer)TypeAdapter.UINT32.read(reader);
            EnumConstant constant = this.enumType.constant(value);
            return constant != null ? constant.name() : value;
        }
    }
}

